/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends BasicTreeNode {
    private CodeNode[] myChildren;
    private final int myCost;
    private final DupInfo myDuplicates;
    private final int myIndex;

    public GroupNode(DuplicatesRoot duplicatesRoot, DupInfo duplicates, int index) {
        super(true, duplicatesRoot);
        this.myDuplicates = duplicates;
        this.myIndex = index;
        this.myCost = duplicates.getPatternCost(index);
    }

    protected CodeNode[] getChildren() {
        if (this.myChildren == null) {
            UsageInfo[] usageInfoArray = this.myDuplicates.getUsageOccurences(this.myIndex);
            PsiFragment[] psiFragmentArray = this.myDuplicates.getFragmentOccurences(this.myIndex);
            CodeNode[] codeNodeArray = new CodeNode[usageInfoArray.length];
            for (int i2 = 0; i2 < codeNodeArray.length; ++i2) {
                codeNodeArray[i2] = new CodeNode(this, psiFragmentArray[i2], usageInfoArray[i2], i2 + 1);
            }
            this.myChildren = codeNodeArray;
        }
        return this.myChildren;
    }

    @Override
    public CodeNode getChildAt(int childIndex) {
        return (CodeNode)super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myDuplicates.getPatternDensity(this.myIndex);
    }

    @Override
    public DuplicatesRoot getParent() {
        return (DuplicatesRoot)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return this.myDuplicates.getPatternDensity(this.myIndex) == 0;
    }

    public CellAppearanceEx getTitle(boolean sel) {
        int n2;
        int n3 = this.getChildCount();
        if (this.myChildren != null) {
            for (CodeNode codeNode : this.myChildren) {
                if (codeNode.isValid()) continue;
                return CompositeAppearance.single((String)DupLocatorBundle.message((String)"duplicates.partially.valid.group.node", (Object[])new Object[]{n3}), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
            }
        }
        if ((n2 = this.myDuplicates.getFileCount(this.myIndex)) == 1) {
            CompositeAppearance.DequeEnd dequeEnd = new CompositeAppearance().getEnding();
            dequeEnd.addText(DupLocatorBundle.message((String)"duplicates.single.file.group.node", (Object[])new Object[]{n3, this.myCost, this.myDuplicates.getTitle(this.myIndex)}), BasicTreeNode.getTextAttributes(sel));
            dequeEnd.addComment(this.myDuplicates.getComment(this.myIndex), BasicTreeNode.getCommentAttributes(sel));
            return dequeEnd.getAppearance();
        }
        return CompositeAppearance.single((String)DupLocatorBundle.message((String)"duplicates.multiple.files.group.node", (Object[])new Object[]{n3, this.myCost, n2}), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    public int getIndexOf(CodeNode codeNode) {
        for (int i2 = 0; i2 < this.myChildren.length; ++i2) {
            CodeNode codeNode2 = this.myChildren[i2];
            if (!Comparing.equal((Object)codeNode2, (Object)codeNode)) continue;
            return i2;
        }
        return -1;
    }

    public Set<VirtualFile> getAffectedFiles() {
        PsiFragment[] psiFragmentArray;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        for (PsiFragment psiFragment : psiFragmentArray = this.myDuplicates.getFragmentOccurences(this.myIndex)) {
            PsiFile psiFile = psiFragment.getFile();
            if (psiFile == null) continue;
            hashSet.add(psiFile.getVirtualFile());
        }
        return hashSet;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return DuplicatesPresentation.Service.findPresentationForDuplicate(this.myDuplicates, this.myIndex);
    }
}

