/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    @Override
    protected boolean isSelected(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            AbstractLayoutAction.b(0);
        }
        if (project == null) {
            AbstractLayoutAction.b(1);
        }
        if (event == null) {
            AbstractLayoutAction.b(2);
        }
        if ((graphBuilder = this.getBuilder(event)) == null) {
            return false;
        }
        return graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayouter() == this.getLayouter(project, graphBuilder);
    }

    @Override
    protected void setSelected(@NotNull Graph2D graph, boolean state, @NotNull Project project, @NotNull AnActionEvent e2) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            AbstractLayoutAction.b(3);
        }
        if (project == null) {
            AbstractLayoutAction.b(4);
        }
        if (e2 == null) {
            AbstractLayoutAction.b(5);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        Layouter layouter = graphBuilder.getGraphPresentationModel().getSettings().getCurrentLayouter();
        Layouter layouter2 = this.getLayouter(graphBuilder.getProject(), graphBuilder);
        GraphLayoutService.getInstance().calcLayoutAsync(graphBuilder, layouter2).thenAcceptAsync(graphLayout -> GraphUndoService.getInstance().performPositionsOnlyChangingAction(graphBuilder, this.getLayoutName(), () -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayouter(layouter2);
            this.beforeLayoutPerformed(layouter2, graphBuilder);
            GraphLayoutService.getInstance().queryLayout(graphBuilder).animated().withCustomLayout((GraphLayout)graphLayout).run();
            this.afterLayoutPerformed(layouter2, graphBuilder);
        }, runnable -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayouter(layouter);
            runnable.run();
        }, runnable -> {
            graphBuilder.getGraphPresentationModel().getSettings().setCurrentLayouter(this.getLayouter(graphBuilder.getProject(), graphBuilder));
            runnable.run();
        }), Futures.inEdt());
    }

    @Override
    @Nullable
    @NlsActions.ActionText
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractLayoutAction.b(6);
        }
        return this.getLayoutName();
    }

    @Override
    protected boolean isEnabled(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> graphBuilder;
        if (graph == null) {
            AbstractLayoutAction.b(7);
        }
        if (project == null) {
            AbstractLayoutAction.b(8);
        }
        if (event == null) {
            AbstractLayoutAction.b(9);
        }
        return (graphBuilder = this.getBuilder(event)) != null && graph.nodeCount() > 0 && GraphLayoutService.getInstance().canLayout(graphBuilder, this.getLayouter(graphBuilder.getProject(), graphBuilder));
    }

    protected abstract Layouter getLayouter(Project var1, @NotNull GraphBuilder<?, ?> var2);

    @NlsActions.ActionText
    protected abstract String getLayoutName();

    protected boolean areBridgesPreferred() {
        return true;
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            AbstractLayoutAction.b(10);
        }
        if (builder == null) {
            AbstractLayoutAction.b(11);
        }
        builder.getGraphPresentationModel().getSettings().setShowBridges(this.areBridgesPreferred());
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            AbstractLayoutAction.b(12);
        }
        if (builder == null) {
            AbstractLayoutAction.b(13);
        }
        builder.getEditMode().setOrthogonalEdgeRouting(GraphLayoutService.getInstance().doesImplyOrthogonalEdgeRouting(layouter));
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractLayoutAction.b(14);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeLayoutPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterLayoutPerformed";
                break;
            }
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

