/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.AutoRotationSliderEdgeLabelModel;
import com.intellij.openapi.graph.view.BridgeCalculator;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultGraph2DRenderer;
import com.intellij.openapi.graph.view.Drawable;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DNodeRealizer;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.GraphBuilderDisplay;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public class BasicGraphPresentationModel<N, E>
extends GraphPresentationModel<N, E> {
    @NotNull
    public static final String USE_ANTIALIAING_REGKEY = "diagrams.rendering.antialiasing";
    @NotNull
    private volatile Graph myGraph;
    @Nullable
    private volatile GraphBuilder<N, E> myGraphBuilder;
    @NotNull
    private final GraphSettings mySettings;
    @NotNull
    protected final AtomicBoolean myIsDisposed;

    public BasicGraphPresentationModel(@NotNull Graph graph) {
        if (graph == null) {
            BasicGraphPresentationModel.b(0);
        }
        this.mySettings = new GraphSettings();
        this.myIsDisposed = new AtomicBoolean(false);
        this.myGraph = graph;
    }

    public BasicGraphPresentationModel(@NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            BasicGraphPresentationModel.b(1);
        }
        this.mySettings = new GraphSettings();
        this.myIsDisposed = new AtomicBoolean(false);
        this.myGraph = graphBuilder.getGraph();
        this.myGraphBuilder = graphBuilder;
    }

    @NotNull
    public Graph getGraph() {
        Graph graph = this.myGraph;
        if (graph == null) {
            BasicGraphPresentationModel.b(2);
        }
        return graph;
    }

    public void setGraph(@NotNull Graph graph) {
        if (graph == null) {
            BasicGraphPresentationModel.b(3);
        }
        this.myGraph = graph;
    }

    @NotNull
    public GraphBuilder<N, E> getGraphBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myGraphBuilder;
        assert (graphBuilder != null) : "Forgot to set graphBuilder";
        GraphBuilder<N, E> graphBuilder2 = graphBuilder;
        if (graphBuilder2 == null) {
            BasicGraphPresentationModel.b(4);
        }
        return graphBuilder2;
    }

    public void setGraphBuilder(@NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            BasicGraphPresentationModel.b(5);
        }
        this.myGraphBuilder = graphBuilder;
    }

    @Override
    @NotNull
    public GraphSettings getSettings() {
        GraphSettings graphSettings = this.mySettings;
        if (graphSettings == null) {
            BasicGraphPresentationModel.b(6);
        }
        return graphSettings;
    }

    @Override
    @NotNull
    public NodeRealizer getNodeRealizer(@Nullable N n2) {
        Graph2DNodeRealizer graph2DNodeRealizer = GraphManager.getGraphManager().createGraph2DNodeRealizer();
        if (graph2DNodeRealizer == null) {
            BasicGraphPresentationModel.b(7);
        }
        return graph2DNodeRealizer;
    }

    @Override
    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable E e2) {
        PolyLineEdgeRealizer polyLineEdgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        polyLineEdgeRealizer.setLineType(LineType.LINE_1);
        polyLineEdgeRealizer.setLineColor((Color)JBColor.GRAY);
        polyLineEdgeRealizer.setArrow(Arrow.STANDARD);
        PolyLineEdgeRealizer polyLineEdgeRealizer2 = polyLineEdgeRealizer;
        if (polyLineEdgeRealizer2 == null) {
            BasicGraphPresentationModel.b(8);
        }
        return polyLineEdgeRealizer2;
    }

    @Override
    @Nullable
    public String getNodeTooltip(@Nullable N n2) {
        return null;
    }

    @Override
    @Nullable
    public String getEdgeTooltip(@Nullable E e2) {
        return null;
    }

    @Override
    public boolean editNode(@Nullable N n2) {
        return false;
    }

    @Override
    public boolean editEdge(@Nullable E e2) {
        return false;
    }

    @Override
    @Nullable
    public NodeCellEditor getCustomNodeCellEditor(@Nullable N n2) {
        return null;
    }

    @Override
    @NotNull
    public DefaultActionGroup getNodeActionGroup(@Nullable N n2) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.b(9);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public DefaultActionGroup getEdgeActionGroup(@Nullable E e2) {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.b(10);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public DefaultActionGroup getPaperActionGroup() {
        DefaultActionGroup defaultActionGroup = this.getCommonActionGroup();
        if (defaultActionGroup == null) {
            BasicGraphPresentationModel.b(11);
        }
        return defaultActionGroup;
    }

    @NotNull
    protected DefaultActionGroup getCommonActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add(AbstractGraphAction.getCommonPopupActions());
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup;
        if (defaultActionGroup2 == null) {
            BasicGraphPresentationModel.b(12);
        }
        return defaultActionGroup2;
    }

    public void dispose() {
        if (this.myIsDisposed.compareAndSet(false, true)) {
            GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
            Set set = factory.getAvailableConfigurations();
            for (Object object : ArrayUtil.toObjectArray((Collection)set)) {
                if (!(object instanceof String)) continue;
                factory.removeConfiguration((String)object);
            }
        }
    }

    @Override
    public EdgeLabel @NotNull [] getEdgeLabels(@Nullable E e2, @NotNull String edgeName) {
        if (edgeName == null) {
            BasicGraphPresentationModel.b(13);
        }
        EdgeLabel edgeLabel = this.createLabel(edgeName);
        if (this.isAutoRotateLabels()) {
            AutoRotationSliderEdgeLabelModel autoRotationSliderEdgeLabelModel = GraphManager.getGraphManager().createAutoRotationSliderEdgeLabelModel();
            autoRotationSliderEdgeLabelModel.setDistance(-15.0);
            edgeLabel.setLabelModel(autoRotationSliderEdgeLabelModel);
            edgeLabel.setModelParameter(autoRotationSliderEdgeLabelModel.getDefaultParameter());
        }
        EdgeLabel[] edgeLabelArray = new EdgeLabel[]{edgeLabel};
        if (edgeLabelArray == null) {
            BasicGraphPresentationModel.b(14);
        }
        return edgeLabelArray;
    }

    @NotNull
    protected EdgeLabel createLabel(@NotNull String edgeName) {
        if (edgeName == null) {
            BasicGraphPresentationModel.b(15);
        }
        EdgeLabel edgeLabel = GraphManager.getGraphManager().createEdgeLabel(edgeName, EdgeLabel.TWO_POS);
        edgeLabel.setPosition(EdgeLabel.HEAD);
        edgeLabel.setFontSize(10);
        edgeLabel.setFontStyle(2);
        EdgeLabel edgeLabel2 = edgeLabel;
        if (edgeLabel2 == null) {
            BasicGraphPresentationModel.b(16);
        }
        return edgeLabel2;
    }

    @Nullable
    public BridgeCalculator createBridgeCalculator() {
        BridgeCalculator bridgeCalculator = GraphManager.getGraphManager().createBridgeCalculator();
        bridgeCalculator.setCrossingStyle(BridgeCalculator.CROSSING_STYLE_ARC);
        bridgeCalculator.setCrossingMode(BridgeCalculator.CROSSING_MODE_HORIZONTAL_CROSSES_VERTICAL);
        bridgeCalculator.setOrientationStyle(BridgeCalculator.ORIENTATION_STYLE_UP);
        bridgeCalculator.setBridgeWidth(10.0);
        return bridgeCalculator;
    }

    public void setupBridgesFor(@NotNull Graph2DRenderer backgroundRenderer) {
        if (backgroundRenderer == null) {
            BasicGraphPresentationModel.b(17);
        }
        if (backgroundRenderer instanceof DefaultGraph2DRenderer) {
            BridgeCalculator bridgeCalculator = this.getSettings().isShowBridges() ? this.createBridgeCalculator() : null;
            ((DefaultGraph2DRenderer)backgroundRenderer).setBridgeCalculator(bridgeCalculator);
        }
    }

    @NotNull
    public GraphBuilderDisplay getGraphViewDisplay() {
        throw new UnsupportedOperationException();
    }

    @Override
    @RequiresEdt
    public void customizeSettings(@NotNull Graph2DView view, @NotNull EditMode editMode) {
        if (view == null) {
            BasicGraphPresentationModel.b(18);
        }
        if (editMode == null) {
            BasicGraphPresentationModel.b(19);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.customizeSettings(this.getGraphBuilder());
    }

    @Override
    public void customizeSettings(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            BasicGraphPresentationModel.b(20);
        }
        Graph2DView graph2DView = builder.getView();
        graph2DView.setAntialiasedPainting(Registry.is((String)USE_ANTIALIAING_REGKEY));
        BasicGraphPresentationModel.setupNonAntialiasedBackgroundRenderer(graph2DView);
        GraphLayoutService.getInstance().setupDataProvidersForEdgesMerging(builder);
    }

    @Override
    @NotNull
    public EdgeCreationPolicy<N> getEdgeCreationPolicy() {
        EdgeCreationPolicy<?> edgeCreationPolicy = EdgeCreationPolicy.EVERYTHING_ACCEPTED_POLICY;
        if (edgeCreationPolicy == null) {
            BasicGraphPresentationModel.b(21);
        }
        return edgeCreationPolicy;
    }

    @Override
    @Nullable
    public DeleteProvider<?, ?> getDeleteProvider() {
        return null;
    }

    public boolean isAutoRotateLabels() {
        return false;
    }

    @Override
    @NotNull
    public String getActionPlace() {
        return "EditorPopup";
    }

    public static void setupNonAntialiasedBackgroundRenderer(@NotNull Graph2DView view) {
        if (view == null) {
            BasicGraphPresentationModel.b(22);
        }
        DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)view.getBackgroundRenderer();
        DefaultBackgroundRenderer defaultBackgroundRenderer2 = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        defaultBackgroundRenderer2.setColor(defaultBackgroundRenderer.getColor());
        defaultBackgroundRenderer2.setMode(defaultBackgroundRenderer.getMode());
        view.setBackgroundRenderer(defaultBackgroundRenderer2);
        view.addBackgroundDrawable(new Drawable(){

            @Override
            public void paint(Graphics2D g2) {
                if (Registry.is((String)BasicGraphPresentationModel.USE_ANTIALIAING_REGKEY)) {
                    GraphicsUtil.setupAAPainting((Graphics)g2);
                }
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, 0, 0, 0);
            }
        });
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 4, 6, 7, 8, 9, 10, 11, 12, 14, 16, 21 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphBuilder";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BasicGraphPresentationModel";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundRenderer";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BasicGraphPresentationModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeActionGroup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeActionGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaperActionGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonActionGroup";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeLabels";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeCreationPolicy";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 21: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGraph";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setGraphBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeLabels";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupBridgesFor";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupNonAntialiasedBackgroundRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 8, 9, 10, 11, 12, 14, 16, 21 -> new IllegalStateException(string);
        };
    }
}

