/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicNodesGroup
extends NodesGroup {
    private final @NlsContexts.Label String myGroupName;
    private NodesGroup myParent;
    private boolean myClosed;

    public BasicNodesGroup(@NotNull String groupName) {
        if (groupName == null) {
            BasicNodesGroup.b(0);
        }
        this(groupName, null);
    }

    public BasicNodesGroup(String groupName, NodesGroup parent) {
        this.myGroupName = groupName;
        this.myParent = parent;
        this.myClosed = true;
    }

    @Override
    @NlsContexts.Label
    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            BasicNodesGroup.b(1);
        }
        return string;
    }

    @Override
    @Nullable
    public GroupNodeRealizer createGroupNodeRealizer() {
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setInnerGraphDisplayEnabled(true);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setLabelText(this.getGroupName());
        groupNodeRealizer.setOpenGroupIcon(AllIcons.Nodes.Package);
        groupNodeRealizer.setClosedGroupIcon(AllIcons.Nodes.Package);
        groupNodeRealizer.setFillColor(UIUtil.getLabelBackground());
        NodeLabel nodeLabel = groupNodeRealizer.getLabel();
        nodeLabel.setBackgroundColor((Color)JBColor.lightGray);
        nodeLabel.setTextColor(JBColor.foreground());
        return groupNodeRealizer;
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @Override
    @Nullable
    public NodesGroup getParent() {
        return this.myParent;
    }

    public void setParent(NodesGroup parent) {
        this.myParent = parent;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BasicNodesGroup basicNodesGroup = (BasicNodesGroup)o2;
        return this.myGroupName.equals(basicNodesGroup.myGroupName);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myGroupName.hashCode();
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/components/BasicNodesGroup";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/components/BasicNodesGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

