/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.services;

import com.intellij.openapi.graph.EdgeRealizerProvider;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.LabelLayoutConstants;
import com.intellij.openapi.graph.layout.PreferredPlacementDescriptor;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import org.jetbrains.annotations.NotNull;

public final class GraphEdgeRealizerService {
    @NotNull
    private static final GraphEdgeRealizerService INSTANCE = new GraphEdgeRealizerService();
    @NotNull
    private final EdgeRealizerProvider myArcEdgeRealizerProvider = GraphManager.getGraphManager()::createArcEdgeRealizer;
    @NotNull
    private final EdgeRealizerProvider myBezierEdgeRealizerProvider = GraphManager.getGraphManager()::createBezierEdgeRealizer;
    @NotNull
    private final EdgeRealizerProvider mySplineEdgeRealizerProvider = GraphManager.getGraphManager()::createSplineEdgeRealizer;
    @NotNull
    private final EdgeRealizerProvider myQuadCurveEdgeRealizerProvider = GraphManager.getGraphManager()::createQuadCurveEdgeRealizer;
    @NotNull
    private final EdgeRealizerProvider myStraightPolylineEdgeRealizerProvider = GraphManager.getGraphManager()::createPolyLineEdgeRealizer;
    @NotNull
    private final EdgeRealizerProvider mySmoothedPolylineEdgeRealizerProvider = () -> {
        PolyLineEdgeRealizer polyLineEdgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        polyLineEdgeRealizer.setSmoothedBends(true);
        return polyLineEdgeRealizer;
    };
    @NotNull
    private final PreferredPlacementDescriptor myUpperSourceDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_SOURCE, LabelLayoutConstants.PLACE_LEFT_OF_EDGE);
    @NotNull
    private final PreferredPlacementDescriptor myUpperCenterDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_CENTER, LabelLayoutConstants.PLACE_LEFT_OF_EDGE);
    @NotNull
    private final PreferredPlacementDescriptor myUpperTargetDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_TARGET, LabelLayoutConstants.PLACE_LEFT_OF_EDGE);
    @NotNull
    private final PreferredPlacementDescriptor myBottomSourceDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_SOURCE, LabelLayoutConstants.PLACE_RIGHT_OF_EDGE);
    @NotNull
    private final PreferredPlacementDescriptor myBottomCenterDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_CENTER, LabelLayoutConstants.PLACE_RIGHT_OF_EDGE);
    @NotNull
    private final PreferredPlacementDescriptor myBottomTargetDescriptor = GraphEdgeRealizerService.p(LabelLayoutConstants.PLACE_AT_TARGET, LabelLayoutConstants.PLACE_RIGHT_OF_EDGE);

    private GraphEdgeRealizerService() {
    }

    @NotNull
    private static PreferredPlacementDescriptor p(byte by2, byte by3) {
        PreferredPlacementDescriptor preferredPlacementDescriptor = GraphManager.getGraphManager().createPreferredPlacementDescriptor();
        preferredPlacementDescriptor.setPlaceAlongEdge(by2);
        preferredPlacementDescriptor.setSideOfEdge(by3);
        preferredPlacementDescriptor.setSideReference(PreferredPlacementDescriptor.SIDE_IS_ABSOLUTE_WITH_LEFT_IN_NORTH);
        preferredPlacementDescriptor.freeze();
        PreferredPlacementDescriptor preferredPlacementDescriptor2 = preferredPlacementDescriptor;
        if (preferredPlacementDescriptor2 == null) {
            GraphEdgeRealizerService.p(0);
        }
        return preferredPlacementDescriptor2;
    }

    @NotNull
    public static GraphEdgeRealizerService getInstance() {
        GraphEdgeRealizerService graphEdgeRealizerService = INSTANCE;
        if (graphEdgeRealizerService == null) {
            GraphEdgeRealizerService.p(1);
        }
        return graphEdgeRealizerService;
    }

    @NotNull
    public EdgeRealizerProvider getArcEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myArcEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(2);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public EdgeRealizerProvider getBezierEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myBezierEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(3);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public EdgeRealizerProvider getSplineEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.mySplineEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(4);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public EdgeRealizerProvider getQuadCurveEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myQuadCurveEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(5);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public EdgeRealizerProvider getStraightPolylineEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.myStraightPolylineEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(6);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public EdgeRealizerProvider getSmoothedPolylineEdgeRealizerProvider() {
        EdgeRealizerProvider edgeRealizerProvider = this.mySmoothedPolylineEdgeRealizerProvider;
        if (edgeRealizerProvider == null) {
            GraphEdgeRealizerService.p(7);
        }
        return edgeRealizerProvider;
    }

    @NotNull
    public PreferredPlacementDescriptor getUpperSourceDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myUpperSourceDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(8);
        }
        return preferredPlacementDescriptor;
    }

    @NotNull
    public PreferredPlacementDescriptor getUpperCenterDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myUpperCenterDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(9);
        }
        return preferredPlacementDescriptor;
    }

    @NotNull
    public PreferredPlacementDescriptor getUpperTargetDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myUpperTargetDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(10);
        }
        return preferredPlacementDescriptor;
    }

    @NotNull
    public PreferredPlacementDescriptor getBottomSourceDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myBottomSourceDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(11);
        }
        return preferredPlacementDescriptor;
    }

    @NotNull
    public PreferredPlacementDescriptor getBottomCenterDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myBottomCenterDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(12);
        }
        return preferredPlacementDescriptor;
    }

    @NotNull
    public PreferredPlacementDescriptor getBottomTargetDescriptor() {
        PreferredPlacementDescriptor preferredPlacementDescriptor = this.myBottomTargetDescriptor;
        if (preferredPlacementDescriptor == null) {
            GraphEdgeRealizerService.p(13);
        }
        return preferredPlacementDescriptor;
    }

    public void copyEdgeLayout(@NotNull EdgeRealizer src, @NotNull EdgeRealizer dst) {
        if (src == null) {
            GraphEdgeRealizerService.p(14);
        }
        if (dst == null) {
            GraphEdgeRealizerService.p(15);
        }
        dst.clearPoints();
        dst.setSourcePoint(src.getSourcePoint());
        dst.setTargetPoint(src.getTargetPoint());
        for (int i2 = 0; i2 < src.pointCount(); ++i2) {
            YPoint yPoint = src.getPoint(i2);
            dst.addPoint(yPoint.getX(), yPoint.getY());
        }
    }

    private static /* synthetic */ void p(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 2;
            case 14, 15 -> 3;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/services/GraphEdgeRealizerService";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlacementDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArcEdgeRealizerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBezierEdgeRealizerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplineEdgeRealizerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuadCurveEdgeRealizerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStraightPolylineEdgeRealizerProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmoothedPolylineEdgeRealizerProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperSourceDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperCenterDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpperTargetDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomSourceDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomCenterDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomTargetDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/services/GraphEdgeRealizerService";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyEdgeLayout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalStateException(string);
            case 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

