/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.util.EventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGraphViewControllerMode
extends ViewMode
implements FocusListener {
    protected static final int OUR_NODE_MOVEMENT_SPEED = 20;
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    @NotNull
    private final EventDispatcher<GraphBuilderListener> myDispatcher;
    @NotNull
    private final EditMode myEditMode;
    @NotNull
    private final NavigationMode myNaviMode;
    @NotNull
    private final MagnifierViewMode myZoomMode;
    @Nullable
    private MouseEvent myLastMouseEvent;

    public BaseGraphViewControllerMode(@NotNull GraphBuilder<?, ?> builder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher, @NotNull EditMode editMode, @NotNull NavigationMode navigationMode, @NotNull MagnifierViewMode zoomMode) {
        if (builder == null) {
            BaseGraphViewControllerMode.p(0);
        }
        if (dispatcher == null) {
            BaseGraphViewControllerMode.p(1);
        }
        if (editMode == null) {
            BaseGraphViewControllerMode.p(2);
        }
        if (navigationMode == null) {
            BaseGraphViewControllerMode.p(3);
        }
        if (zoomMode == null) {
            BaseGraphViewControllerMode.p(4);
        }
        this.myBuilder = builder;
        this.myDispatcher = dispatcher;
        this.myEditMode = editMode;
        this.myNaviMode = navigationMode;
        this.myZoomMode = zoomMode;
    }

    public void initialize() {
        this.setActiveMode(this.myEditMode);
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            BaseGraphViewControllerMode.p(5);
        }
        this.setLastMouseEvent(mouseEvent);
        super.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            BaseGraphViewControllerMode.p(6);
        }
        if (!this.getEditMode().isActive()) {
            this.setActiveMode(this.getEditMode());
        }
        super.mouseExited(mouseEvent);
    }

    @Override
    public void mousePressed(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            BaseGraphViewControllerMode.p(7);
        }
        this.setLastMouseEvent(mouseEvent);
        this.p(mouseEvent);
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            BaseGraphViewControllerMode.p(8);
        }
        this.setLastMouseEvent(mouseEvent);
        this.p(mouseEvent);
        super.mouseMoved(mouseEvent);
    }

    private void p(@NotNull InputEvent inputEvent) {
        if (inputEvent == null) {
            BaseGraphViewControllerMode.p(9);
        }
        if (inputEvent.isControlDown() && inputEvent.isAltDown()) {
            return;
        }
        if (inputEvent.isControlDown() && this.getChild() != this.getNaviMode()) {
            this.onCtrlTouched(false);
        } else if (!inputEvent.isControlDown() && this.getChild() == this.getNaviMode()) {
            this.onCtrlTouched(true);
        } else if (inputEvent.isAltDown() && this.getChild() != this.getZoomMode()) {
            this.onAltTouched(false);
        } else if (!inputEvent.isAltDown() && this.getChild() == this.getZoomMode()) {
            this.onAltTouched(true);
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            BaseGraphViewControllerMode.p(10);
        }
        this.setLastMouseEvent(mouseEvent);
        this.p(mouseEvent);
        super.mouseDragged(mouseEvent);
    }

    public void setupKeyBindingsTo(@NotNull JComponent component) {
        if (component == null) {
            BaseGraphViewControllerMode.p(11);
        }
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(17, 128, false), "BaseGraphViewControllerMode.17_PRESSED", actionEvent -> this.onCtrlTouched(false));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(17, 0, true), "BaseGraphViewControllerMode.17_RELEASED", actionEvent -> this.onCtrlTouched(true));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(18, 512, false), "BaseGraphViewControllerMode.18_PRESSED", actionEvent -> this.onAltTouched(false));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(18, 0, true), "BaseGraphViewControllerMode.18_RELEASED", actionEvent -> this.onAltTouched(true));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(37, 128), "BaseGraphViewControllerMode.LEFT_PRESSED", actionEvent -> this.moveNode(37));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(39, 128), "BaseGraphViewControllerMode.RIGHT_PRESSED", actionEvent -> this.moveNode(39));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(40, 128), "BaseGraphViewControllerMode.DOWN_PRESSED", actionEvent -> this.moveNode(40));
        BaseGraphViewControllerMode.setupKeyBindingTo(component, KeyStroke.getKeyStroke(38, 128), "BaseGraphViewControllerMode.UP_PRESSED", actionEvent -> this.moveNode(38));
    }

    protected static void setupKeyBindingTo(@NotNull JComponent component, @NotNull KeyStroke keyStroke, @NotNull @NonNls String actionMapKey, final @NotNull Consumer<? super ActionEvent> action) {
        if (component == null) {
            BaseGraphViewControllerMode.p(12);
        }
        if (keyStroke == null) {
            BaseGraphViewControllerMode.p(13);
        }
        if (actionMapKey == null) {
            BaseGraphViewControllerMode.p(14);
        }
        if (action == null) {
            BaseGraphViewControllerMode.p(15);
        }
        component.getInputMap(1).put(keyStroke, actionMapKey);
        component.getActionMap().put(actionMapKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                action.accept(e2);
            }
        });
    }

    protected void onAltTouched(boolean isReleased) {
        if (isReleased) {
            if (this.getChild() == this.getZoomMode()) {
                this.fireEvent(GraphBuilderEvent.GRAPH_MOVED, false);
                this.setActiveMode(this.getEditMode());
            }
        } else {
            double d2 = this.getBuilder().getZoom();
            d2 = d2 < 1.0 ? 1.5 / d2 : 1.5 * d2;
            MagnifierViewMode magnifierViewMode = this.getZoomMode();
            magnifierViewMode.setMagnifierZoomFactor(d2);
            this.setActiveMode(magnifierViewMode);
        }
    }

    protected void onCtrlTouched(boolean isReleased) {
        if (isReleased) {
            if (this.getChild() == this.getNaviMode()) {
                this.setActiveMode(this.getEditMode());
            }
        } else {
            this.setActiveMode(this.getNaviMode());
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
    }

    @Override
    public void focusLost(FocusEvent e2) {
        if (!this.getEditMode().isActive() && !this.myBuilder.isDisposed()) {
            this.setActiveMode(this.getEditMode());
        }
    }

    protected void setActiveMode(@NotNull ViewMode newMode) {
        if (newMode == null) {
            BaseGraphViewControllerMode.p(16);
        }
        BaseGraphViewControllerMode.p(this.getChild());
        this.setChild(newMode, null, null);
        this.getBuilder().setActiveMode(newMode);
        MouseEvent mouseEvent = this.getLastMouseEvent();
        if (mouseEvent != null) {
            newMode.mouseMoved(mouseEvent);
        }
    }

    private static void p(@Nullable ViewMode viewMode) {
        ArrayDeque<ViewMode> arrayDeque = new ArrayDeque<ViewMode>();
        while (viewMode != null) {
            arrayDeque.addLast(viewMode);
            viewMode = viewMode.getChild();
        }
        while (!arrayDeque.isEmpty()) {
            ((ViewMode)arrayDeque.pollLast()).reactivateParent();
        }
    }

    protected void moveNode(int key) {
        Graph2D graph2D = this.getBuilder().getGraph();
        List<Node> list = GraphSelectionService.getInstance().getSelectedNodes(graph2D);
        if (!list.isEmpty()) {
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance(this.getGraph2D());
            for (Node node : list) {
                hierarchyManager.moveToLast(node);
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(20 * (key == 37 ? -1 : (key == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(20 * (key == 38 ? -1 : (key == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.fireEvent(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            BaseGraphViewControllerMode.p(17);
        }
        if (before) {
            ((GraphBuilderListener)this.myDispatcher.getMulticaster()).beforeActionPerformed(this.myBuilder, event);
        } else {
            ((GraphBuilderListener)this.myDispatcher.getMulticaster()).actionPerformed(this.myBuilder, event);
        }
    }

    @NotNull
    protected GraphBuilder<?, ?> getBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            BaseGraphViewControllerMode.p(18);
        }
        return graphBuilder;
    }

    @NotNull
    protected EventDispatcher<GraphBuilderListener> getDispatcher() {
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myDispatcher;
        if (eventDispatcher == null) {
            BaseGraphViewControllerMode.p(19);
        }
        return eventDispatcher;
    }

    @NotNull
    protected EditMode getEditMode() {
        EditMode editMode = this.myEditMode;
        if (editMode == null) {
            BaseGraphViewControllerMode.p(20);
        }
        return editMode;
    }

    @NotNull
    protected NavigationMode getNaviMode() {
        NavigationMode navigationMode = this.myNaviMode;
        if (navigationMode == null) {
            BaseGraphViewControllerMode.p(21);
        }
        return navigationMode;
    }

    @NotNull
    protected MagnifierViewMode getZoomMode() {
        MagnifierViewMode magnifierViewMode = this.myZoomMode;
        if (magnifierViewMode == null) {
            BaseGraphViewControllerMode.p(22);
        }
        return magnifierViewMode;
    }

    @Nullable
    protected MouseEvent getLastMouseEvent() {
        return this.myLastMouseEvent;
    }

    protected void setLastMouseEvent(@Nullable MouseEvent lastMouseEvent) {
        this.myLastMouseEvent = lastMouseEvent;
    }

    private static /* synthetic */ void p(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationMode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zoomMode";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseEvent";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionMapKey";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMode";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/BaseGraphViewControllerMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/BaseGraphViewControllerMode";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatcher";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNaviMode";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getZoomMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mouseEntered";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseExited";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureThatProperModeIsActive";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mouseDragged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupKeyBindingsTo";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupKeyBindingTo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

