/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.logging;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerService;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_LOG_FILE_COUNT", "", "LOG_FILENAME_SUFFIX_FORMAT", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "LOG_PATH_DIR", "Ljava/nio/file/Path;", "millisToDate", "Ljava/time/LocalDateTime;", "millis", "", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLanguageServiceLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerServiceKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n13#2:145\n*S KotlinDebug\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerServiceKt\n*L\n21#1:145\n*E\n"})
public final class LanguageServiceLoggerServiceKt {
    @NotNull
    private static final Logger LOG;
    private static final int MAX_LOG_FILE_COUNT = 5;
    private static final DateTimeFormatter LOG_FILENAME_SUFFIX_FORMAT;
    @NotNull
    private static final Path LOG_PATH_DIR;

    @NotNull
    public static final LocalDateTime millisToDate(long millis) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Path access$getLOG_PATH_DIR$p() {
        return LOG_PATH_DIR;
    }

    public static final /* synthetic */ DateTimeFormatter access$getLOG_FILENAME_SUFFIX_FORMAT$p() {
        return LOG_FILENAME_SUFFIX_FORMAT;
    }

    static {
        boolean bl2 = false;
        Logger logger = Logger.getInstance(LanguageServiceLoggerService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        LOG_FILENAME_SUFFIX_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS");
        Path path = Path.of(PathManager.getLogPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path;
        Path path3 = path2.resolve("language-services");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        LOG_PATH_DIR = path3;
    }
}

