/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PlatformUtils;
import com.jetbrains.clones.DuplicateInspection;
import com.jetbrains.clones.DuplicateInspectionUtilKt;
import com.jetbrains.clones.DuplicateProblemDescriptor;
import com.jetbrains.clones.configuration.DuplicateInspectionConfiguration;
import com.jetbrains.clones.configuration.DuplicateInspectionState;
import com.jetbrains.clones.configuration.DuplicatesBundle;
import com.jetbrains.clones.configuration.GlobalSettings;
import com.jetbrains.clones.configuration.RestrictedDuplicateScope;
import com.jetbrains.clones.core.DuplicateAnalyzer;
import com.jetbrains.clones.core.postprocessing.DuplicatesScopeFilter;
import com.jetbrains.clones.index.HashIndexFileFilterKt;
import com.jetbrains.clones.languagescope.DuplicateScope;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import com.jetbrains.clones.structures.TextClone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J+\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010#J*\u0010$\u001a\u0004\u0018\u00010\u001d2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/jetbrains/clones/DuplicateInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "DuplicateInspection", "()V", "state", "Lcom/jetbrains/clones/configuration/DuplicateInspectionState;", "getState", "()Lcom/jetbrains/clones/configuration/DuplicateInspectionState;", "setState", "(Lcom/jetbrains/clones/configuration/DuplicateInspectionState;)V", "fullHighlighting", "", "getFullHighlighting", "()Z", "setFullHighlighting", "(Z)V", "readSettings", "", "node", "Lorg/jdom/Element;", "writeSettings", "getStaticDescription", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "p", "manger", "textClone", "Lcom/jetbrains/clones/structures/TextClone;", "scope", "Lcom/jetbrains/clones/languagescope/DuplicateScope;", "intellij.platform.duplicatesDetector"})
@SourceDebugExtension(value={"SMAP\nDuplicateInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateInspection.kt\ncom/jetbrains/clones/DuplicateInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1586#2:128\n1661#2,3:129\n1879#2,8:134\n1642#2,10:142\n1915#2:152\n1916#2:154\n1652#2:155\n1642#2,10:156\n1915#2:166\n1916#2:168\n1652#2:169\n37#3,2:132\n37#3,2:170\n37#3,2:172\n1#4:153\n1#4:167\n*S KotlinDebug\n*F\n+ 1 DuplicateInspection.kt\ncom/jetbrains/clones/DuplicateInspection\n*L\n58#1:128\n58#1:129,3\n72#1:134,8\n89#1:142,10\n89#1:152\n89#1:154\n89#1:155\n90#1:156,10\n90#1:166\n90#1:168\n90#1:169\n64#1:132,2\n92#1:170,2\n102#1:172,2\n89#1:153\n90#1:167\n*E\n"})
public final class DuplicateInspection
extends LocalInspectionTool {
    @NotNull
    private DuplicateInspectionState state = new DuplicateInspectionState();
    private boolean fullHighlighting = ApplicationManager.getApplication().isUnitTestMode();

    @NotNull
    public final DuplicateInspectionState getState() {
        return this.state;
    }

    public final void setState(@NotNull DuplicateInspectionState duplicateInspectionState) {
        Intrinsics.checkNotNullParameter((Object)duplicateInspectionState, (String)"<set-?>");
        this.state = duplicateInspectionState;
    }

    public final boolean getFullHighlighting() {
        return this.fullHighlighting;
    }

    public final void setFullHighlighting(boolean bl2) {
        this.fullHighlighting = bl2;
    }

    public void readSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.state.read(node);
    }

    public void writeSettings(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.state.write(node);
    }

    @NotNull
    public String getStaticDescription() {
        String string = CommonBundle.settingsActionPath();
        int n2 = !PlatformUtils.isIntelliJ() ? 1 : 0;
        int n3 = ApplicationManager.getApplication().isHeadlessEnvironment() ? 1 : 0;
        Object[] objectArray = new Object[]{n2, n3, string};
        return DuplicatesBundle.INSTANCE.message("duplicates.inspection.description", objectArray);
    }

    @NotNull
    public OptPane getOptionsPane() {
        List list = SequencesKt.toList((Sequence)SequencesKt.filter(DuplicateScopeExtension.Companion.findAllUniqueDuplicateScopes(), DuplicateInspection::p));
        OptPane optPane = (OptPane)list;
        boolean bl2 = false;
        OptPane optPane2 = optPane;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)optPane, (int)10));
        boolean bl3 = false;
        for (Object t2 : optPane2) {
            DuplicateScope duplicateScope = (DuplicateScope)t2;
            Collection collection2 = collection;
            boolean bl4 = false;
            collection2.add(duplicateScope.createOptions().asCheckbox("enabled", duplicateScope.getLanguageName()).prefix(duplicateScope.getClass().getCanonicalName()));
        }
        List list2 = (List)collection;
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[2];
        optRegularComponentArray[0] = OptPane.dropdown((String)"restrictedDuplicateScope", (String)DuplicatesBundle.INSTANCE.message("duplicate.settings.inspection.scope", new Object[0]), (Collection)RestrictedDuplicateScope.Companion.getOptions(), arg_0 -> DuplicateInspection.p((Function1)getOptionsPane.1.INSTANCE, arg_0), arg_0 -> DuplicateInspection.b(getOptionsPane.2.INSTANCE, arg_0));
        collection = list2;
        bl3 = false;
        Collection collection3 = collection;
        optPane2 = collection3.toArray(new OptCheckbox[0]);
        optRegularComponentArray[1] = OptPane.checkboxPanel((OptCheckbox[])Arrays.copyOf(optPane2, ((OptCheckbox[])optPane2).length));
        optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        List list;
        OptionController optionController = OptionController.empty().onValue("restrictedDuplicateScope", (KMutableProperty0)new MutablePropertyReference0Impl(this.state.getGlobalSettings()){

            public Object get() {
                return ((GlobalSettings)this.receiver).getRestrictedDuplicateScope();
            }

            public void set(Object value) {
                ((GlobalSettings)this.receiver).setRestrictedDuplicateScope((RestrictedDuplicateScope)((Object)value));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onValue(...)");
        OptionController optionController2 = optionController;
        List list2 = list = SequencesKt.toList(DuplicateScopeExtension.Companion.findAllUniqueDuplicateScopes());
        OptionController optionController3 = optionController2;
        boolean bl2 = false;
        OptionController optionController4 = optionController3;
        if (!list2.isEmpty()) {
            ListIterator listIterator = list2.listIterator(list2.size());
            while (listIterator.hasPrevious()) {
                DuplicateInspectionConfiguration duplicateInspectionConfiguration;
                OptionController optionController5 = optionController4;
                DuplicateScope duplicateScope = (DuplicateScope)listIterator.previous();
                boolean bl3 = false;
                if (this.state.findConfiguration(duplicateScope) == null) {
                    throw new IllegalStateException("No such configuration: " + duplicateScope.getClass());
                }
                Intrinsics.checkNotNullExpressionValue((Object)optionController5.onPrefix(duplicateScope.getClass().getCanonicalName(), duplicateScope.createOptionController(duplicateInspectionConfiguration).onValue("enabled", (KMutableProperty0)new MutablePropertyReference0Impl(duplicateInspectionConfiguration){

                    public Object get() {
                        return ((DuplicateInspectionConfiguration)this.receiver).isEnabled();
                    }

                    public void set(Object value) {
                        ((DuplicateInspectionConfiguration)this.receiver).setEnabled((Boolean)value);
                    }
                })), (String)"onPrefix(...)");
            }
        }
        return optionController4;
    }

    @NotNull
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Object object;
        Object object22;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)file));
        if (virtualFile == null) {
            return new ProblemDescriptor[0];
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!HashIndexFileFilterKt.isIndexed(project, virtualFile2)) {
            return new ProblemDescriptor[0];
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        DuplicateScope duplicateScope = DuplicateScopeExtension.Companion.findDuplicateScope(fileType);
        if (duplicateScope == null) {
            return new ProblemDescriptor[0];
        }
        DuplicateScope duplicateScope2 = duplicateScope;
        DuplicateInspectionConfiguration duplicateInspectionConfiguration = this.state.findConfiguration(duplicateScope2);
        if (duplicateInspectionConfiguration == null) {
            return new ProblemDescriptor[0];
        }
        DuplicateInspectionConfiguration duplicateInspectionConfiguration2 = duplicateInspectionConfiguration;
        if (!duplicateInspectionConfiguration2.isEnabled()) {
            return new ProblemDescriptor[0];
        }
        List<TextClone> list = new DuplicateAnalyzer(duplicateScope2).searchDuplicates(file, duplicateInspectionConfiguration2.getMinSize());
        Project project2 = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        DuplicatesScopeFilter duplicatesScopeFilter = new DuplicatesScopeFilter(project2);
        Iterable iterable = list;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Iterable<TextClone> iterable3 = new ArrayList();
        boolean bl3 = false;
        Iterable iterable4 = iterable2;
        boolean bl4 = false;
        for (Object object22 : iterable4) {
            TextClone textClone;
            object = object22;
            boolean bl5 = false;
            TextClone textClone2 = (TextClone)object;
            boolean bl6 = false;
            if (duplicatesScopeFilter.restrict(textClone2, this.state.getGlobalSettings().getRestrictedDuplicateScope()) == null) continue;
            boolean bl7 = false;
            iterable3.add((TextClone)textClone);
        }
        List list2 = (List)iterable3;
        Iterable iterable5 = list2;
        boolean bl8 = false;
        iterable3 = iterable5;
        Collection collection = new ArrayList();
        boolean bl9 = false;
        Iterable<TextClone> iterable6 = iterable3;
        boolean bl10 = false;
        object22 = iterable6.iterator();
        while (object22.hasNext()) {
            ProblemDescriptor problemDescriptor;
            Object object3 = object = object22.next();
            boolean bl11 = false;
            TextClone textClone = (TextClone)object3;
            boolean bl12 = false;
            if (this.p(manager, textClone, duplicateScope2, isOnTheFly) == null) continue;
            boolean bl13 = false;
            collection.add(problemDescriptor);
        }
        iterable = (List)collection;
        iterable5 = (Collection)iterable;
        bl8 = false;
        iterable3 = iterable5;
        return iterable3.toArray((ProblemDescriptor[])new ProblemDescriptor[0]);
    }

    private final ProblemDescriptor p(InspectionManager inspectionManager, TextClone textClone, DuplicateScope duplicateScope, boolean bl2) {
        String string;
        TextRange textRange;
        LocalQuickFix[] localQuickFixArray;
        Collection collection;
        Project project = inspectionManager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(textClone.getMain().getFile());
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile psiFile2 = psiFile;
        if (bl2) {
            collection = duplicateScope.createQuickFixes(project2, textClone);
            boolean bl3 = false;
            Collection collection2 = collection;
            v2 = collection2.toArray(new LocalQuickFix[0]);
        } else {
            v2 = localQuickFixArray = new LocalQuickFix[]{};
        }
        if (this.fullHighlighting) {
            textRange = textClone.getMain().getRange();
        } else {
            VirtualFile virtualFile = psiFile2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            textRange = DuplicateInspectionUtilKt.cropToOneLine(virtualFile, textClone.getMain().getRange());
        }
        collection = textRange;
        PsiElement psiElement = DuplicateInspectionUtilKt.findCommonParent(psiFile2, (TextRange)collection);
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        TextRange textRange2 = psiElement2.getTextRange();
        if (textRange2 == null) {
            return null;
        }
        int n2 = textRange2.getStartOffset();
        IntRange intRange = textClone.getMain().getLines();
        if (bl2) {
            var13_14 = new Object[]{intRange.getLast() - intRange.getFirst() + 1};
            string = DuplicatesBundle.INSTANCE.message("duplicate.inspection.problem", var13_14);
        } else {
            var13_14 = new Object[]{intRange.getFirst(), intRange.getLast()};
            string = DuplicatesBundle.INSTANCE.message("duplicate.inspection.problem.details", var13_14);
        }
        String string2 = string;
        return (ProblemDescriptor)new DuplicateProblemDescriptor(psiElement2, collection.shiftLeft(n2), string2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, textClone, bl2, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
    }

    private static final boolean p(DuplicateScope duplicateScope) {
        Intrinsics.checkNotNullParameter((Object)duplicateScope, (String)"scope");
        return duplicateScope.getIndexConfiguration().isEnabled();
    }

    private static final String p(Function1 function1, Object object) {
        return (String)function1.invoke(object);
    }

    private static final String b(Function1 function1, Object object) {
        return (String)function1.invoke(object);
    }
}

