/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.jetbrains.clones.index.HashIndexFileFilterKt;
import com.jetbrains.clones.languagescope.DuplicateScopeExtension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/clones/index/HashIndexFileFilter;", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "HashIndexFileFilter", "()V", "acceptFileType", "Lcom/intellij/util/ThreeState;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "slowPathIfFileTypeHintUnsure", "", "file", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.platform.duplicatesDetector"})
public final class HashIndexFileFilter
extends BaseFileTypeInputFilter {
    public HashIndexFileFilter() {
        super(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION);
    }

    @NotNull
    public ThreeState acceptFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (DuplicateScopeExtension.Companion.findDuplicateScope(fileType) == null) {
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        VirtualFile virtualFile = file.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return HashIndexFileFilterKt.isIndexed(project2, virtualFile);
    }
}

