/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.git;

import com.intellij.indexing.shared.git.GitHashesProjectServiceWrapperDriver;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.ultimate.git.GitBlobSet;
import com.intellij.indexing.shared.ultimate.git.GitBlobSetBuilder;
import com.intellij.indexing.shared.ultimate.git.GitHashesProjectServiceKt;
import com.intellij.indexing.shared.ultimate.git.GitHashesServiceBase;
import com.intellij.indexing.shared.ultimate.git.GitProjectRecentCommitsKt;
import com.intellij.indexing.shared.ultimate.git.ProjectGitHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0013\u001a\u00020\f2\u0014\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\f0\u0015H\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/ultimate/git/GitHashesServiceBase;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/indexing/shared/git/GitHashesProjectServiceWrapperDriver;", "project", "Lcom/intellij/openapi/project/Project;", "gitRoot", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getGitRoot", "()Ljava/nio/file/Path;", "dispose", "", "isValid", "", "gitRootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGitRootFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "resolveGitHashesInBackground", "callback", "Lkotlin/Function1;", "Lcom/intellij/indexing/shared/ultimate/git/GitBlobSet;", "resolveGitHashes", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.ultimate.git"})
@SourceDebugExtension(value={"SMAP\nGitHashesProjectService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHashesProjectService.kt\ncom/intellij/indexing/shared/ultimate/git/GitHashesServiceBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public class GitHashesServiceBase
implements Disposable,
GitHashesProjectServiceWrapperDriver {
    @NotNull
    private final Project project;
    @Nullable
    private final Path gitRoot;

    public GitHashesServiceBase(@NotNull Project project, @Nullable Path gitRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.gitRoot = gitRoot;
    }

    public /* synthetic */ GitHashesServiceBase(Project project, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = GitProjectRecentCommitsKt.resolveProjectGitRoot(project);
        }
        this(project, path);
    }

    @Nullable
    protected final Path getGitRoot() {
        return this.gitRoot;
    }

    public void dispose() {
    }

    public final boolean isValid() {
        return this.gitRoot != null && Registry.Companion.is("shared.index.git.hashes") && !this.project.isDisposed() && !this.project.isDefault();
    }

    @Nullable
    public final VirtualFile getGitRootFile() {
        VirtualFile virtualFile;
        Path path = this.gitRoot;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    public void resolveGitHashesInBackground(@NotNull Function1<? super GitBlobSet, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!this.isValid()) {
            callback.invoke(null);
            return;
        }
        if (!DumbService.Companion.isDumb(this.project)) {
            callback.invoke(null);
            return;
        }
        Project project = this.project;
        String string = SharedIndexesBundle.message((String)"progress.title.git.hashes.resolve", (Object[])new Object[0]);
        new Task.Backgroundable(callback, this, project, string){
            final /* synthetic */ Function1<GitBlobSet, Unit> $callback;
            final /* synthetic */ GitHashesServiceBase this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object2 = this;
                GitHashesServiceBase gitHashesServiceBase = this.this$0;
                try {
                    resolveGitHashesInBackground.1 $this$run_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)gitHashesServiceBase.resolveGitHashes(indicator));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                GitBlobSet result = (GitBlobSet)(Result.isFailure-impl((Object)object2) ? null : object2);
                GitHashesProjectServiceKt.access$getLOG$p().info("Collected Git Blobs: " + result);
                this.$callback.invoke((Object)result);
            }
        }.queue();
    }

    @Nullable
    public final GitBlobSet resolveGitHashes(@NotNull ProgressIndicator indicator) {
        Set gitChanged;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        if (!this.isValid()) {
            return null;
        }
        if (this.gitRoot == null) {
            return null;
        }
        VirtualFile virtualFile = this.getGitRootFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile gitRootFile = virtualFile;
        Future<GitBlobSet> listBlobs = AppExecutorUtil.getAppExecutorService().submit(() -> GitHashesServiceBase.resolveGitHashes$lambda$0(gitRootFile, this, indicator));
        Future<Set> listFiles = AppExecutorUtil.getAppExecutorService().submit(() -> GitHashesServiceBase.resolveGitHashes$lambda$1(this));
        GitBlobSet gitBlobs = (GitBlobSet)ProgressIndicatorUtils.awaitWithCheckCanceled(listBlobs);
        Set set = gitChanged = (Set)ProgressIndicatorUtils.awaitWithCheckCanceled(listFiles);
        Intrinsics.checkNotNull((Object)set);
        return gitBlobs.withIgnoredItems-Strings(set);
    }

    private static final Unit resolveGitHashes$lambda$0$0(GitHashesServiceBase this$0, GitBlobSetBuilder $builder, String relPath, String hash2) {
        Object $this$resolveGitHashes_u24lambda_u240_u240_u240;
        Intrinsics.checkNotNullParameter((Object)relPath, (String)"relPath");
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        Object object = this$0;
        try {
            $this$resolveGitHashes_u24lambda_u240_u240_u240 = object;
            boolean bl = false;
            $this$resolveGitHashes_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)StringUtil.parseHexString((String)hash2));
        }
        catch (Throwable bl) {
            $this$resolveGitHashes_u24lambda_u240_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$resolveGitHashes_u24lambda_u240_u240_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            return Unit.INSTANCE;
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        byte[] hashBytes = (byte[])object2;
        $builder.add(relPath, hashBytes);
        return Unit.INSTANCE;
    }

    private static final GitBlobSet resolveGitHashes$lambda$0(VirtualFile $gitRootFile, GitHashesServiceBase this$0, ProgressIndicator $indicator) {
        GitBlobSetBuilder builder = new GitBlobSetBuilder($gitRootFile);
        ProjectGitHelper.INSTANCE.logGitBlobHashes(this$0.project, this$0.gitRoot, $indicator, (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> GitHashesServiceBase.resolveGitHashes$lambda$0$0(this$0, builder, arg_0, arg_1)));
        return builder.build();
    }

    private static final Set resolveGitHashes$lambda$1(GitHashesServiceBase this$0) {
        return ProjectGitHelper.INSTANCE.logGitModifiedFiles(this$0.project, this$0.gitRoot);
    }
}

