/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector;

import ai.grazie.DataHolder;
import ai.grazie.detector.DetectedLanguage;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\nJ<\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\f\b\u0002\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0007J)\u0010\u0012\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0000\u00a2\u0006\u0002\b\u0016J1\u0010\u0017\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0018\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006!"}, d2={"Lai/grazie/detector/LanguageDetector;", "T", "", "<init>", "()V", "detect", "Lai/grazie/detector/LanguageDetector$DetectionResult;", "input", "isReliable", "", "(Ljava/lang/Object;Z)Lai/grazie/detector/LanguageDetector$DetectionResult;", "", "inputs", "confidenceThreshold", "", "checkCancelled", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "updateUnknownLanguages", "", "languages", "", "updateUnknownLanguages$nlp_detect", "updateUnconfidentLanguages", "confidence", "updateUnconfidentLanguages$nlp_detect", "vetoes", "detected", "Lai/grazie/nlp/langs/Language;", "(Ljava/lang/Object;Lai/grazie/nlp/langs/Language;)Z", "Type", "Companion", "DetectionResult", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nLanguageDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageDetector.kt\nai/grazie/detector/LanguageDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Runnable.kt\nkotlinx/coroutines/RunnableKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,162:1\n1557#2:163\n1628#2,3:164\n13#3:167\n12567#4,2:168\n*S KotlinDebug\n*F\n+ 1 LanguageDetector.kt\nai/grazie/detector/LanguageDetector\n*L\n87#1:163\n87#1:164,3\n86#1:167\n146#1:168,2\n*E\n"})
public abstract class LanguageDetector<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DataHolder.Key<Language> key = new DataHolder.Key<Language>(){};
    public static final double CONFIDENCE_THRESHOLD = 0.4;

    @NotNull
    public abstract DetectionResult detect(T var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<DetectionResult> detect(@NotNull List<? extends T> inputs, boolean isReliable, double confidenceThreshold, @NotNull Runnable checkCancelled) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)checkCancelled, (String)"checkCancelled");
        Iterable $this$map$iv = inputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            checkCancelled.run();
            collection.add(this.detect(it, isReliable));
        }
        List languages = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        this.updateUnknownLanguages$nlp_detect(inputs, languages);
        this.updateUnconfidentLanguages$nlp_detect(inputs, languages, confidenceThreshold);
        return languages;
    }

    public static /* synthetic */ List detect$default(LanguageDetector languageDetector, List list, boolean bl, double d, Runnable runnable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: detect");
        }
        if ((n & 4) != 0) {
            d = 0.4;
        }
        if ((n & 8) != 0) {
            boolean $i$f$Runnable = false;
            runnable = new Runnable(){

                public final void run() {
                    boolean bl = false;
                }
            };
        }
        return languageDetector.detect(list, bl, d, runnable);
    }

    public final void updateUnknownLanguages$nlp_detect(@NotNull List<? extends T> inputs, @NotNull List<DetectionResult> languages) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        int i = 0;
        while (i < languages.size()) {
            if (languages.get(i).getPreferred() == Language.UNKNOWN) {
                Language resolvedLang;
                int j;
                for (j = i; j < languages.size() && languages.get(j).getPreferred() == Language.UNKNOWN; ++j) {
                }
                Language leftLang = i > 0 ? languages.get(i - 1).getPreferred() : null;
                Language rightLang = j < languages.size() ? languages.get(j).getPreferred() : null;
                Language language = leftLang != null && leftLang == rightLang ? leftLang : (leftLang != null && rightLang == null ? leftLang : (resolvedLang = leftLang == null && rightLang != null ? rightLang : null));
                if (resolvedLang != null && !this.vetoes(inputs.get(i), resolvedLang)) {
                    int n = j;
                    for (int k = i; k < n; ++k) {
                        DetectedLanguage[] detectedLanguageArray = new DetectedLanguage[]{new DetectedLanguage(resolvedLang, 1.0)};
                        languages.set(k, new DetectionResult(Type.Neighbor, resolvedLang, detectedLanguageArray));
                    }
                }
                i = j;
                continue;
            }
            ++i;
        }
    }

    public final void updateUnconfidentLanguages$nlp_detect(@NotNull List<? extends T> inputs, @NotNull List<DetectionResult> languages, double confidence) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        int i = 1;
        int n = languages.size() - 2;
        if (i <= n) {
            while (true) {
                DetectionResult language;
                if ((language = languages.get(i)).getPreferred() != Language.UNKNOWN) {
                    DetectionResult previousLanguage = languages.get(i - 1);
                    DetectionResult nextLanguage = languages.get(i + 1);
                    if (previousLanguage.getPreferred() == nextLanguage.getPreferred() && previousLanguage.getPreferred() != Language.UNKNOWN) {
                        boolean bl;
                        Language preferredLanguage;
                        block6: {
                            preferredLanguage = previousLanguage.getPreferred();
                            DetectedLanguage[] $this$any$iv = language.getDetected();
                            boolean $i$f$any = false;
                            int n2 = $this$any$iv.length;
                            for (int j = 0; j < n2; ++j) {
                                DetectedLanguage element$iv;
                                DetectedLanguage it = element$iv = $this$any$iv[j];
                                boolean bl2 = false;
                                if (!(it.getLang() == preferredLanguage && it.getProbability() > confidence)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                        if (bl && !this.vetoes(inputs.get(i), preferredLanguage)) {
                            languages.set(i, new DetectionResult(Type.Neighbor, preferredLanguage, language.getDetected()));
                        }
                    }
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    public boolean vetoes(T input, @NotNull Language detected) {
        Intrinsics.checkNotNullParameter((Object)((Object)detected), (String)"detected");
        return false;
    }

    @JvmOverloads
    @NotNull
    public final List<DetectionResult> detect(@NotNull List<? extends T> inputs, boolean isReliable, double confidenceThreshold) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        return LanguageDetector.detect$default(this, inputs, isReliable, confidenceThreshold, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final List<DetectionResult> detect(@NotNull List<? extends T> inputs, boolean isReliable) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        return LanguageDetector.detect$default(this, inputs, isReliable, 0.0, null, 12, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/grazie/detector/LanguageDetector$Companion;", "", "<init>", "()V", "key", "Lai/grazie/DataHolder$Key;", "Lai/grazie/nlp/langs/Language;", "getKey", "()Lai/grazie/DataHolder$Key;", "CONFIDENCE_THRESHOLD", "", "nlp-detect"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataHolder.Key<Language> getKey() {
            return key;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J2\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lai/grazie/detector/LanguageDetector$DetectionResult;", "", "type", "Lai/grazie/detector/LanguageDetector$Type;", "preferred", "Lai/grazie/nlp/langs/Language;", "detected", "", "Lai/grazie/detector/DetectedLanguage;", "<init>", "(Lai/grazie/detector/LanguageDetector$Type;Lai/grazie/nlp/langs/Language;[Lai/grazie/detector/DetectedLanguage;)V", "getType", "()Lai/grazie/detector/LanguageDetector$Type;", "getPreferred", "()Lai/grazie/nlp/langs/Language;", "getDetected", "()[Lai/grazie/detector/DetectedLanguage;", "[Lai/grazie/detector/DetectedLanguage;", "component1", "component2", "component3", "copy", "(Lai/grazie/detector/LanguageDetector$Type;Lai/grazie/nlp/langs/Language;[Lai/grazie/detector/DetectedLanguage;)Lai/grazie/detector/LanguageDetector$DetectionResult;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "nlp-detect"})
    public static final class DetectionResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Type type;
        @NotNull
        private final Language preferred;
        @NotNull
        private final DetectedLanguage[] detected;

        public DetectionResult(@NotNull Type type, @NotNull Language preferred, @NotNull DetectedLanguage[] detected) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)preferred), (String)"preferred");
            Intrinsics.checkNotNullParameter((Object)detected, (String)"detected");
            this.type = type;
            this.preferred = preferred;
            this.detected = detected;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final Language getPreferred() {
            return this.preferred;
        }

        @NotNull
        public final DetectedLanguage[] getDetected() {
            return this.detected;
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        @NotNull
        public final Language component2() {
            return this.preferred;
        }

        @NotNull
        public final DetectedLanguage[] component3() {
            return this.detected;
        }

        @NotNull
        public final DetectionResult copy(@NotNull Type type, @NotNull Language preferred, @NotNull DetectedLanguage[] detected) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)preferred), (String)"preferred");
            Intrinsics.checkNotNullParameter((Object)detected, (String)"detected");
            return new DetectionResult(type, preferred, detected);
        }

        public static /* synthetic */ DetectionResult copy$default(DetectionResult detectionResult, Type type, Language language, DetectedLanguage[] detectedLanguageArray, int n, Object object) {
            if ((n & 1) != 0) {
                type = detectionResult.type;
            }
            if ((n & 2) != 0) {
                language = detectionResult.preferred;
            }
            if ((n & 4) != 0) {
                detectedLanguageArray = detectionResult.detected;
            }
            return detectionResult.copy(type, language, detectedLanguageArray);
        }

        @NotNull
        public String toString() {
            return "DetectionResult(type=" + this.type + ", preferred=" + this.preferred + ", detected=" + Arrays.toString(this.detected) + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.preferred.hashCode();
            result2 = result2 * 31 + Arrays.hashCode(this.detected);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectionResult)) {
                return false;
            }
            DetectionResult detectionResult = (DetectionResult)other;
            if (this.type != detectionResult.type) {
                return false;
            }
            if (this.preferred != detectionResult.preferred) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.detected, (Object)detectionResult.detected);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lai/grazie/detector/LanguageDetector$DetectionResult$Companion;", "", "<init>", "()V", "unknown", "Lai/grazie/detector/LanguageDetector$DetectionResult;", "type", "Lai/grazie/detector/LanguageDetector$Type;", "nlp-detect"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DetectionResult unknown(@NotNull Type type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new DetectionResult(type, Language.UNKNOWN, new DetectedLanguage[0]);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lai/grazie/detector/LanguageDetector$Type;", "", "<init>", "(Ljava/lang/String;I)V", "Rule", "List", "Ngram", "Neighbor", "nlp-detect"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type Rule = new Type();
        public static final /* enum */ Type List = new Type();
        public static final /* enum */ Type Ngram = new Type();
        public static final /* enum */ Type Neighbor = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Rule, Type.List, Type.Ngram, Type.Neighbor};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

