/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.sender;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.network.UtilsKt;
import com.intellij.stats.completion.network.service.RequestService;
import com.intellij.stats.completion.network.service.ResponseData;
import com.intellij.stats.completion.sender.DailyLimitSendingWatcher;
import com.intellij.stats.completion.sender.PersistentSentDataInfo;
import com.intellij.stats.completion.sender.StatisticSender;
import com.intellij.stats.completion.storage.FilePathProvider;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/stats/completion/sender/StatisticSenderImpl;", "Lcom/intellij/stats/completion/sender/StatisticSender;", "<init>", "()V", "limitWatcher", "Lcom/intellij/stats/completion/sender/DailyLimitSendingWatcher;", "sendStatsData", "", "url", "", "sendContent", "Lcom/intellij/stats/completion/sender/StatisticSenderImpl$SendingResult;", "file", "Ljava/io/File;", "Companion", "SendingResult", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nStatisticSenderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticSenderImpl.kt\ncom/intellij/stats/completion/sender/StatisticSenderImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n42#2,3:46\n42#2,3:51\n1915#3,2:49\n*S KotlinDebug\n*F\n+ 1 StatisticSenderImpl.kt\ncom/intellij/stats/completion/sender/StatisticSenderImpl\n*L\n22#1:46,3\n34#1:51,3\n23#1:49,2\n*E\n"})
public final class StatisticSenderImpl
implements StatisticSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DailyLimitSendingWatcher limitWatcher;
    public static final int DAILY_LIMIT = 0x1400000;

    public StatisticSenderImpl() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
        this.limitWatcher = new DailyLimitSendingWatcher(0x1400000, new PersistentSentDataInfo(propertiesComponent));
    }

    @Override
    public void sendStatsData(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        UtilsKt.assertNotEDT();
        if (this.limitWatcher.isLimitReached()) {
            return;
        }
        boolean $i$f$service = false;
        Class<FilePathProvider> serviceClass$iv = FilePathProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<File> filesToSend = ((FilePathProvider)object).getDataFiles();
        Iterable $this$forEach$iv = filesToSend;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (it.length() <= 0L || this.limitWatcher.isLimitReached()) continue;
            SendingResult result = this.sendContent(url, it);
            if (!result.isSuccessful()) {
                Integer n = result.getResponseCode();
                int n2 = 404;
                if (n != null && n == n2) continue;
            }
            it.delete();
        }
    }

    private final SendingResult sendContent(String url, File file) {
        boolean $i$f$service = false;
        Class<RequestService> serviceClass$iv = RequestService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ResponseData data = ((RequestService)object).postZipped(url, file);
        if (data != null && data.getCode() >= 200 && data.getCode() < 300) {
            if (data.getSentDataSize() != null) {
                this.limitWatcher.dataSent(data.getSentDataSize());
            }
            return new SendingResult(true, data.getCode());
        }
        ResponseData responseData = data;
        return new SendingResult(false, responseData != null ? Integer.valueOf(responseData.getCode()) : null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/stats/completion/sender/StatisticSenderImpl$Companion;", "", "<init>", "()V", "DAILY_LIMIT", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/stats/completion/sender/StatisticSenderImpl$SendingResult;", "", "isSuccessful", "", "responseCode", "", "<init>", "(ZLjava/lang/Integer;)V", "()Z", "getResponseCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(ZLjava/lang/Integer;)Lcom/intellij/stats/completion/sender/StatisticSenderImpl$SendingResult;", "equals", "other", "hashCode", "toString", "", "intellij.statsCollector"})
    private static final class SendingResult {
        private final boolean isSuccessful;
        @Nullable
        private final Integer responseCode;

        public SendingResult(boolean isSuccessful, @Nullable Integer responseCode) {
            this.isSuccessful = isSuccessful;
            this.responseCode = responseCode;
        }

        public final boolean isSuccessful() {
            return this.isSuccessful;
        }

        @Nullable
        public final Integer getResponseCode() {
            return this.responseCode;
        }

        public final boolean component1() {
            return this.isSuccessful;
        }

        @Nullable
        public final Integer component2() {
            return this.responseCode;
        }

        @NotNull
        public final SendingResult copy(boolean isSuccessful, @Nullable Integer responseCode) {
            return new SendingResult(isSuccessful, responseCode);
        }

        public static /* synthetic */ SendingResult copy$default(SendingResult sendingResult, boolean bl, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = sendingResult.isSuccessful;
            }
            if ((n2 & 2) != 0) {
                n = sendingResult.responseCode;
            }
            return sendingResult.copy(bl, n);
        }

        @NotNull
        public String toString() {
            return "SendingResult(isSuccessful=" + this.isSuccessful + ", responseCode=" + this.responseCode + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isSuccessful);
            result = result * 31 + (this.responseCode == null ? 0 : ((Object)this.responseCode).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SendingResult)) {
                return false;
            }
            SendingResult sendingResult = (SendingResult)other;
            if (this.isSuccessful != sendingResult.isSuccessful) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.responseCode, (Object)sendingResult.responseCode);
        }
    }
}

