/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_VERSION_CACHE", "", "", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKeyWithVersion;", "getPackageVersion", "Lcom/intellij/util/text/SemVer;", "packageDir", "Ljava/nio/file/Path;", "getPackageVersionByPackageJson", "packageJson", "readVersion", "parseVersion", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "comparePackageVersions", "", "version1", "version2", "createFileKey", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKey;", "filePath", "FileKey", "FileKeyWithVersion", "intellij.javascript.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNodePackageVersionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePackageVersionUtil.kt\ncom/intellij/javascript/nodejs/NodePackageVersionUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n1#2:146\n60#3,5:147\n60#3,5:152\n13#3:157\n61#3,4:158\n13#3:162\n*S KotlinDebug\n*F\n+ 1 NodePackageVersionUtil.kt\ncom/intellij/javascript/nodejs/NodePackageVersionUtil\n*L\n46#1:147,5\n50#1:152,5\n64#1:157\n127#1:158,4\n31#1:162\n*E\n"})
public final class NodePackageVersionUtil {
    @NotNull
    public static final NodePackageVersionUtil INSTANCE = new NodePackageVersionUtil();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<String, FileKeyWithVersion> PACKAGE_VERSION_CACHE;

    private NodePackageVersionUtil() {
    }

    @JvmStatic
    @Nullable
    public static final SemVer getPackageVersion(@NotNull Path packageDir) {
        Intrinsics.checkNotNullParameter((Object)packageDir, (String)"packageDir");
        Path path2 = packageDir.resolve("package.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return INSTANCE.getPackageVersionByPackageJson(path2);
    }

    private final SemVer getPackageVersionByPackageJson(Path packageJson) {
        Logger logger;
        Object $this$getPackageVersionByPackageJson_u24lambda_u240;
        Object object = this;
        try {
            $this$getPackageVersionByPackageJson_u24lambda_u240 = object;
            boolean bl = false;
            $this$getPackageVersionByPackageJson_u24lambda_u240 = Result.constructor-impl((Object)packageJson.toAbsolutePath());
        }
        catch (Throwable bl) {
            $this$getPackageVersionByPackageJson_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getPackageVersionByPackageJson_u24lambda_u240;
        Path path2 = (Path)(Result.isFailure-impl((Object)object) ? null : object);
        if (path2 == null) {
            return null;
        }
        Path absolutePath = path2;
        String absolutePathStr = ((Object)absolutePath).toString();
        FileKey fileKey = this.createFileKey(absolutePath);
        if (fileKey == null) {
            return null;
        }
        FileKey upToDateFileKey = fileKey;
        FileKeyWithVersion result2 = null;
        result2 = PACKAGE_VERSION_CACHE.get(absolutePathStr);
        if (result2 == null || !Intrinsics.areEqual((Object)result2.getFileKey(), (Object)upToDateFileKey)) {
            SemVer version2 = this.readVersion(absolutePath);
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Read version " + version2 + " from " + absolutePath, t$iv);
            }
            result2 = new FileKeyWithVersion(upToDateFileKey, version2);
            PACKAGE_VERSION_CACHE.put(absolutePathStr, result2);
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Result=" + result2 + " from " + absolutePath, t$iv);
        }
        return result2.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SemVer readVersion(Path packageJson) {
        try {
            Object object = packageJson;
            Object object2 = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2);
            object2 = null;
            try {
                SemVer semVer;
                InputStreamReader reader = (InputStreamReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)new JsonFactory().createParser((Reader)reader);
                Throwable throwable = null;
                try {
                    JsonParser parser = (JsonParser)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)parser);
                    String versionText = INSTANCE.parseVersion(parser);
                    semVer = SemVer.parseFromText((String)versionText);
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        object2 = throwable4;
                        throw throwable4;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                SemVer semVer2 = semVer;
                return semVer2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(NodePackageVersionUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse " + packageJson, (Throwable)e);
            return null;
        }
    }

    private final String parseVersion(JsonParser parser) throws IOException {
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                JsonParser jsonParser;
                if (parser.currentToken() == JsonToken.FIELD_NAME) {
                    if (Intrinsics.areEqual((Object)parser.currentName(), (Object)"version")) {
                        return parser.nextTextValue();
                    }
                    parser.nextToken();
                    jsonParser = parser.skipChildren();
                    continue;
                }
                jsonParser = parser.skipChildren();
            }
        }
        return null;
    }

    @JvmStatic
    public static final int comparePackageVersions(@NotNull String version1, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version1, (String)"version1");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version2");
        if (Intrinsics.areEqual((Object)version1, (Object)version2)) {
            return 0;
        }
        SemVer ver1 = SemVer.parseFromText((String)version1);
        SemVer ver2 = SemVer.parseFromText((String)version2);
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int result2 = ver1.compareTo(ver2);
        if (result2 == 0) {
            if (Intrinsics.areEqual((Object)version1, (Object)ver1.getParsedVersion())) {
                return 1;
            }
            if (Intrinsics.areEqual((Object)version2, (Object)ver2.getParsedVersion())) {
                return -1;
            }
            result2 = PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final FileKey createFileKey(Path filePath) {
        Object object;
        try {
            object = filePath;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            BasicFileAttributes basicFileAttributes = Files.readAttributes((Path)object, BasicFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)basicFileAttributes, (String)"readAttributes(...)");
            object = basicFileAttributes;
        }
        catch (Exception e) {
            void $this$debug$iv;
            Logger logger = LOG;
            Throwable t$iv = e;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                void var9_8 = $this$debug$iv;
                boolean bl = false;
                var9_8.debug("Failed to read attributes of " + filePath, t$iv);
            }
            return null;
        }
        Object attrs = object;
        if (!attrs.isRegularFile()) {
            return null;
        }
        FileTime fileTime = attrs.lastModifiedTime();
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"lastModifiedTime(...)");
        FileTime fileTime2 = attrs.creationTime();
        Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"creationTime(...)");
        return new FileKey(fileTime, fileTime2, attrs.size(), attrs.fileKey());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodePackageVersionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Map map = Collections.synchronizedMap((Map)new FixedHashMap(200));
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        PACKAGE_VERSION_CACHE = map;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0006H\u00c2\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J3\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKey;", "", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "creationTime", "size", "", "fileKey", "<init>", "(Ljava/nio/file/attribute/FileTime;Ljava/nio/file/attribute/FileTime;JLjava/lang/Object;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.backend"})
    private static final class FileKey {
        @NotNull
        private final FileTime lastModifiedTime;
        @NotNull
        private final FileTime creationTime;
        private final long size;
        @Nullable
        private final Object fileKey;

        public FileKey(@NotNull FileTime lastModifiedTime, @NotNull FileTime creationTime, long size, @Nullable Object fileKey) {
            Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            this.lastModifiedTime = lastModifiedTime;
            this.creationTime = creationTime;
            this.size = size;
            this.fileKey = fileKey;
        }

        private final FileTime component1() {
            return this.lastModifiedTime;
        }

        private final FileTime component2() {
            return this.creationTime;
        }

        private final long component3() {
            return this.size;
        }

        private final Object component4() {
            return this.fileKey;
        }

        @NotNull
        public final FileKey copy(@NotNull FileTime lastModifiedTime, @NotNull FileTime creationTime, long size, @Nullable Object fileKey) {
            Intrinsics.checkNotNullParameter((Object)lastModifiedTime, (String)"lastModifiedTime");
            Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
            return new FileKey(lastModifiedTime, creationTime, size, fileKey);
        }

        public static /* synthetic */ FileKey copy$default(FileKey fileKey, FileTime fileTime, FileTime fileTime2, long l, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                fileTime = fileKey.lastModifiedTime;
            }
            if ((n & 2) != 0) {
                fileTime2 = fileKey.creationTime;
            }
            if ((n & 4) != 0) {
                l = fileKey.size;
            }
            if ((n & 8) != 0) {
                object = fileKey.fileKey;
            }
            return fileKey.copy(fileTime, fileTime2, l, object);
        }

        @NotNull
        public String toString() {
            return "FileKey(lastModifiedTime=" + this.lastModifiedTime + ", creationTime=" + this.creationTime + ", size=" + this.size + ", fileKey=" + this.fileKey + ")";
        }

        public int hashCode() {
            int result2 = this.lastModifiedTime.hashCode();
            result2 = result2 * 31 + this.creationTime.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.size);
            result2 = result2 * 31 + (this.fileKey == null ? 0 : this.fileKey.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileKey)) {
                return false;
            }
            FileKey fileKey = (FileKey)other;
            if (!Intrinsics.areEqual((Object)this.lastModifiedTime, (Object)fileKey.lastModifiedTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creationTime, (Object)fileKey.creationTime)) {
                return false;
            }
            if (this.size != fileKey.size) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileKey, (Object)fileKey.fileKey);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKeyWithVersion;", "", "fileKey", "Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKey;", "version", "Lcom/intellij/util/text/SemVer;", "<init>", "(Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKey;Lcom/intellij/util/text/SemVer;)V", "getFileKey", "()Lcom/intellij/javascript/nodejs/NodePackageVersionUtil$FileKey;", "getVersion", "()Lcom/intellij/util/text/SemVer;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.javascript.backend"})
    private static final class FileKeyWithVersion {
        @NotNull
        private final FileKey fileKey;
        @Nullable
        private final SemVer version;

        public FileKeyWithVersion(@NotNull FileKey fileKey, @Nullable SemVer version2) {
            Intrinsics.checkNotNullParameter((Object)fileKey, (String)"fileKey");
            this.fileKey = fileKey;
            this.version = version2;
        }

        @NotNull
        public final FileKey getFileKey() {
            return this.fileKey;
        }

        @Nullable
        public final SemVer getVersion() {
            return this.version;
        }

        @NotNull
        public final FileKey component1() {
            return this.fileKey;
        }

        @Nullable
        public final SemVer component2() {
            return this.version;
        }

        @NotNull
        public final FileKeyWithVersion copy(@NotNull FileKey fileKey, @Nullable SemVer version2) {
            Intrinsics.checkNotNullParameter((Object)fileKey, (String)"fileKey");
            return new FileKeyWithVersion(fileKey, version2);
        }

        public static /* synthetic */ FileKeyWithVersion copy$default(FileKeyWithVersion fileKeyWithVersion, FileKey fileKey, SemVer semVer, int n, Object object) {
            if ((n & 1) != 0) {
                fileKey = fileKeyWithVersion.fileKey;
            }
            if ((n & 2) != 0) {
                semVer = fileKeyWithVersion.version;
            }
            return fileKeyWithVersion.copy(fileKey, semVer);
        }

        @NotNull
        public String toString() {
            return "FileKeyWithVersion(fileKey=" + this.fileKey + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.fileKey.hashCode();
            result2 = result2 * 31 + (this.version == null ? 0 : this.version.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileKeyWithVersion)) {
                return false;
            }
            FileKeyWithVersion fileKeyWithVersion = (FileKeyWithVersion)other;
            if (!Intrinsics.areEqual((Object)this.fileKey, (Object)fileKeyWithVersion.fileKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)fileKeyWithVersion.version);
        }
    }
}

