/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSmartCompletionContributor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MemberAccessCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        JSClass containingClass;
        if (parameters2 == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"typescript.service.completion.ownContributorsEnabled")) {
            return;
        }
        PsiElement parent = parameters2.getPosition().getParent();
        if (!JSPsiImplUtils.isRuntimeUnqualifiedRefExpression((PsiElement)parent)) {
            return;
        }
        JSFunction parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)parent);
        String ownerPropertyName = null;
        if (parentFunction == null) {
            JSField field = (JSField)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
            parentFunction = field;
            if (parentFunction == null) {
                return;
            }
            ownerPropertyName = field.getName();
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) == null || DialectDetector.isActionScript((PsiElement)containingClass)) {
            return;
        }
        JSClass originalContainingClass = (JSClass)CompletionUtil.getOriginalOrSelf((PsiElement)containingClass);
        PsiElement context2 = parent.getParent();
        if (context2 instanceof JSProperty && ((JSProperty)context2).isShorthanded()) {
            return;
        }
        JSContext jsContext = parentFunction.getJSContext();
        HashMap<String, JSPsiElementBase> forCompletion = new HashMap<String, JSPsiElementBase>();
        HashMap<String, Pair<JSPsiElementBase, Runnable>> specialForCompletion = new HashMap<String, Pair<JSPsiElementBase, Runnable>>();
        HashMap<JSClass, JSTypeSubstitutor> typeSubstitutors = new HashMap<JSClass, JSTypeSubstitutor>();
        if (!JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)((JSExpression)parent))) {
            ES6MemberAccessCompletionContributor.addMembersFromHierarchy(originalContainingClass, context2, jsContext, forCompletion, specialForCompletion, typeSubstitutors);
        } else {
            JSType type2;
            JSFunction thisScope = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)parent);
            if (thisScope != null && (type2 = TypeScriptPsiUtil.getThisParameterType((JSFunction)thisScope)) != null) {
                JSRecordType recordType = type2.asRecordType((PsiElement)thisScope);
                for (JSRecordType.PropertySignature member : recordType.getProperties()) {
                    PsiElement singleElement = member.getMemberSource().getSingleElement();
                    if (!(singleElement instanceof JSPsiElementBase)) continue;
                    forCompletion.put(member.getMemberName(), (JSPsiElementBase)singleElement);
                }
            }
        }
        String finalOwnerPropertyName = ownerPropertyName;
        forCompletion.values().forEach(el -> {
            LookupElement element2 = ES6MemberAccessCompletionContributor.createLookupElement(originalContainingClass, el, jsContext, finalOwnerPropertyName, false, null, null);
            if (element2 != null) {
                result2.consume(element2);
            }
        });
        specialForCompletion.forEach((key, value) -> {
            LookupElement element2 = ES6MemberAccessCompletionContributor.createLookupElement(originalContainingClass, (JSPsiElementBase)value.first, jsContext, finalOwnerPropertyName, true, key, (Runnable)value.second);
            if (element2 != null) {
                result2.consume(element2);
            }
        });
    }

    private static void addMembersFromHierarchy(JSClass containingClass, PsiElement context2, JSContext jsContext, HashMap<String, JSPsiElementBase> forCompletion, HashMap<String, Pair<JSPsiElementBase, Runnable>> specialForCompletion, Map<JSClass, JSTypeSubstitutor> typeSubstitutors) {
        GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope((PsiElement)context2);
        TypeScriptUtil.JSClassHierarchyProcessor processor = (aClass, typeSubstitutor, fromImplements) -> {
            String qualifiedName;
            for (JSElement element2 : aClass.getMembers()) {
                ItemWithAction specialNameForCompletion;
                JSAttributeList.AccessType type2;
                if (!(element2 instanceof JSPsiElementBase) || (type2 = ((JSPsiElementBase)element2).getAccessType()) == JSAttributeList.AccessType.PRIVATE && !aClass.isEquivalentTo((PsiElement)containingClass) || jsContext == JSContext.STATIC && (((JSPsiElementBase)element2).getJSContext() == JSContext.INSTANCE || element2 instanceof JSParameter)) continue;
                String name = element2.getName();
                if (!StringUtil.isEmpty((String)name)) {
                    if (forCompletion.containsKey(name)) continue;
                    forCompletion.put(name, (JSPsiElementBase)element2);
                    continue;
                }
                if (!(element2 instanceof JSComputedPropertyNameOwner) || (specialNameForCompletion = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)element2, context2)) == null || specialForCompletion.containsKey(specialNameForCompletion.item)) continue;
                specialForCompletion.put(specialNameForCompletion.item, Pair.create((Object)((JSPsiElementBase)element2), (Object)specialNameForCompletion.importAction));
            }
            if (jsContext == JSContext.STATIC && JSClassUtils.canHavePrototypeProperty((JSClass)aClass) && !forCompletion.containsKey("prototype")) {
                forCompletion.put("prototype", (JSPsiElementBase)JSClassUtils.getImplicitPrototypeProperty((JSClass)aClass));
            }
            if (jsContext == JSContext.INSTANCE && DialectDetector.isJavaScript((PsiElement)aClass) && (qualifiedName = aClass.getQualifiedName()) != null) {
                Collection members = JSClassResolver.getInstance().findNamespaceMembers(qualifiedName, resolveScope);
                for (JSPsiElementBase member : members) {
                    String memberName = member.getName();
                    if ("constructor".equals(memberName) || "prototype".equals(memberName)) continue;
                    forCompletion.putIfAbsent(memberName, member);
                }
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            return true;
        };
        JSClassUtils.processClassesInHierarchy((JSClass)containingClass, (boolean)true, (TypeScriptUtil.JSClassHierarchyProcessor)processor);
    }

    @Nullable
    private static LookupElement createLookupElement(@NotNull JSClass containingClass, @NotNull JSPsiElementBase el, JSContext ownContext, String ownerPropertyName, boolean noEscaping, @Nullable String altName, @Nullable Runnable postProcess) {
        String qualifier;
        String name;
        if (containingClass == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(2);
        }
        if (el == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((name = el.getName()) == null) {
            name = altName;
        }
        assert (name != null);
        if (ownerPropertyName != null && ownerPropertyName.equals(name)) {
            return null;
        }
        boolean needThis = true;
        if (el.getJSContext() == JSContext.STATIC && JSUtils.getMemberContainingClass((PsiElement)el) != null && (ownContext != JSContext.STATIC || ownerPropertyName != null)) {
            String className = containingClass.getName();
            if (className == null) {
                return null;
            }
            qualifier = className;
        } else {
            qualifier = "this";
            boolean bl = needThis = !name.equals("constructor");
        }
        if (!needThis) {
            return null;
        }
        String nameWithAccess = ES6MemberAccessCompletionContributor.getNameWithAccess(name, JSUtils.isPrivateSharpItem((PsiElement)el), noEscaping, (PsiElement)containingClass);
        LookupElementBuilder baseElementWithThis = JSLookupUtilImpl.createLookupElement((PsiElement)el, qualifier + nameWithAccess);
        return PrioritizedLookupElement.withPriority((LookupElement)baseElementWithThis.withInsertHandler((handleInsert, item) -> {
            JSInsertHandler.insertBracesIfNeeded(handleInsert, (PsiElement)el, null);
            if (postProcess != null) {
                postProcess.run();
            }
        }).withLookupString(name), (double)JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY.getPriorityValue());
    }

    @NotNull
    public static String getNameWithAccess(@NotNull String name, boolean isPrivateName, boolean noEscaping, @NotNull PsiElement context2) {
        if (name == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(5);
        }
        boolean usesIndexAccessSyntax = false;
        boolean hasBrackets = false;
        if (!isPrivateName && !JSSymbolUtil.isValidPropertyName((String)name)) {
            if (!noEscaping) {
                name = JSSymbolUtil.quoteIfSpecialPropertyName((String)name, (boolean)isPrivateName, (char)JSCodeStyleSettings.getQuoteChar((PsiElement)context2));
            }
            usesIndexAccessSyntax = true;
            if (!name.isEmpty() && name.charAt(0) == '[') {
                hasBrackets = true;
            }
        }
        String access = hasBrackets ? "" : (usesIndexAccessSyntax ? "[" : ".");
        String suffix = usesIndexAccessSyntax && !hasBrackets ? "]" : "";
        String string = access + name + suffix;
        if (string == null) {
            ES6MemberAccessCompletionContributor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithAccess";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

