/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceAliveChecker;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceService;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUsagesCollector;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u0004\u0018\u00010 H\u0095@\u00a2\u0006\u0002\u0010.J\u0010\u00100\u001a\u0004\u0018\u00010 H\u0084@\u00a2\u0006\u0002\u0010.J\u0010\u00102\u001a\u0004\u0018\u00010 H\u0082@\u00a2\u0006\u0002\u0010.J\b\u00105\u001a\u00020,H\u0014J\u000e\u00106\u001a\u00020,H\u0094@\u00a2\u0006\u0002\u0010.J \u00107\u001a\u00020,2\u0006\u0010/\u001a\u00020 2\u000e\u00108\u001a\n\u0018\u000109j\u0004\u0018\u0001`:H\u0002J\u0006\u0010;\u001a\u00020<J0\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H?0>\"\b\b\u0000\u0010?*\u00020@2\u0006\u0010A\u001a\u00020B2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002H?0DH\u0007J\u0018\u0010=\u001a\u0004\u0018\u00010E2\u0006\u0010A\u001a\u00020BH\u0096@\u00a2\u0006\u0002\u0010FJ\u0018\u0010G\u001a\u0004\u0018\u00010E2\u0006\u0010A\u001a\u00020BH\u0087@\u00a2\u0006\u0002\u0010FJ\b\u0010H\u001a\u00020\u001bH\u0014J\u0010\u0010I\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001bH\u0007J\b\u0010J\u001a\u00020<H\u0016J\n\u0010K\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010L\u001a\u00020,H\u0014J\b\u0010M\u001a\u00020,H\u0016R\u0010\u0010\u0007\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00020\u001b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010/\u001a\u0004\u0018\u00010 8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00103\u001a\u0004\u0018\u00010 8F\u00a2\u0006\u0006\u001a\u0004\b4\u00101\u00a8\u0006N"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/lang/javascript/linter/LinterLanguageServiceClient;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myProject", "getProject", "()Lcom/intellij/openapi/project/Project;", "debugName", "", "getDebugName", "()Ljava/lang/String;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myLifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "getMyLifecycleSpan", "()Lio/opentelemetry/api/trace/Span;", "myProcessConnector", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;", "getMyProcessConnector$annotations", "()V", "myDefaultReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "defaultReporter", "getDefaultReporter", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "myProcess", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "myProcessInit", "Lkotlinx/coroutines/sync/Mutex;", "aliveChecker", "Lcom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker;", "getAliveChecker", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceAliveChecker;", "initializeOnceCalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitializeOnceCalled", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "initializeOnce", "", "createLanguageServiceQueue", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "process", "getProcess", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "computeProcessUnderLocks", "processIfCreated", "getProcessIfCreated", "restart", "terminateStartedProcessUnderLock", "disposeProcessSyncOrAsync", "onDisposed", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "checkCanUseService", "", "sendCommand", "Ljava/util/concurrent/CompletableFuture;", "T", "", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "processor", "Lcom/intellij/lang/javascript/service/JSLanguageServiceCommandProcessor;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$CommandResult;", "(Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendCommandSuspending", "createDefaultReporter", "setDefaultReporter", "isServiceCreated", "getServiceCreationError", "resetState", "dispose", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceBase.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceBase\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n30#2,2:269\n1#3:271\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceBase.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceBase\n*L\n40#1:269,2\n*E\n"})
public abstract class JSLanguageServiceBase
implements Disposable,
LinterLanguageServiceClient {
    @JvmField
    @NotNull
    protected final Project myProject;
    @NotNull
    private final String debugName;
    @NotNull
    private final CoroutineScope cs;
    @Nullable
    private final Span myLifecycleSpan;
    @ApiStatus.ScheduledForRemoval
    @JvmField
    @Nullable
    protected final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @JvmField
    @NotNull
    protected volatile JSLanguageServiceInfoReporter myDefaultReporter;
    @Nullable
    private volatile JSLanguageServiceQueue myProcess;
    @NotNull
    private final Mutex myProcessInit;
    @NotNull
    private final JSLanguageServiceAliveChecker aliveChecker;
    @NotNull
    private final AtomicBoolean initializeOnceCalled;

    public JSLanguageServiceBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myProject = project;
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)this.getClass().getSimpleName(), (String)"Service", (boolean)true), (String)"Language", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
        this.debugName = string;
        ComponentManager $this$service$iv = (ComponentManager)this.myProject;
        boolean $i$f$service = false;
        Class<JSLanguageServiceService> serviceClass$iv = JSLanguageServiceService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)((JSLanguageServiceService)object).getCs(), (String)("Scope for " + this.debugName), null, (boolean)true, (int)2, null);
        this.myLifecycleSpan = JSLanguageServiceTracerUtilKt.createServerLifecycleSpanIfNeeded(this.getClass(), "Language Service Lifecycle");
        this.myDefaultReporter = this.createDefaultReporter();
        this.myProcessInit = MutexKt.Mutex((boolean)false);
        CoroutineScope coroutineScope = this.cs;
        Mutex mutex = this.myProcessInit;
        this.aliveChecker = new JSLanguageServiceAliveChecker(project, this, coroutineScope, mutex){
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super($project, $super_call_param$1, $super_call_param$2);
            }

            public JSLanguageServiceQueue getCurrentProcess() {
                return JSLanguageServiceBase.access$getMyProcess$p(this.this$0);
            }

            public Object terminateStartedProcessUnderLock(Continuation<? super Unit> $completion) {
                Object object = this.this$0.terminateStartedProcessUnderLock($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        this.initializeOnceCalled = new AtomicBoolean(false);
    }

    @NotNull
    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected final String getDebugName() {
        return this.debugName;
    }

    @NotNull
    protected final CoroutineScope getCs() {
        return this.cs;
    }

    @Nullable
    protected final Span getMyLifecycleSpan() {
        return this.myLifecycleSpan;
    }

    @Deprecated(message="API is not supported anymore")
    protected static /* synthetic */ void getMyProcessConnector$annotations() {
    }

    @NotNull
    public final JSLanguageServiceInfoReporter getDefaultReporter() {
        return this.myDefaultReporter;
    }

    @NotNull
    protected final JSLanguageServiceAliveChecker getAliveChecker() {
        return this.aliveChecker;
    }

    @NotNull
    protected final AtomicBoolean getInitializeOnceCalled() {
        return this.initializeOnceCalled;
    }

    protected void initializeOnce() {
        JSLanguageServiceQueue.Holder.LOGGER.debug("Run initialize once");
        JSLanguageServiceUsagesCollector.triggerServiceFirstStart(this.myProject, this.getClass());
        this.aliveChecker.initializeOnce();
    }

    @RequiresReadLockAbsence
    @Nullable
    protected Object createLanguageServiceQueue(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        return JSLanguageServiceBase.createLanguageServiceQueue$suspendImpl(this, $completion);
    }

    @RequiresReadLockAbsence
    static /* synthetic */ Object createLanguageServiceQueue$suspendImpl(JSLanguageServiceBase $this, Continuation<? super JSLanguageServiceQueue> $completion) {
        throw new UnsupportedOperationException("createLanguageServiceQueue is not implemented");
    }

    @Nullable
    protected JSLanguageServiceQueue getProcess() {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.myProcess;
        if (jSLanguageServiceQueue != null) {
            JSLanguageServiceQueue it = jSLanguageServiceQueue;
            boolean bl = false;
            return it;
        }
        return (JSLanguageServiceQueue)JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "getProcess", null, () -> JSLanguageServiceBase._get_process_$lambda$1(this), 2, null);
    }

    @Nullable
    protected final Object getProcess(@NotNull Continuation<? super JSLanguageServiceQueue> $completion) {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.myProcess;
        if (jSLanguageServiceQueue != null) {
            JSLanguageServiceQueue it = jSLanguageServiceQueue;
            boolean bl = false;
            return it;
        }
        return TimeoutKt.withTimeoutOrNull((long)JSLanguageServiceUtil.getTimeout(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)this.this$0.getCs(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this.this$0, null){
                            Object L$0;
                            Object L$1;
                            int I$0;
                            int I$1;
                            int label;
                            final /* synthetic */ JSLanguageServiceBase this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        var2_3 = JSLanguageServiceBase.access$getMyProcessInit$p(this.this$0);
                                        var4_4 = this.this$0;
                                        owner$iv = null;
                                        $i$f$withLock = 0;
                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.I$0 = $i$f$withLock;
                                        this.label = 1;
                                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                        if (v0 == var12_2) {
                                            return var12_2;
                                        }
                                        ** GOTO lbl25
                                    }
                                    case 1: {
                                        $i$f$withLock = this.I$0;
                                        var4_4 = (JSLanguageServiceBase)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl25:
                                        // 3 sources

                                        $i$a$-withLock$default-JSLanguageServiceBase$getProcess$3$deferred$1$1 = 0;
                                        v1 = JSLanguageServiceBase.access$getMyProcess$p(var4_4);
                                        if (v1 == null) ** GOTO lbl35
                                        it = v1;
                                        $i$a$-let-JSLanguageServiceBase$getProcess$3$deferred$1$1$1 = false;
                                        var11_12 = it;
                                        $this$withLock_u24default$iv.unlock(owner$iv);
                                        return var11_12;
lbl35:
                                        // 2 sources

                                        this.L$0 = $this$withLock_u24default$iv;
                                        this.L$1 = var4_4;
                                        this.I$0 = $i$f$withLock;
                                        this.I$1 = $i$a$-withLock$default-JSLanguageServiceBase$getProcess$3$deferred$1$1;
                                        this.label = 2;
                                        v2 = JSLanguageServiceBase.access$computeProcessUnderLocks(var4_4, (Continuation)this);
                                        ** if (v2 != var12_2) goto lbl43
lbl42:
                                        // 1 sources

                                        return var12_2;
lbl43:
                                        // 1 sources

                                        ** GOTO lbl54
                                    }
                                    case 2: {
                                        $i$a$-withLock$default-JSLanguageServiceBase$getProcess$3$deferred$1$1 = this.I$1;
                                        $i$f$withLock = this.I$0;
                                        var4_4 = (JSLanguageServiceBase)this.L$1;
                                        owner$iv = null;
                                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
lbl54:
                                            // 2 sources

                                            newProcess = (JSLanguageServiceQueue)v2;
                                            JSLanguageServiceBase.access$setMyProcess$p(var4_4, newProcess);
                                            var10_14 = newProcess;
                                        }
                                        catch (Throwable var6_9) {
                                            throw var6_9;
                                        }
                                        finally {
                                            $this$withLock_u24default$iv.unlock(owner$iv);
                                        }
                                        return var10_14;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)deferred2);
                        this.label = 1;
                        Object object2 = deferred2.await((Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        Deferred deferred3 = (Deferred)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object computeProcessUnderLocks(Continuation<? super JSLanguageServiceQueue> $completion) {
        if (!($completion instanceof computeProcessUnderLocks.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceBase.access$computeProcessUnderLocks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                JSLanguageServiceQueue.Holder.LOGGER.debug("Run compute process under locks");
                if (this.myProject.isDisposed()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Project is disposed - stopping language service queue creation");
                    return null;
                }
                if (this.initializeOnceCalled.compareAndSet(false, true)) {
                    this.initializeOnce();
                }
                v0 = this.myLifecycleSpan;
                spanOrNull = v0 != null ? v0.makeCurrent() : null;
                var3_7 = (AutoCloseable)spanOrNull;
                var4_8 = null;
                it = (Scope)var3_7;
                $i$a$-use-JSLanguageServiceBase$computeProcessUnderLocks$2 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)spanOrNull);
                $continuation.L$1 = var3_7;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                $continuation.I$0 = $i$a$-use-JSLanguageServiceBase$computeProcessUnderLocks$2;
                $continuation.label = 1;
                v1 = this.createLanguageServiceQueue((Continuation<? super JSLanguageServiceQueue>)$continuation);
                ** if (v1 != var9_4) goto lbl34
lbl33:
                // 1 sources

                return var9_4;
lbl34:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                $i$a$-use-JSLanguageServiceBase$computeProcessUnderLocks$2 = $continuation.I$0;
                it = (Scope)$continuation.L$2;
                var4_8 = null;
                var3_7 = (AutoCloseable)$continuation.L$1;
                spanOrNull = (Scope)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl45:
                    // 2 sources

                    var5_9 = (JSLanguageServiceQueue)v1;
                    ** GOTO lbl55
                }
                catch (Throwable var6_12) {
                    var4_8 = var6_12;
                    throw var6_12;
                }
            }
            catch (Throwable var6_13) {
                throw var6_13;
            }
            {
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var3_7, (Throwable)var4_8);
                }
lbl55:
                // 1 sources

                return var5_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final JSLanguageServiceQueue getProcessIfCreated() {
        return this.myProcess;
    }

    protected void restart() {
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            String string = "Restart language service %s with hashCode %s.";
            Object[] objectArray = new Object[2];
            objectArray[0] = this.debugName;
            JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcessIfCreated();
            objectArray[1] = jSLanguageServiceQueue != null ? Integer.valueOf(jSLanguageServiceQueue.hashCode()) : null;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            String message = string2;
            JSLanguageServiceQueue.Holder.LOGGER.debug(message, new Throwable());
        }
        this.resetState();
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = JSLanguageServiceBase.access$getMyProcessInit$p(this.this$0);
                        var4_4 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var4_4 = (JSLanguageServiceBase)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 3 sources

                        $i$a$-withLock$default-JSLanguageServiceBase$restart$1$1 = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = null;
                        this.I$0 = $i$f$withLock;
                        this.I$1 = $i$a$-withLock$default-JSLanguageServiceBase$restart$1$1;
                        this.label = 2;
                        v1 = var4_4.terminateStartedProcessUnderLock((Continuation<? super Unit>)this);
                        ** if (v1 != var8_2) goto lbl35
lbl34:
                        // 1 sources

                        return var8_2;
lbl35:
                        // 1 sources

                        ** GOTO lbl45
                    }
                    case 2: {
                        $i$a$-withLock$default-JSLanguageServiceBase$restart$1$1 = this.I$1;
                        $i$f$withLock = this.I$0;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl45:
                            // 2 sources

                            var7_11 = Unit.INSTANCE;
                        }
                        catch (Throwable var6_10) {
                            throw var6_10;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    protected Object terminateStartedProcessUnderLock(@NotNull Continuation<? super Unit> $completion) {
        return JSLanguageServiceBase.terminateStartedProcessUnderLock$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object terminateStartedProcessUnderLock$suspendImpl(JSLanguageServiceBase $this, Continuation<? super Unit> $completion) {
        JSLanguageServiceQueue process2 = $this.getProcessIfCreated();
        if (process2 != null) {
            if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                String string = "Dispose queue %s with hashCode %s by terminateStartedProcess call.";
                Object[] objectArray = new Object[]{$this.debugName, Boxing.boxInt((int)process2.hashCode())};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String message = string2;
                JSLanguageServiceQueue.Holder.LOGGER.debug(message, new Throwable());
            }
            $this.myProcess = null;
            $this.disposeProcessSyncOrAsync(process2, () -> JSLanguageServiceBase.terminateStartedProcessUnderLock$lambda$0($this));
        }
        return Unit.INSTANCE;
    }

    private final void disposeProcessSyncOrAsync(JSLanguageServiceQueue process2, Runnable onDisposed) {
        Runnable disposeAction = () -> JSLanguageServiceBase.disposeProcessSyncOrAsync$lambda$0(process2, onDisposed);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            disposeAction.run();
        } else {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(disposeAction);
            Intrinsics.checkNotNull((Object)future);
        }
    }

    public final boolean checkCanUseService() {
        return this.aliveChecker.checkCanUseService();
    }

    @Deprecated(message="Use sendCommand(JSLanguageServiceSimpleCommand) instead")
    @NotNull
    public final <T> CompletableFuture<T> sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)this.cs, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(this, command, processor, null){
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            final /* synthetic */ JSLanguageServiceSimpleCommand $command;
            final /* synthetic */ JSLanguageServiceCommandProcessor<T> $processor;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                this.$processor = $processor;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.this$0.getProcess();
                        if (v0 == null) ** GOTO lbl16
                        this.label = 1;
                        v1 = v0.execute(this.$command, (Continuation<? super JSLanguageServiceQueue.CommandResult>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        if ((v0 = (JSLanguageServiceQueue.CommandResult)v1) != null) ** GOTO lbl17
lbl16:
                        // 2 sources

                        return null;
lbl17:
                        // 1 sources

                        result = v0;
                        v2 = result.getAnswer();
                        if (v2 == null) {
                            return null;
                        }
                        answer = v2;
                        return this.$processor.process((JSLanguageServiceObject)CollectionsKt.last(result.getPayload()), answer);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)3, null));
    }

    @Nullable
    public Object sendCommand(@NotNull JSLanguageServiceSimpleCommand command, @NotNull Continuation<? super JSLanguageServiceQueue.CommandResult> $completion) {
        return JSLanguageServiceBase.sendCommand$suspendImpl(this, command, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object sendCommand$suspendImpl(JSLanguageServiceBase $this, JSLanguageServiceSimpleCommand command, Continuation<? super JSLanguageServiceQueue.CommandResult> $completion) {
        if (!($completion instanceof sendCommand.2)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceBase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceBase.sendCommand$suspendImpl(this.this$0, null, (Continuation<? super JSLanguageServiceQueue.CommandResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = command;
                $continuation.label = 1;
                v0 = $this.getProcess((Continuation<? super JSLanguageServiceQueue>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                command = (JSLanguageServiceSimpleCommand)$continuation.L$1;
                $this = (JSLanguageServiceBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = (JSLanguageServiceQueue)v0;
                if (v1 == null) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.label = 2;
                v2 = v1.execute(command, (Continuation<? super JSLanguageServiceQueue.CommandResult>)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl38
            }
            case 2: {
                command = (JSLanguageServiceSimpleCommand)$continuation.L$1;
                $this = (JSLanguageServiceBase)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                return v2;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Deprecated(message="Use sendCommand(JSLanguageServiceSimpleCommand) instead")
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    @Nullable
    public final Object sendCommandSuspending(@NotNull JSLanguageServiceSimpleCommand command, @NotNull Continuation<? super JSLanguageServiceQueue.CommandResult> $completion) {
        return this.sendCommand(command, $completion);
    }

    @NotNull
    protected JSLanguageServiceInfoReporter createDefaultReporter() {
        String serviceDebugName = this.debugName;
        return new JSLanguageServiceInfoReporter(serviceDebugName){
            final /* synthetic */ String $serviceDebugName;
            {
                this.$serviceDebugName = $serviceDebugName;
            }

            public void logCurrentErrors(VirtualFile virtualFile, List<? extends JSAnnotationError> results) {
                Intrinsics.checkNotNullParameter(results, (String)"results");
            }

            public String getPresentableServiceName() {
                return this.$serviceDebugName;
            }

            public void startingError(String errorText) {
                Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
            }

            public void setProcess(String text) {
            }
        };
    }

    @TestOnly
    public final void setDefaultReporter(@NotNull JSLanguageServiceInfoReporter defaultReporter) {
        Intrinsics.checkNotNullParameter((Object)defaultReporter, (String)"defaultReporter");
        this.myDefaultReporter = defaultReporter;
    }

    @Override
    public boolean isServiceCreated() {
        return this.getProcessIfCreated() != null;
    }

    @Override
    @Nullable
    public String getServiceCreationError() {
        JSLanguageServiceQueue jSLanguageServiceQueue = this.getProcessIfCreated();
        return jSLanguageServiceQueue != null ? jSLanguageServiceQueue.getStartErrorMessage() : null;
    }

    protected void resetState() {
        this.aliveChecker.resetState();
    }

    public void dispose() {
        block1: {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, (String)"Language service is disposed", null, (int)2, null);
            JSLanguageServiceQueue process2 = this.getProcessIfCreated();
            if (process2 != null) {
                this.disposeProcessSyncOrAsync(process2, null);
            }
            Span span = this.myLifecycleSpan;
            if (span == null) break block1;
            span.end();
        }
    }

    private static final JSLanguageServiceQueue _get_process_$lambda$1(JSLanguageServiceBase this$0) {
        return (JSLanguageServiceQueue)com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JSLanguageServiceQueue>, Object>(this$0, null){
            int label;
            final /* synthetic */ JSLanguageServiceBase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.getProcess((Continuation<? super JSLanguageServiceQueue>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super JSLanguageServiceQueue> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void terminateStartedProcessUnderLock$lambda$0(JSLanguageServiceBase this$0) {
        if (!this$0.myProject.isDisposed()) {
            DaemonCodeAnalyzer.getInstance((Project)this$0.myProject).restart((Object)"JSLanguageServiceBase process terminated");
        }
    }

    private static final void disposeProcessSyncOrAsync$lambda$0(JSLanguageServiceQueue $process, Runnable $onDisposed) {
        block0: {
            Disposer.dispose((Disposable)$process);
            Runnable runnable = $onDisposed;
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    public static final /* synthetic */ Mutex access$getMyProcessInit$p(JSLanguageServiceBase $this) {
        return $this.myProcessInit;
    }

    public static final /* synthetic */ JSLanguageServiceQueue access$getMyProcess$p(JSLanguageServiceBase $this) {
        return $this.myProcess;
    }

    public static final /* synthetic */ Object access$computeProcessUnderLocks(JSLanguageServiceBase $this, Continuation $completion) {
        return $this.computeProcessUnderLocks((Continuation<? super JSLanguageServiceQueue>)$completion);
    }

    public static final /* synthetic */ void access$setMyProcess$p(JSLanguageServiceBase $this, JSLanguageServiceQueue jSLanguageServiceQueue) {
        $this.myProcess = jSLanguageServiceQueue;
    }
}

