/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.javascript.JSSingleDistributionSupport;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.intentions.TypeScriptLibraryUtil;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferencesLibraryFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final String LIBRARY_NAME = "ts-external-references";

    public TypeScriptReferencesLibraryFix(PsiElement comment) {
        super(comment);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(3);
        }
        if (!(psiFile instanceof JSFile)) {
            return;
        }
        Collection<VirtualFile> files = TypeScriptReferencesLibraryFix.getFilesForLibrary((JSFile)psiFile);
        if (files.isEmpty()) {
            return;
        }
        Collection<Module> modules = TypeScriptLibraryUtil.getModules(project, ContainerUtil.createMaybeSingletonList((Object)psiFile.getVirtualFile()));
        TypeScriptLibraryUtil.updateLibrary(project, modules, LIBRARY_NAME, files, false);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesForLibrary(JSFile file) {
        TypeScriptReferencePathValidator validator = JSSingleDistributionSupport.getInstance().getTypeReferencePathValidator();
        if (validator == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptReferencesLibraryFix.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = validator.getOutOfProjectReferences(file);
        if (collection == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(9);
        }
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        TypeScriptReferencePathValidator validator = JSSingleDistributionSupport.getInstance().getTypeReferencePathValidator();
        if (validator == null) {
            return false;
        }
        return validator.hasOutOfProjectReferences((JSFile)psiFile);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"intention.name.create.library.with.files.outside.project", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(14);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(15);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

