/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.typescript.compiler.TypeScriptServiceRestarter;
import com.intellij.lang.typescript.lsp.BundledVersion;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsNodeDescriptor;
import com.intellij.lang.typescript.lsp.JSExternalDefinitionsPackageResolver;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.lang.typescript.lsp.LspServerPackageDescriptor;
import com.intellij.lang.typescript.lsp.PackageVersion;
import com.intellij.lang.typescript.lsp.TSPluginLoader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/typescript/lsp/JSServiceLoader;", "", "packageDescriptor", "Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;", "<init>", "(Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;)V", "getPackageDescriptor", "()Lcom/intellij/lang/typescript/lsp/LspServerPackageDescriptor;", "getSelectedPackageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "project", "Lcom/intellij/openapi/project/Project;", "getAbsolutePath", "", "getAbsolutePathForDefaultKey", "getAbsolutePathOrRefresh", "restartService", "", "createNodePackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "Lcom/intellij/lang/typescript/lsp/LspServerLoader;", "Lcom/intellij/lang/typescript/lsp/TSPluginLoader;", "intellij.javascript.backend"})
@ApiStatus.Experimental
public abstract sealed class JSServiceLoader
permits LspServerLoader, TSPluginLoader {
    @NotNull
    private final LspServerPackageDescriptor packageDescriptor;

    private JSServiceLoader(LspServerPackageDescriptor packageDescriptor) {
        this.packageDescriptor = packageDescriptor;
    }

    @NotNull
    public final LspServerPackageDescriptor getPackageDescriptor() {
        return this.packageDescriptor;
    }

    @NotNull
    public NodePackageRef getSelectedPackageRef(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExternalDefinitionsNodePackageKt.createPackageRef("Default", this.packageDescriptor.getServerPackage());
    }

    @Nullable
    public final String getAbsolutePath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NodePackageRef packageRef = this.getSelectedPackageRef(project);
        String ref2 = ExternalDefinitionsNodePackageKt.extractRefText(packageRef);
        if (Intrinsics.areEqual((Object)ref2, (Object)"Default")) {
            return this.getAbsolutePathForDefaultKey(project);
        }
        String string = FileUtil.toSystemDependentName((String)this.packageDescriptor.getPackageRelativePath(project, packageRef));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        String suffix = string;
        return StringsKt.endsWith$default((String)ref2, (String)suffix, (boolean)false, (int)2, null) ? ref2 : ref2 + suffix;
    }

    @Nullable
    protected String getAbsolutePathForDefaultKey(@NotNull Project project) {
        BundledVersion bundledVersion;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PackageVersion packageVersion = this.packageDescriptor.getDefaultVersion();
        BundledVersion bundledVersion2 = bundledVersion = packageVersion instanceof BundledVersion ? (BundledVersion)packageVersion : null;
        if (bundledVersion != null && ((Boolean)bundledVersion.isBundledEnabled().invoke()).booleanValue() && Intrinsics.areEqual((Object)this.packageDescriptor.getServerPackage().getVersion(), (Object)bundledVersion.getVersion())) {
            return new File(bundledVersion.getAbsolutePackagePath(), this.packageDescriptor.getDefaultPackageRelativePath()).getAbsolutePath();
        }
        return LspServerDownloadingKt.getDownloadedLspServerPath(this.packageDescriptor.getServerPackage(), this.packageDescriptor.getDefaultPackageRelativePath(), project);
    }

    @Nullable
    public final String getAbsolutePathOrRefresh(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String absolutePath = this.getAbsolutePath(project);
        if (absolutePath != null) {
            return absolutePath;
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            return null;
        }
        LspServerDownloadingKt.scheduleLspServerDownloading(project, this);
        return null;
    }

    @ApiStatus.OverrideOnly
    public void restartService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(() -> JSServiceLoader.restartService$lambda$0(project));
    }

    @NotNull
    public final NodePackageField createNodePackageField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JSExternalDefinitionsNodeDescriptor serverDescriptor = new JSExternalDefinitionsNodeDescriptor(this.packageDescriptor.getServerPackage());
        return new NodePackageField(project, (NodePackageDescriptor)serverDescriptor, () -> JSServiceLoader.createNodePackageField$lambda$0(project), (NodePackageRefResolver)new JSExternalDefinitionsPackageResolver(project, serverDescriptor));
    }

    private static final void restartService$lambda$0(Project $project) {
        TypeScriptServiceRestarter.restartServices($project);
    }

    private static final NodeJsInterpreter createNodePackageField$lambda$0(Project $project) {
        return NodeJsInterpreterManager.getInstance($project).getInterpreter();
    }

    public /* synthetic */ JSServiceLoader(LspServerPackageDescriptor packageDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(packageDescriptor);
    }
}

