/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.js.highlighting;

import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.highlighting.PolySymbolHighlightingCustomizer;
import com.intellij.polySymbols.js.JsSymbolKinds;
import com.intellij.polySymbols.js.JsSymbolSymbolKind;
import com.intellij.polySymbols.js.highlighting.JSSymbolHighlightingCustomizerKt;
import com.intellij.polySymbols.utils.PolySymbolUtils;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/polySymbols/js/highlighting/JSSymbolHighlightingCustomizer;", "Lcom/intellij/polySymbols/highlighting/PolySymbolHighlightingCustomizer;", "<init>", "()V", "getSymbolTextAttributes", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "host", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "symbol", "Lcom/intellij/polySymbols/PolySymbol;", "level", "", "shouldHighlightSymbol", "", "shouldHighlightProperty", "intellij.javascript.web"})
@SourceDebugExtension(value={"SMAP\nJSSymbolHighlightingCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSSymbolHighlightingCustomizer.kt\ncom/intellij/polySymbols/js/highlighting/JSSymbolHighlightingCustomizer\n+ 2 JSSymbolUtils.kt\ncom/intellij/polySymbols/js/JSPolySymbolUtils\n*L\n1#1,62:1\n64#2,2:63\n*S KotlinDebug\n*F\n+ 1 JSSymbolHighlightingCustomizer.kt\ncom/intellij/polySymbols/js/highlighting/JSSymbolHighlightingCustomizer\n*L\n26#1:63,2\n*E\n"})
public final class JSSymbolHighlightingCustomizer
implements PolySymbolHighlightingCustomizer {
    @Nullable
    public TextAttributesKey getSymbolTextAttributes(@NotNull PsiExternalReferenceHost host, @NotNull PolySymbol symbol2, int level) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (Intrinsics.areEqual((Object)PolySymbolUtils.getNamespace((PolySymbol)symbol2), (Object)"js")) {
            JSHighlighter highlighter = JSSymbolHighlightingCustomizerKt.getJSHighlighterFor((PsiElement)host);
            PolySymbolKind polySymbolKind = symbol2.getKind();
            if (Intrinsics.areEqual((Object)polySymbolKind, (Object)JsSymbolKinds.JS_SYMBOLS)) {
                if (level > 0 || this.shouldHighlightSymbol(host)) {
                    PolySymbol $this$jsKind$iv = symbol2;
                    boolean $i$f$getJSKind = false;
                    JsSymbolSymbolKind jsSymbolSymbolKind = (JsSymbolSymbolKind)$this$jsKind$iv.get(JsSymbolKinds.PROP_JS_SYMBOL_KIND);
                    if (jsSymbolSymbolKind == null) {
                        jsSymbolSymbolKind = Intrinsics.areEqual((Object)$this$jsKind$iv.getKind(), (Object)JsSymbolKinds.JS_PROPERTIES) ? JsSymbolSymbolKind.Property : JsSymbolSymbolKind.Variable;
                    }
                    return switch (WhenMappings.$EnumSwitchMapping$0[jsSymbolSymbolKind.ordinal()]) {
                        case 1 -> highlighter.getMappedKey(JSHighlighter.JS_LOCAL_VARIABLE);
                        case 2 -> highlighter.getMappedKey(JSHighlighter.JS_LOCAL_VARIABLE);
                        case 3 -> highlighter.getMappedKey(JSHighlighter.JS_LOCAL_FUNCTION);
                        case 4 -> highlighter.getMappedKey(JSHighlighter.JS_GLOBAL_VARIABLE);
                        case 5 -> highlighter.getMappedKey(JSHighlighter.JS_CLASS);
                        case 6 -> highlighter.getMappedKey(JSHighlighter.JS_INTERFACE);
                        case 7 -> highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
                        case 8 -> highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
                        case 9 -> highlighter.getMappedKey(JSHighlighter.JS_CLASS);
                        case 10 -> highlighter.getMappedKey(JSHighlighter.JS_TYPE_ALIAS);
                        case 11 -> highlighter.getMappedKey(JSHighlighter.JS_LOCAL_VARIABLE);
                        case 12 -> highlighter.getMappedKey(JSHighlighter.JS_TYPE_ALIAS);
                        default -> throw new NoWhenBranchMatchedException();
                    };
                }
            } else if (Intrinsics.areEqual((Object)polySymbolKind, (Object)JsSymbolKinds.JS_PROPERTIES) && (level > 0 || this.shouldHighlightProperty(host))) {
                return highlighter.getMappedKey(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
            }
        }
        return null;
    }

    private final boolean shouldHighlightSymbol(PsiExternalReferenceHost host) {
        return !(host instanceof JSReferenceExpression);
    }

    private final boolean shouldHighlightProperty(PsiExternalReferenceHost host) {
        return !(host instanceof JSReferenceExpression) && (!(host instanceof JSLiteralExpression) || !(((JSLiteralExpression)host).getParent() instanceof JSIndexedPropertyAccessExpression)) && !(host instanceof JSProperty);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsSymbolSymbolKind.values().length];
            try {
                nArray[JsSymbolSymbolKind.ObjectLiteral.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Variable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Function.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Namespace.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Class.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Interface.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Property.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Method.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Enum.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Alias.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Module.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsSymbolSymbolKind.Type.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

