/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.docker.gateway.actions;

import com.intellij.clouds.docker.gateway.DevcontainerDeployContext;
import com.intellij.clouds.docker.gateway.actions.DevcontainerCreateFromFileAbstractAction;
import com.intellij.clouds.docker.gateway.actions.DevcontainerCreateWithMountedSourcesGroupKt;
import com.intellij.clouds.docker.gateway.statistics.DevcontainerFileLocationStatCollector;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.devcontainers.DevcontainerPaths;
import com.intellij.docker.agent.devcontainers.buildStrategy.DevcontainerBuildStrategy;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BM\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0094@\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/clouds/docker/gateway/actions/DevcontainerCreateWithMountedSources;", "Lcom/intellij/clouds/docker/gateway/actions/DevcontainerCreateFromFileAbstractAction;", "dockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "ideBackend", "Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;", "modelFile", "Ljava/nio/file/Path;", "postInvoke", "Lkotlin/Function0;", "", "update", "Lkotlin/Function1;", "Lcom/intellij/openapi/actionSystem/Presentation;", "<init>", "(Lcom/intellij/remoteServer/configuration/RemoteServer;Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "getIdeBackend", "()Lcom/jetbrains/gateway/ssh/IntelliJPlatformProduct;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "beforeBuild", "getModelFile", "modifyContext", "context", "Lcom/intellij/clouds/docker/gateway/DevcontainerDeployContext;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/clouds/docker/gateway/DevcontainerDeployContext;Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.docker.gateway"})
@SourceDebugExtension(value={"SMAP\nDevcontainerCreateWithMountedSourcesGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerCreateWithMountedSourcesGroup.kt\ncom/intellij/clouds/docker/gateway/actions/DevcontainerCreateWithMountedSources\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class DevcontainerCreateWithMountedSources
extends DevcontainerCreateFromFileAbstractAction {
    @NotNull
    private final RemoteServer<DockerCloudConfiguration> dockerServer;
    @Nullable
    private final IntelliJPlatformProduct ideBackend;
    @Nullable
    private final Path modelFile;
    @Nullable
    private final Function0<Unit> postInvoke;
    @NotNull
    private final Function1<Presentation, Unit> update;

    public DevcontainerCreateWithMountedSources(@NotNull RemoteServer<DockerCloudConfiguration> dockerServer, @Nullable IntelliJPlatformProduct ideBackend, @Nullable Path modelFile, @Nullable Function0<Unit> postInvoke, @NotNull Function1<? super Presentation, Unit> update) {
        Intrinsics.checkNotNullParameter(dockerServer, (String)"dockerServer");
        Intrinsics.checkNotNullParameter(update, (String)"update");
        this.dockerServer = dockerServer;
        this.ideBackend = ideBackend;
        this.modelFile = modelFile;
        this.postInvoke = postInvoke;
        this.update = update;
    }

    @Nullable
    public final IntelliJPlatformProduct getIdeBackend() {
        return this.ideBackend;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DevcontainerCreateWithMountedSourcesGroupKt.access$shouldInformUserAboutPerformanceDegradation() && !DevcontainerCreateWithMountedSourcesGroupKt.access$informUserAboutPerformanceDegradation()) {
                return;
            }
            DockerUtils.addToServersManagerIfNeeded(this.dockerServer);
            super.actionPerformed(e);
            Function0<Unit> function0 = this.postInvoke;
            if (function0 == null) break block1;
            Function0<Unit> it = function0;
            boolean bl = false;
            it.invoke();
        }
    }

    @Override
    protected void beforeBuild(@NotNull Path modelFile) {
        Intrinsics.checkNotNullParameter((Object)modelFile, (String)"modelFile");
        DevcontainerFileLocationStatCollector.INSTANCE.logMount(modelFile);
    }

    @Override
    @Nullable
    public Path getModelFile(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Path path = this.modelFile;
        if (path == null) {
            path = super.getModelFile(e);
        }
        return path;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        this.update.invoke((Object)presentation);
        super.update(e);
    }

    @Override
    @Nullable
    protected Object modifyContext(@NotNull DevcontainerDeployContext context, @NotNull Project project, @NotNull Path modelFile, @NotNull Continuation<? super Unit> $completion) {
        Path path = DevcontainerPaths.INSTANCE.computeSourcesMountPath(modelFile);
        if (path == null) {
            throw new IllegalStateException("Cannot compute sources dir".toString());
        }
        Path sources = path;
        if (context instanceof DevcontainerDeployContext.Gateway) {
            ((DevcontainerDeployContext.Gateway)context).setPreselectedIde(this.ideBackend);
        }
        context.setConfig(this.dockerServer);
        context.setBuildFromLocalSources(new DevcontainerBuildStrategy.LocalBuildData(modelFile, sources, true));
        return Unit.INSTANCE;
    }
}

