/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.common.plugin;

import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.EditorConfigLanguage;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0010\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/editorconfig/common/plugin/EditorConfigFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "<init>", "()V", "getName", "", "getDescription", "Lorg/jetbrains/annotations/Nls;", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "getCharset", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "fileTypeName", "getFileTypeName", "()Ljava/lang/String;", "fileExtension", "getFileExtension", "intellij.editorconfig.common"})
public final class EditorConfigFileType
extends LanguageFileType {
    @NotNull
    public static final EditorConfigFileType INSTANCE = new EditorConfigFileType();

    private EditorConfigFileType() {
        super((Language)EditorConfigLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return this.getFileTypeName();
    }

    @NotNull
    public String getDescription() {
        return EditorConfigBundle.INSTANCE.get("file.type.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return this.getFileExtension();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Editorconfig;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Editorconfig");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return "UTF-8";
    }

    @NotNull
    public final String getFileTypeName() {
        return "EditorConfig";
    }

    @NotNull
    public final String getFileExtension() {
        return "editorconfig";
    }
}

