/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UndoManager {
    public static final Key<Document> ORIGINAL_DOCUMENT = new Key("ORIGINAL_DOCUMENT");

    public static UndoManager getInstance(@NotNull Project project) {
        if (project == null) {
            UndoManager.$$$reportNull$$$0(0);
        }
        return project.isDefault() ? UndoManager.getGlobalInstance() : (UndoManager)project.getService(UndoManager.class);
    }

    public static UndoManager getGlobalInstance() {
        return (UndoManager)ApplicationManager.getApplication().getService(UndoManager.class);
    }

    public abstract void undoableActionPerformed(@NotNull UndoableAction var1);

    public abstract void nonundoableActionPerformed(@NotNull DocumentReference var1, boolean var2);

    public abstract boolean isUndoInProgress();

    public abstract boolean isRedoInProgress();

    public boolean isUndoOrRedoInProgress() {
        return this.isUndoInProgress() || this.isRedoInProgress();
    }

    public abstract void undo(@Nullable FileEditor var1);

    public abstract void redo(@Nullable FileEditor var1);

    public abstract boolean isUndoAvailable(@Nullable FileEditor var1);

    public abstract boolean isRedoAvailable(@Nullable FileEditor var1);

    public abstract @NotNull Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getUndoActionNameAndDescription(FileEditor var1);

    public abstract @NotNull Pair<@NlsActions.ActionText String, @NlsActions.ActionDescription String> getRedoActionNameAndDescription(FileEditor var1);

    public abstract long getNextUndoNanoTime(@NotNull FileEditor var1);

    public abstract long getNextRedoNanoTime(@NotNull FileEditor var1);

    public abstract boolean isNextUndoAskConfirmation(@NotNull FileEditor var1);

    public abstract boolean isNextRedoAskConfirmation(@NotNull FileEditor var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/undo/UndoManager", "getInstance"));
    }
}

