/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemTaskCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.UnindexedFilesScannerExecutor;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemResolveProjectTask
extends AbstractExternalSystemTask {
    private final AtomicReference<DataNode<ProjectData>> myExternalProject;
    @NotNull
    @Nls
    private final String myProjectName;
    private final boolean myIsPreviewMode;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private final String myArguments;
    @Nullable
    private final ProjectResolverPolicy myResolverPolicy;

    public ExternalSystemResolveProjectTask(@NotNull Project project, @NotNull String projectPath, @NotNull ImportSpec importSpec) {
        if (project == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(1);
        }
        if (importSpec == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(2);
        }
        super(importSpec.getExternalSystemId(), ExternalSystemTaskType.RESOLVE_PROJECT, project, projectPath);
        this.myExternalProject = new AtomicReference();
        this.myProjectName = ExternalSystemResolveProjectTask.generateProjectName(projectPath);
        this.myIsPreviewMode = importSpec.isPreviewMode();
        this.myVmOptions = importSpec.getVmOptions();
        this.myArguments = importSpec.getArguments();
        this.myResolverPolicy = importSpec instanceof ImportSpecImpl ? importSpec.getProjectResolverPolicy() : null;
        UserDataHolderBase userData = importSpec.getUserData();
        if (userData != null) {
            userData.copyUserDataTo((UserDataHolderBase)this);
        }
    }

    @Override
    protected void doExecute() throws Exception {
        Project project = this.getIdeProject();
        ProjectSystemId projectSystemId = this.getExternalSystemId();
        String projectPath = this.getExternalProjectPath();
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = ExternalSystemProgressNotificationManagerImpl.getInstanceImpl();
        ExternalSystemTaskNotificationListener progressNotificationListener = ExternalSystemResolveProjectTask.wrapWithListener(progressNotificationManager);
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(projectSystemId)) {
            executionAware.prepareExecution(this, projectPath, this.myIsPreviewMode, progressNotificationListener, project);
        }
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectPath, (ProjectSystemId)projectSystemId);
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            settings.withVmOptions((Collection)ParametersListUtil.parse((String)this.myVmOptions));
        }
        if (StringUtil.isNotEmpty((String)this.myArguments)) {
            settings.withArguments((Collection)ParametersListUtil.parse((String)this.myArguments));
        }
        this.putUserDataTo((UserDataHolder)settings);
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = null;
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(projectSystemId)) {
            if (environmentConfigurationProvider != null) continue;
            environmentConfigurationProvider = executionAware.getEnvironmentConfigurationProvider(projectPath, this.myIsPreviewMode, project);
        }
        ExternalSystemExecutionAware.setEnvironmentConfigurationProvider(settings, environmentConfigurationProvider);
        this.resolveProjectInfo(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveProjectInfo(@NotNull ExternalSystemExecutionSettings settings) {
        if (settings == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(3);
        }
        ExternalSystemTaskId id = this.getId();
        Project project = this.getIdeProject();
        ProjectSystemId projectSystemId = this.getExternalSystemId();
        String projectPath = this.getExternalProjectPath();
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider(settings);
        StructuredIdeActivity activity = ExternalSystemTaskCollector.externalSystemTaskStarted(project, projectSystemId, com.intellij.openapi.externalSystem.statistics.ExternalSystemTaskId.ResolveProject, environmentConfigurationProvider);
        try {
            DataNode projectNode = this.suspendScanningAndIndexingThenRun(() -> {
                try {
                    ExternalSystemFacadeManager manager = ExternalSystemFacadeManager.getInstance();
                    RemoteExternalSystemFacade facade = manager.getFacade(project, projectPath, projectSystemId);
                    RemoteExternalSystemProjectResolver<ExternalSystemExecutionSettings> resolver = facade.getResolver();
                    return resolver.resolveProjectInfo(id, projectPath, this.myIsPreviewMode, settings, this.myResolverPolicy);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            });
            if (projectNode != null) {
                this.myExternalProject.set((DataNode<ProjectData>)projectNode);
                ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)projectSystemId);
                assert (externalSystemManager != null);
                HashSet<String> externalModulePaths = new HashSet<String>();
                Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
                for (DataNode node : moduleNodes) {
                    externalModulePaths.add(((ModuleData)node.getData()).getLinkedExternalProjectPath());
                }
                String ExternalProjectPath = ((ProjectData)projectNode.getData()).getLinkedExternalProjectPath();
                AbstractExternalSystemSettings externalSystemSettings = (AbstractExternalSystemSettings)externalSystemManager.getSettingsProvider().fun((Object)project);
                ExternalProjectSettings externalProjectSettings = externalSystemSettings.getLinkedProjectSettings(ExternalProjectPath);
                if (externalProjectSettings != null && !externalModulePaths.isEmpty()) {
                    externalProjectSettings.setModules(externalModulePaths);
                }
            }
        }
        finally {
            activity.finished();
        }
    }

    private <R> R suspendScanningAndIndexingThenRun(@NotNull Supplier<R> computable) {
        if (computable == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(4);
        }
        if (!Registry.is((String)"external.system.pause.indexing.during.sync")) {
            return computable.get();
        }
        Ref result = new Ref();
        String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{this.myProjectName, this.getExternalSystemId().getReadableName()});
        UnindexedFilesScannerExecutor.getInstance((Project)this.getIdeProject()).suspendScanningAndIndexingThenRun(title, () -> result.set(computable.get()));
        return (R)result.get();
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = ExternalSystemFacadeManager.getInstance();
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemProjectResolver resolver = facade.getResolver();
        return resolver.cancelTask(this.getId());
    }

    @Override
    @NotNull
    protected String wrapProgressText(@NotNull String text) {
        if (text == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(5);
        }
        String string = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{this.getExternalSystemId().getReadableName(), text});
        if (string == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isPreviewMode() {
        return this.myIsPreviewMode;
    }

    @Nullable
    public ProjectResolverPolicy getResolverPolicy() {
        return this.myResolverPolicy;
    }

    @NotNull
    @Nls
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String generateProjectName(@NotNull String externalProjectPath) {
        File projectFile;
        if (externalProjectPath == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(8);
        }
        if ((projectFile = new File(externalProjectPath)).isFile()) {
            String string = projectFile.getParentFile().getName();
            if (string == null) {
                ExternalSystemResolveProjectTask.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = projectFile.getName();
        if (string == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    protected void setState(@NotNull ExternalSystemTaskState state) {
        if (state == null) {
            ExternalSystemResolveProjectTask.$$$reportNull$$$0(11);
        }
        super.setState(state);
        if (state.isStopped() && (this.myResolverPolicy == null || !this.myResolverPolicy.isPartialDataResolveAllowed())) {
            InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(this.getExternalSystemId(), this.getExternalProjectPath(), (DataNode<ProjectData>)((DataNode)this.myExternalProject.getAndSet(null)));
            long currentTimeMillis = System.currentTimeMillis();
            projectInfo.setLastImportTimestamp(currentTimeMillis);
            projectInfo.setLastSuccessfulImportTimestamp(state == ExternalSystemTaskState.FAILED ? -1L : currentTimeMillis);
            ProjectDataManagerImpl.getInstance().updateExternalProjectData(this.getIdeProject(), projectInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemResolveProjectTask";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapProgressText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "suspendScanningAndIndexingThenRun";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgressText";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateProjectName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

