/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.Internal
public class ExternalSystemProjectsWatcherImpl
implements ExternalSystemProjectsWatcher {
    @NotNull
    private final Project project;
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");

    public ExternalSystemProjectsWatcherImpl(@NotNull Project project) {
        if (project == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    public void markDirtyAllExternalProjects() {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        List<ExternalSystemProjectId> projectSettings = this.findAllProjectSettings();
        ApplicationManager.getApplication().invokeLater(() -> {
            projectSettings.forEach(it -> projectTracker.markDirty(it));
            for (Contributor contributor2 : (Contributor[])EP_NAME.getExtensions()) {
                contributor2.markDirtyAllExternalProjects(this.project);
            }
            projectTracker.scheduleProjectRefresh();
        }, this.project.getDisposed());
    }

    public void markDirty(@NotNull Module module) {
        if (module == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(1);
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        List<ExternalSystemProjectId> projectSettings = this.findAllProjectSettings();
        ApplicationManager.getApplication().invokeLater(() -> {
            projectSettings.stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty(it));
            for (Contributor contributor2 : (Contributor[])EP_NAME.getExtensions()) {
                contributor2.markDirty(module);
            }
            projectTracker.scheduleProjectRefresh();
        }, module.getDisposed());
    }

    public void markDirty(@NotNull String projectPath) {
        if (projectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(2);
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.project);
        List<ExternalSystemProjectId> projectSettings = this.findAllProjectSettings();
        ApplicationManager.getApplication().invokeLater(() -> {
            projectSettings.stream().filter(it -> it.getExternalProjectPath().equals(projectPath)).forEach(it -> projectTracker.markDirty(it));
            for (Contributor contributor2 : (Contributor[])EP_NAME.getExtensions()) {
                contributor2.markDirty(projectPath);
            }
            projectTracker.scheduleProjectRefresh();
        }, this.project.getDisposed());
    }

    private List<ExternalSystemProjectId> findAllProjectSettings() {
        ArrayList<ExternalSystemProjectId> list = new ArrayList<ExternalSystemProjectId>();
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> {
            ProjectSystemId systemId = manager.getSystemId();
            Collection linkedProjectsSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.project)).getLinkedProjectsSettings();
            for (ExternalProjectSettings settings : linkedProjectsSettings) {
                String externalProjectPath = settings.getExternalProjectPath();
                if (externalProjectPath == null) continue;
                list.add(new ExternalSystemProjectId(systemId, externalProjectPath));
            }
        });
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markDirty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);

        default public void markDirty(@NotNull String projectPath) {
            if (projectPath == null) {
                Contributor.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$Contributor", "markDirty"));
        }
    }
}

