/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectsStructure
extends SimpleTreeStructure
implements Disposable {
    private final Project myProject;
    private final Tree myTree;
    private ExternalProjectsView myExternalProjectsView;
    private StructureTreeModel<ExternalProjectsStructure> myTreeModel;
    private RootNode<?> myRoot;
    private final Map<String, ExternalSystemNode<?>> myNodeMapping = new HashMap();
    private AsyncTreeModel myAsyncTreeModel;

    public ExternalProjectsStructure(Project project, Tree tree) {
        this.myProject = project;
        this.myTree = tree;
        ExternalProjectsStructure.configureTree(tree);
    }

    public void init(ExternalProjectsView externalProjectsView) {
        this.myExternalProjectsView = externalProjectsView;
        this.myRoot = new RootNode(this);
        this.myTreeModel = new StructureTreeModel((AbstractTreeStructure)this, (Disposable)this);
        this.myAsyncTreeModel = new AsyncTreeModel(this.myTreeModel, (Disposable)this);
        this.myTree.setModel((TreeModel)this.myAsyncTreeModel);
        TreeUtil.expand((JTree)this.myTree, (int)1);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void updateFrom(SimpleNode node) {
        if (node != null) {
            this.myTreeModel.invalidate((Object)node, true);
        }
    }

    public void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.myTreeModel.invalidate((Object)each, false);
        }
    }

    @NotNull
    public Object getRootElement() {
        RootNode<?> rootNode = this.myRoot;
        if (rootNode == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(0);
        }
        return rootNode;
    }

    public void cleanupCache() {
        this.myRoot.cleanUpCache();
        this.myNodeMapping.clear();
        this.myTreeModel.invalidateAsync();
    }

    private static void configureTree(Tree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
    }

    public void select(@NotNull SimpleNode node) {
        if (node == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(1);
        }
        this.myTreeModel.select((Object)node, (JTree)this.myTree, path -> {});
    }

    public void expand(@NotNull SimpleNode node) {
        if (node == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(2);
        }
        this.myTreeModel.expand((Object)node, (JTree)this.myTree, path -> {});
    }

    protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
        return null;
    }

    public void updateProjects(Collection<? extends DataNode<ProjectData>> toImport) {
        List toImportPaths = ContainerUtil.map(toImport, pd -> ((ProjectData)pd.getData()).getLinkedExternalProjectPath());
        Collection orphanProjects = ContainerUtil.subtract((Collection)ContainerUtil.mapNotNull(this.myNodeMapping.entrySet(), entry -> entry.getValue() instanceof ProjectNode ? (String)entry.getKey() : null), (Collection)toImportPaths);
        for (DataNode<ProjectData> dataNode : toImport) {
            ProjectData projectData = (ProjectData)dataNode.getData();
            String projectPath = projectData.getLinkedExternalProjectPath();
            ExternalSystemNode projectNode = this.findNodeFor(projectPath);
            if (projectNode instanceof ProjectNode) {
                this.doMergeChildrenChanges(projectNode, new ProjectNode(this.myExternalProjectsView, dataNode));
            } else {
                SimpleNode parent;
                ExternalSystemNode<?> node = this.myNodeMapping.remove(projectPath);
                if (node != null && (parent = node.getParent()) instanceof ExternalSystemNode) {
                    ((ExternalSystemNode)parent).remove(projectNode);
                }
                projectNode = new ProjectNode(this.myExternalProjectsView, dataNode);
                this.myNodeMapping.put(projectPath, projectNode);
            }
            if (toImport.size() == 1) {
                TreeUtil.expand((JTree)this.myTree, (int)1);
            }
            this.doUpdateProject((ProjectNode)projectNode);
        }
        for (String string : orphanProjects) {
            SimpleNode parent;
            ExternalSystemNode<?> projectNode = this.myNodeMapping.remove(string);
            if (!(projectNode instanceof ProjectNode) || !((parent = projectNode.getParent()) instanceof ExternalSystemNode)) continue;
            ((ExternalSystemNode)parent).remove(projectNode);
            this.updateUpTo(projectNode);
        }
    }

    private void doMergeChildrenChanges(ExternalSystemNode<?> currentNode, ExternalSystemNode newNode) {
        Object key;
        ExternalSystemNode<?>[] cached = currentNode.getCached();
        if (cached == null) {
            currentNode.mergeWith(newNode);
            return;
        }
        ArrayList duplicates = new ArrayList();
        LinkedHashMap oldDataMap = new LinkedHashMap();
        for (ExternalSystemNode<?> node : cached) {
            Object key2 = node.getData() != null ? node.getData() : node.getName();
            ExternalSystemNode<?> externalSystemNode = oldDataMap.put(key2, node);
            if (externalSystemNode == null) continue;
            duplicates.add(key2);
        }
        LinkedHashMap newDataMap = new LinkedHashMap();
        LinkedHashMap unchangedNewDataMap = new LinkedHashMap();
        for (ExternalSystemNode<?> externalSystemNode : newNode.getChildren()) {
            Object object = key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
            if (oldDataMap.remove(key) == null) {
                newDataMap.put(key, externalSystemNode);
                continue;
            }
            unchangedNewDataMap.put(key, externalSystemNode);
        }
        for (Object duplicate : duplicates) {
            newDataMap.remove(duplicate);
        }
        currentNode.removeAll(oldDataMap.values());
        for (ExternalSystemNode<?> externalSystemNode : currentNode.getChildren()) {
            key = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
            ExternalSystemNode unchangedNewNode = (ExternalSystemNode)unchangedNewDataMap.get(key);
            if (unchangedNewNode == null) continue;
            this.doMergeChildrenChanges(externalSystemNode, unchangedNewNode);
        }
        this.updateFrom(currentNode);
        currentNode.mergeWith(newNode);
        currentNode.addAll(newDataMap.values());
    }

    private void doUpdateProject(ProjectNode node) {
        RootNode<ProjectData> newParentNode = this.myRoot;
        if (!node.isVisible()) {
            newParentNode.remove(node);
        } else {
            node.updateProject();
            ExternalProjectsStructure.reconnectNode(node, newParentNode);
        }
    }

    private static void reconnectNode(ProjectNode node, ExternalSystemNode<?> newParentNode) {
        ExternalSystemNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals(newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        }
    }

    private ExternalSystemNode findNodeFor(String projectPath) {
        return this.myNodeMapping.get(projectPath);
    }

    public <T extends ExternalSystemNode> void updateNodesAsync(@NotNull Collection<Class<? extends T>> nodeClasses) {
        if (nodeClasses == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(3);
        }
        this.updateNodesAsync(nodeClasses, false);
    }

    public <T extends ExternalSystemNode> void updateNodesAsync(@NotNull Collection<Class<? extends T>> nodeClasses, boolean structure) {
        if (nodeClasses == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(4);
        }
        LinkedList nodes = new LinkedList();
        this.myAsyncTreeModel.accept(new CollectingVisitor<T>(nodes, nodeClasses), false).onSuccess(p -> this.invalidatePaths(nodes, structure));
    }

    private void invalidatePaths(@NotNull Collection<TreePath> paths, boolean structure) {
        if (paths == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(5);
        }
        if (paths.isEmpty()) {
            return;
        }
        paths.forEach(p -> this.myTreeModel.invalidate(p, structure));
    }

    public <T extends ExternalSystemNode> void visitNodes(@NotNull Class<? extends T> nodeClass, @NotNull Consumer<? super T> consumer) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(7);
        }
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            consumer.consume((Object)node);
        }
    }

    public <T extends ExternalSystemNode> void visitExistingNodes(@NotNull Class<? extends T> nodeClass, @NotNull Consumer<? super T> consumer) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(9);
        }
        for (ExternalSystemNode node : this.getExistingNodes(nodeClass)) {
            consumer.consume((Object)node);
        }
    }

    public void dispose() {
        this.myExternalProjectsView = null;
        this.myNodeMapping.clear();
        this.myRoot = null;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getNodes(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(10);
        }
        return ExternalProjectsStructure.doGetNodes(nodeClass, this.myRoot.getChildren(), new SmartList(), node -> true);
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getExistingNodes(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(11);
        }
        return ExternalProjectsStructure.doGetNodes(nodeClass, this.myRoot.getChildren(), new SmartList(), node -> {
            if (node instanceof ExternalSystemNode) {
                ExternalSystemNode esNode = (ExternalSystemNode)node;
                ExternalSystemNode<?>[] cachedNodes = esNode.getCached();
                return cachedNodes != null && cachedNodes.length > 0;
            }
            return true;
        });
    }

    @NotNull
    private static <T extends ExternalSystemNode> List<T> doGetNodes(@NotNull Class<T> nodeClass, SimpleNode[] nodes, @NotNull List<T> result, @NotNull Predicate<SimpleNode> shouldDive) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(12);
        }
        if (result == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(13);
        }
        if (shouldDive == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(14);
        }
        if (nodes == null) {
            List<T> list = result;
            if (list == null) {
                ExternalProjectsStructure.$$$reportNull$$$0(15);
            }
            return list;
        }
        for (SimpleNode node : nodes) {
            if (nodeClass.isInstance(node)) {
                result.add((ExternalSystemNode)node);
            }
            if (!shouldDive.test(node)) continue;
            ExternalProjectsStructure.doGetNodes(nodeClass, node.getChildren(), result, shouldDive);
        }
        List<T> list = result;
        if (list == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        List list = TreeUtil.collectSelectedObjectsOfType((JTree)tree, nodeClass);
        if (list == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClasses";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldDive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNodes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateNodesAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidatePaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitNodes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitExistingNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExistingNodes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doGetNodes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    public class RootNode<T>
    extends ExternalSystemNode<T> {
        public RootNode(ExternalProjectsStructure this$0) {
            super(this$0.myExternalProjectsView, null, null);
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    private static final class CollectingVisitor<T extends ExternalSystemNode>
    implements TreeVisitor {
        private final List<? super TreePath> myCollector;
        private final Collection<Class<? extends T>> myNodeClasses;

        private CollectingVisitor(List<? super TreePath> nodeCollector, Collection<Class<? extends T>> nodeClasses) {
            this.myCollector = nodeCollector;
            this.myNodeClasses = nodeClasses;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            Object object;
            if (path == null) {
                CollectingVisitor.$$$reportNull$$$0(0);
            }
            if ((object = TreeUtil.getLastUserObject((TreePath)path)) != null && this.anyAssignableFrom(object.getClass())) {
                this.myCollector.add(path);
            }
            TreeVisitor.Action action2 = TreeVisitor.Action.CONTINUE;
            if (action2 == null) {
                CollectingVisitor.$$$reportNull$$$0(1);
            }
            return action2;
        }

        boolean anyAssignableFrom(Class<?> classParam) {
            for (Class<T> aClass : this.myNodeClasses) {
                if (!aClass.isAssignableFrom(classParam)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure$CollectingVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure$CollectingVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }
}

