/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0082\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u0096\u0080\u0004J\n\u0010 \u001a\u00020\u0003H\u0096\u0080\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/jetbrains/vuejs/model/source/VueSourceDirective;", "Lorg/jetbrains/vuejs/model/VueDirective;", "name", "", "source", "Lcom/intellij/psi/PsiElement;", "typeSource", "mode", "Lorg/jetbrains/vuejs/model/VueMode;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/vuejs/model/VueMode;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "defaultName", "getDefaultName", "()Ljava/lang/String;", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "modifiers", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getModifiers", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueSourceDirective
implements VueDirective {
    @NotNull
    private final PsiElement source;
    @Nullable
    private final PsiElement typeSource;
    @NotNull
    private final VueMode mode;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<VueEntitiesContainer> parents;

    public VueSourceDirective(@NotNull String name, @NotNull PsiElement source, @Nullable PsiElement typeSource, @NotNull VueMode mode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.source = source;
        this.typeSource = typeSource;
        this.mode = mode;
        this.defaultName = name;
        this.parents = CollectionsKt.emptyList();
    }

    public /* synthetic */ VueSourceDirective(String string, PsiElement psiElement, PsiElement psiElement2, VueMode vueMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            psiElement2 = null;
        }
        if ((n & 8) != 0) {
            vueMode = VueMode.CLASSIC;
        }
        this(string, psiElement, psiElement2, vueMode);
    }

    @Override
    @NotNull
    public PsiElement getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getModifiers() {
        if (this.typeSource == null) {
            return CollectionsKt.emptyList();
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)this.typeSource, () -> VueSourceDirective._get_modifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public Pointer<? extends VueSourceDirective> createPointer() {
        String name = this.getDefaultName();
        SmartPsiElementPointer source = SmartPointersKt.createSmartPointer((PsiElement)this.getSource());
        PsiElement psiElement = this.typeSource;
        SmartPsiElementPointer typeSource = psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null;
        VueMode mode = this.mode;
        return () -> VueSourceDirective.createPointer$lambda$0(source, typeSource, name, mode);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueSourceDirective && Intrinsics.areEqual((Object)((VueSourceDirective)other).getDefaultName(), (Object)this.getDefaultName()) && Intrinsics.areEqual((Object)((VueSourceDirective)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getDefaultName(), this.getSource()};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        return "VueSourceDirective(" + this.getDefaultName() + ")";
    }

    private static final CachedValueProvider.Result _get_modifiers_$lambda$0(VueSourceDirective this$0) {
        List<VueDirectiveModifier> list = VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.typeSource, this$0.mode);
        Object[] objectArray = new Object[2];
        Project project = this$0.typeSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = DumbService.Companion.getInstance(project).getModificationTracker();
        objectArray[1] = PsiModificationTracker.MODIFICATION_COUNT;
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final VueSourceDirective createPointer$lambda$0(SmartPsiElementPointer $source, SmartPsiElementPointer $typeSource, String $name, VueMode $mode) {
        PsiElement psiElement;
        PsiElement psiElement2 = $source.dereference();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement newSource = psiElement2;
        if ($typeSource != null) {
            psiElement = $typeSource.dereference();
            if (psiElement == null) {
                return null;
            }
        } else {
            psiElement = null;
        }
        PsiElement newTypeSource = psiElement;
        return new VueSourceDirective($name, newSource, newTypeSource, $mode);
    }
}

