/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.xdebugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.dap.CommandScope;
import com.intellij.platform.dap.DapBundle;
import com.intellij.platform.dap.DapCommandProcessor;
import com.intellij.platform.dap.DapEvaluationResult;
import com.intellij.platform.dap.DapExceptionInfo;
import com.intellij.platform.dap.DapScope;
import com.intellij.platform.dap.DapStackFrame;
import com.intellij.platform.dap.DapThread;
import com.intellij.platform.dap.DapThreadState;
import com.intellij.platform.dap.StackFrameType;
import com.intellij.platform.dap.TextPosition;
import com.intellij.platform.dap.xdebugger.DapXDebuggerPresentationFactory;
import com.intellij.platform.dap.xdebugger.DefaultDapXDebuggerEvaluator;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/platform/dap/xdebugger/DefaultDapXStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "factory", "Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "commandProcessor", "Lcom/intellij/platform/dap/DapCommandProcessor;", "thread", "Lcom/intellij/platform/dap/DapThread;", "frame", "Lcom/intellij/platform/dap/DapStackFrame;", "<init>", "(Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;Lcom/intellij/platform/dap/DapCommandProcessor;Lcom/intellij/platform/dap/DapThread;Lcom/intellij/platform/dap/DapStackFrame;)V", "getFactory", "()Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "getCommandProcessor", "()Lcom/intellij/platform/dap/DapCommandProcessor;", "getThread", "()Lcom/intellij/platform/dap/DapThread;", "getFrame", "()Lcom/intellij/platform/dap/DapStackFrame;", "_sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Lorg/jetbrains/annotations/Nullable;", "get_sourcePosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "_sourcePosition$delegate", "Lkotlin/Lazy;", "_evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "get_evaluator", "()Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "_evaluator$delegate", "getEvaluator", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "LABEL_ATTRIBUTES", "Lcom/intellij/ui/SimpleTextAttributes;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getSourcePosition", "getEqualityObject", "", "intellij.platform.dap"})
@ApiStatus.Experimental
public class DefaultDapXStackFrame
extends XStackFrame {
    @NotNull
    private final DapXDebuggerPresentationFactory factory;
    @NotNull
    private final DapCommandProcessor commandProcessor;
    @NotNull
    private final DapThread thread;
    @NotNull
    private final DapStackFrame frame;
    @NotNull
    private final Lazy _sourcePosition$delegate;
    @NotNull
    private final Lazy _evaluator$delegate;
    @NotNull
    private final SimpleTextAttributes LABEL_ATTRIBUTES;

    public DefaultDapXStackFrame(@NotNull DapXDebuggerPresentationFactory factory, @NotNull DapCommandProcessor commandProcessor, @NotNull DapThread thread2, @NotNull DapStackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)commandProcessor, (String)"commandProcessor");
        Intrinsics.checkNotNullParameter((Object)thread2, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.factory = factory;
        this.commandProcessor = commandProcessor;
        this.thread = thread2;
        this.frame = frame;
        this._sourcePosition$delegate = LazyKt.lazy(() -> DefaultDapXStackFrame._sourcePosition_delegate$lambda$0(this));
        this._evaluator$delegate = LazyKt.lazy(() -> DefaultDapXStackFrame._evaluator_delegate$lambda$0(this));
        this.LABEL_ATTRIBUTES = new SimpleTextAttributes(17, NamedColorUtil.getInactiveTextColor());
    }

    @NotNull
    public final DapXDebuggerPresentationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final DapCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public final DapThread getThread() {
        return this.thread;
    }

    @NotNull
    public final DapStackFrame getFrame() {
        return this.frame;
    }

    private final XSourcePosition get_sourcePosition() {
        Lazy lazy = this._sourcePosition$delegate;
        return (XSourcePosition)lazy.getValue();
    }

    private final XDebuggerEvaluator get_evaluator() {
        Lazy lazy = this._evaluator$delegate;
        return (XDebuggerEvaluator)lazy.getValue();
    }

    @NotNull
    public XDebuggerEvaluator getEvaluator() {
        return this.get_evaluator();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DapThreadState threadState = this.thread.getState();
        if (!(threadState instanceof DapThreadState.Paused)) {
            node.setErrorMessage(XDebuggerBundle.message((String)"debugger.frames.dialog.message.not.available.for.unsuspended", (Object[])new Object[0]));
            return;
        }
        this.commandProcessor.submitCommand((Function2<? super CommandScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CommandScope, Continuation<? super Unit>, Object>(this, threadState, node, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultDapXStackFrame this$0;
            final /* synthetic */ DapThreadState $threadState;
            final /* synthetic */ XCompositeNode $node;
            {
                this.this$0 = $receiver;
                this.$threadState = $threadState;
                this.$node = $node;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block10: {
                    var2_2 = (CommandScope)this.L$0;
                    var11_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$invokeSuspend_u24lambda_u240 = this.this$0.getFrame();
                            $i$a$-run-DefaultDapXStackFrame$computeChildren$1$scopes$1 = 0;
                            this.L$0 = $this$submitCommand;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u240);
                            this.I$0 = $i$a$-run-DefaultDapXStackFrame$computeChildren$1$scopes$1;
                            this.label = 1;
                            v0 = $this$invokeSuspend_u24lambda_u240.scopes((CommandScope)$this$submitCommand, (Continuation<? super List<? extends DapScope>>)this);
                            if (v0 == var11_3) {
                                return var11_3;
                            }
                            ** GOTO lbl22
                        }
                        case 1: {
                            $i$a$-run-DefaultDapXStackFrame$computeChildren$1$scopes$1 = this.I$0;
                            $this$invokeSuspend_u24lambda_u240 = (DapStackFrame)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            scopes = (List)v0;
                            childrenList = new XValueChildrenList();
                            exceptionInfo = ((DapThreadState.Paused)this.$threadState).getExceptionInfo();
                            v1 = exceptionInfo;
                            v2 = v1 != null && (v1 = v1.getRawDetails()) != null ? v1.getEvaluateName() : (exceptionGetterExpression = null);
                            if (exceptionGetterExpression == null) break;
                            $this$invokeSuspend_u24lambda_u241 = this.this$0.getFrame();
                            $i$a$-run-DefaultDapXStackFrame$computeChildren$1$evaluationResult$1 = 0;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$submitCommand);
                            this.L$1 = scopes;
                            this.L$2 = childrenList;
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)exceptionInfo);
                            this.L$4 = SpillingKt.nullOutSpilledVariable((Object)exceptionGetterExpression);
                            this.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$invokeSuspend_u24lambda_u241);
                            this.I$0 = $i$a$-run-DefaultDapXStackFrame$computeChildren$1$evaluationResult$1;
                            this.label = 2;
                            v3 = $this$invokeSuspend_u24lambda_u241.evaluate((CommandScope)$this$submitCommand, exceptionGetterExpression, (Continuation<? super DapEvaluationResult>)this);
                            if (v3 == var11_3) {
                                return var11_3;
                            }
                            ** GOTO lbl52
                        }
                        case 2: {
                            $i$a$-run-DefaultDapXStackFrame$computeChildren$1$evaluationResult$1 = this.I$0;
                            $this$invokeSuspend_u24lambda_u241 = (DapStackFrame)this.L$5;
                            exceptionGetterExpression = (String)this.L$4;
                            exceptionInfo = (DapExceptionInfo)this.L$3;
                            childrenList = (XValueChildrenList)this.L$2;
                            scopes = (List)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl52:
                            // 2 sources

                            evaluationResult = (DapEvaluationResult)v3;
                            if (evaluationResult instanceof DapEvaluationResult.Success) {
                                this.$node.addChildren(XValueChildrenList.singleton((XNamedValue)this.this$0.getFactory().createValue(this.this$0.getCommandProcessor(), ((DapEvaluationResult.Success)evaluationResult).getVariable(), AllIcons.Nodes.ExceptionClass)), false);
                            }
                            break block10;
                        }
                    }
                    v4 = exceptionInfo;
                    if ((v4 != null ? v4.getMessage() : null) != null) {
                        this.$node.setMessage(exceptionInfo.getMessage(), AllIcons.Nodes.ExceptionClass, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
                    }
                }
                var7_13 = ((Iterable)scopes).iterator();
                var8_14 = 0;
                while (var7_13.hasNext()) {
                    index = var8_14++;
                    scope = (DapScope)var7_13.next();
                    childrenList.addTopGroup(this.this$0.getFactory().createScope(this.this$0.getCommandProcessor(), scope, index));
                }
                this.$node.addChildren(childrenList, true);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CommandScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        TextPosition position = this.frame.getStartPosition();
        VirtualFile source = this.frame.getSource();
        SimpleTextAttributes textAttributes = switch (WhenMappings.$EnumSwitchMapping$0[this.frame.getType().ordinal()]) {
            case 1 -> this.LABEL_ATTRIBUTES;
            case 2 -> {
                if (source != null) {
                    yield SimpleTextAttributes.REGULAR_ATTRIBUTES;
                }
                yield SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        component.append(this.frame.getName(), textAttributes);
        if (source != null) {
            component.append(", " + source.getName(), textAttributes);
            component.append(":" + position.getLine() + ":" + position.getColumn(), textAttributes);
        } else {
            component.append(", ", textAttributes);
            component.append(DapBundle.INSTANCE.message("dap.frames.unknown_source", new Object[0]), textAttributes);
        }
        component.setIcon(AllIcons.Debugger.Frame);
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.get_sourcePosition();
    }

    @NotNull
    public Object getEqualityObject() {
        VirtualFile virtualFile = this.frame.getSource();
        return (virtualFile != null ? virtualFile.getPath() : null) + ":" + this.frame.getStartPosition().getLine() + ":" + this.frame.getStartPosition().getLine();
    }

    private static final XSourcePosition _sourcePosition_delegate$lambda$0(DefaultDapXStackFrame this$0) {
        XSourcePosition xSourcePosition;
        VirtualFile virtualFile = this$0.frame.getSource();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            xSourcePosition = XDebuggerUtil.getInstance().createPosition(this$0.frame.getSource(), this$0.frame.getStartPosition().getLine() - 1);
        } else {
            xSourcePosition = null;
        }
        return xSourcePosition;
    }

    private static final DefaultDapXDebuggerEvaluator _evaluator_delegate$lambda$0(DefaultDapXStackFrame this$0) {
        return new DefaultDapXDebuggerEvaluator(this$0.commandProcessor, this$0.factory, this$0.frame);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StackFrameType.values().length];
            try {
                nArray[StackFrameType.Label.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.Normal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

