/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.xmlSchemeGenerator.webrefGenerator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.BrowserSpecificData;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.ValuesBrowserSpecificEquivalents;
import com.intellij.css.xmlSchemeGenerator.valueDefinitionSyntax.CssValueDefinitionSyntaxParsingUtil;
import com.intellij.css.xmlSchemeGenerator.valueDefinitionSyntax.parser.CssValueDefinitionSyntaxFile;
import com.intellij.css.xmlSchemeGenerator.valueDefinitionSyntax.parser.psi.FuncParams;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.CssSchemeGeneratorConfigKt;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.CssValueSchemeGeneratorVisitor;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderImpl;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010%\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020,J \u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000fH\u0002J\u0018\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J\u000e\u00106\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000fJ\u0006\u00107\u001a\u00020\u000fJ\u0012\u00108\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020:H\u0002J\u0012\u0010=\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0018\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u00020AH\u0002J\u0012\u0010B\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0018\u0010C\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u000fH\u0002J\u0012\u0010H\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J*\u0010I\u001a\u00020,2\u0006\u0010J\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u000f2\b\u0010L\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010M\u001a\u00020,2\u0006\u0010L\u001a\u00020\u000fJ\"\u0010N\u001a\u00020,2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\u000f2\n\b\u0002\u0010O\u001a\u0004\u0018\u00010PJ(\u0010Q\u001a\u00020,2\u0006\u00109\u001a\u00020:2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u000f2\u0006\u0010U\u001a\u00020\u000fH\u0002J\u0012\u0010V\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0018\u0010W\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020\u000f2\u0006\u0010Y\u001a\u00020\u000fH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010 \u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R,\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000f0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/CssWebrefSchemaGenerator;", "", "compatData", "Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/BrowserSpecificData;", "<init>", "(Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/BrowserSpecificData;)V", "getCompatData", "()Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/BrowserSpecificData;", "xmlBuilder", "Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "getXmlBuilder", "()Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "setXmlBuilder", "(Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;)V", "myVersion", "", "getMyVersion", "()Ljava/lang/String;", "setMyVersion", "(Ljava/lang/String;)V", "propertiesWithoutValueResult", "getPropertiesWithoutValueResult", "setPropertiesWithoutValueResult", "namedValuesWithoutValueResult", "getNamedValuesWithoutValueResult", "setNamedValuesWithoutValueResult", "unhandledAtRuleDescriptors", "getUnhandledAtRuleDescriptors", "setUnhandledAtRuleDescriptors", "errorValueDefinitions", "getErrorValueDefinitions", "setErrorValueDefinitions", "moduleName", "getModuleName", "setModuleName", "alreadyAddedInCurrentXmlNamedValues", "", "", "", "getAlreadyAddedInCurrentXmlNamedValues", "()Ljava/util/Map;", "setAlreadyAddedInCurrentXmlNamedValues", "(Ljava/util/Map;)V", "generateFromFile", "", "filePath", "generate", "logUnhandledData", "fileName", "data", "specName", "createDefinitionFile", "definition", "propertyName", "saveToFile", "getGeneratedText", "generateProperties", "json", "Lcom/google/gson/JsonObject;", "generateProperty", "propertyObject", "generateAtRulesDescriptors", "generateMediaFeature", "descriptorObject", "isRange", "", "generateNamedValues", "generateFunction", "id", "argumentsExpressionText", "COMBINATORS", "", "generateSelectors", "generateSelector", "tagName", "href", "valueText", "generateContextFunctions", "generateValues", "compatValues", "Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/ValuesBrowserSpecificEquivalents;", "addOptionalAttribute", "element", "Lorg/w3c/dom/Element;", "attributeKey", "attributeKeyOutput", "generateHeadDescription", "parseVersion", "title", "url", "Companion", "intellij.css.xmlSchemeGenerator"})
@SourceDebugExtension(value={"SMAP\nCssWebrefSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssWebrefSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/webrefGenerator/CssWebrefSchemaGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,392:1\n777#2:393\n873#2,2:394\n1915#2,2:421\n383#3,7:396\n383#3,7:403\n383#3,7:410\n416#4,4:417\n1#5:423\n*S KotlinDebug\n*F\n+ 1 CssWebrefSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/webrefGenerator/CssWebrefSchemaGenerator\n*L\n245#1:393\n245#1:394,2\n348#1:421,2\n271#1:396,7\n285#1:403,7\n299#1:410,7\n324#1:417,4\n*E\n"})
public final class CssWebrefSchemaGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BrowserSpecificData compatData;
    @NotNull
    private XmlBuilderImpl xmlBuilder;
    @NotNull
    private String myVersion;
    @NotNull
    private String propertiesWithoutValueResult;
    @NotNull
    private String namedValuesWithoutValueResult;
    @NotNull
    private String unhandledAtRuleDescriptors;
    @NotNull
    private String errorValueDefinitions;
    @NotNull
    private String moduleName;
    @NotNull
    private Map<String, Set<Integer>> alreadyAddedInCurrentXmlNamedValues;
    @NotNull
    private final Set<String> COMBINATORS;

    public CssWebrefSchemaGenerator(@Nullable BrowserSpecificData compatData) {
        this.compatData = compatData;
        this.xmlBuilder = new XmlBuilderImpl();
        this.myVersion = "1.0";
        this.propertiesWithoutValueResult = "";
        this.namedValuesWithoutValueResult = "";
        this.unhandledAtRuleDescriptors = "";
        this.errorValueDefinitions = "";
        this.moduleName = "";
        this.alreadyAddedInCurrentXmlNamedValues = new LinkedHashMap();
        Object[] objectArray = new String[]{">", "+", "~", "||"};
        this.COMBINATORS = SetsKt.setOf((Object[])objectArray);
    }

    public /* synthetic */ CssWebrefSchemaGenerator(BrowserSpecificData browserSpecificData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            browserSpecificData = null;
        }
        this(browserSpecificData);
    }

    @Nullable
    public final BrowserSpecificData getCompatData() {
        return this.compatData;
    }

    @NotNull
    public final XmlBuilderImpl getXmlBuilder() {
        return this.xmlBuilder;
    }

    public final void setXmlBuilder(@NotNull XmlBuilderImpl xmlBuilderImpl) {
        Intrinsics.checkNotNullParameter((Object)xmlBuilderImpl, (String)"<set-?>");
        this.xmlBuilder = xmlBuilderImpl;
    }

    @NotNull
    public final String getMyVersion() {
        return this.myVersion;
    }

    public final void setMyVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.myVersion = string;
    }

    @NotNull
    public final String getPropertiesWithoutValueResult() {
        return this.propertiesWithoutValueResult;
    }

    public final void setPropertiesWithoutValueResult(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.propertiesWithoutValueResult = string;
    }

    @NotNull
    public final String getNamedValuesWithoutValueResult() {
        return this.namedValuesWithoutValueResult;
    }

    public final void setNamedValuesWithoutValueResult(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.namedValuesWithoutValueResult = string;
    }

    @NotNull
    public final String getUnhandledAtRuleDescriptors() {
        return this.unhandledAtRuleDescriptors;
    }

    public final void setUnhandledAtRuleDescriptors(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.unhandledAtRuleDescriptors = string;
    }

    @NotNull
    public final String getErrorValueDefinitions() {
        return this.errorValueDefinitions;
    }

    public final void setErrorValueDefinitions(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.errorValueDefinitions = string;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.moduleName = string;
    }

    @NotNull
    public final Map<String, Set<Integer>> getAlreadyAddedInCurrentXmlNamedValues() {
        return this.alreadyAddedInCurrentXmlNamedValues;
    }

    public final void setAlreadyAddedInCurrentXmlNamedValues(@NotNull Map<String, Set<Integer>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.alreadyAddedInCurrentXmlNamedValues = map;
    }

    public final void generateFromFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        FileReader reader = new FileReader(new File(filePath));
        JsonObject moduleElement = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        String specName = moduleElement.getAsJsonObject("spec").getAsJsonPrimitive("title").getAsString();
        Intrinsics.checkNotNull((Object)specName);
        this.moduleName = specName;
        if (moduleElement.isJsonObject()) {
            this.xmlBuilder = new XmlBuilderImpl();
            this.propertiesWithoutValueResult = "";
            this.namedValuesWithoutValueResult = "";
            this.unhandledAtRuleDescriptors = "";
            this.errorValueDefinitions = "";
            this.alreadyAddedInCurrentXmlNamedValues = new LinkedHashMap();
            this.xmlBuilder.addTag("definitions", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateFromFile$lambda$0(this, moduleElement, arg_0)));
        }
        this.logUnhandledData("propertiesWithoutValueDescription.txt", this.propertiesWithoutValueResult, specName);
        this.logUnhandledData("namedValuesWithoutValueDescription.txt", this.namedValuesWithoutValueResult, specName);
        this.logUnhandledData("unhandledAtRuleDescriptors.txt", this.unhandledAtRuleDescriptors, specName);
        this.logUnhandledData("errorValueDefinitions.txt", this.errorValueDefinitions, specName);
    }

    public final void generate() {
        block2: {
            File directory = new File("plugins/css/xmlSchemeGenerator/resources/sources/webrefJsons/");
            if (!directory.exists() || !directory.isDirectory()) {
                return;
            }
            File[] listFiles = directory.listFiles();
            Intrinsics.checkNotNull((Object)listFiles);
            int n = listFiles.length;
            for (int i = 0; i < n; ++i) {
                if (Intrinsics.areEqual((Object)listFiles[i].getName(), (Object)"package.json") || CssSchemeGeneratorConfigKt.getExcludedModules().contains(listFiles[i].getName())) continue;
                String string = listFiles[i].getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.generateFromFile(string);
                File file = listFiles[i];
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(...)");
                this.saveToFile("plugins/css/xmlSchemeGenerator/resources/generated-xmls/webref/" + FilesKt.getNameWithoutExtension((File)file) + ".xml");
            }
            BrowserSpecificData browserSpecificData = this.compatData;
            if (browserSpecificData == null) break block2;
            browserSpecificData.cleanUp();
        }
    }

    private final void logUnhandledData(String fileName, String data, String specName) {
        if (((CharSequence)data).length() > 0) {
            FilesKt.appendText$default((File)new File("plugins/css/xmlSchemeGenerator/resources/logs/convertationInfo/" + fileName), (String)(specName + "\n" + data + "\n"), null, (int)2, null);
        }
    }

    private final void createDefinitionFile(String definition, String propertyName) {
        File outputDir = new File("plugins/css/xmlSchemeGenerator/resources/logs/errorValueDefinitions/" + StringsKt.replace$default((String)this.moduleName, (String)" ", (String)"", (boolean)false, (int)4, null));
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        FileOutputStream fs = new FileOutputStream("plugins/css/xmlSchemeGenerator/resources/logs/errorValueDefinitions/" + StringsKt.replace$default((String)this.moduleName, (String)" ", (String)"", (boolean)false, (int)4, null) + "/" + propertyName + ".cssdefinition");
        String string = definition;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        fs.write(byArray);
        fs.close();
    }

    public final void saveToFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File xmlFile = new File(filePath);
        xmlFile.createNewFile();
        XmlBuilderKt.saveToFile(this.xmlBuilder, xmlFile);
    }

    @NotNull
    public final String getGeneratedText() {
        return XmlBuilderKt.getText(this.xmlBuilder);
    }

    private final void generateProperties(JsonObject json) {
        if (json == null) {
            return;
        }
        JsonArray properties = json.getAsJsonArray("properties");
        if (properties == null) {
            return;
        }
        Iterator iterator = properties.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement property = (JsonElement)iterator2.next();
            JsonObject jsonObject = property.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            this.generateProperty(jsonObject);
        }
    }

    private final void generateProperty(JsonObject propertyObject) {
        Object object;
        this.generateNamedValues(propertyObject);
        String name = propertyObject.getAsJsonPrimitive("name").getAsString();
        if (CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"property", (Object)name))) {
            return;
        }
        Ref.ObjectRef valueText = new Ref.ObjectRef();
        JsonPrimitive jsonPrimitive = propertyObject.getAsJsonPrimitive("value");
        valueText.element = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
        JsonPrimitive propertyNewValues = propertyObject.getAsJsonPrimitive("newValues");
        JsonPrimitive legacyAliasOf = propertyObject.getAsJsonPrimitive("legacyAliasOf");
        if (valueText.element == null && propertyNewValues == null && legacyAliasOf == null) {
            this.propertiesWithoutValueResult = this.propertiesWithoutValueResult + propertyObject.getAsJsonPrimitive("name").getAsString() + "\n";
            return;
        }
        String string = (String)valueText.element;
        if (string == null) {
            string = "";
        }
        if ((object = propertyNewValues) == null || (object = object.getAsString()) == null) {
            object = "";
        }
        valueText.element = string + (String)object;
        this.generateContextFunctions((String)valueText.element);
        this.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateProperty$lambda$0(name, this, propertyObject, legacyAliasOf, valueText, arg_0)));
    }

    private final void generateAtRulesDescriptors(JsonObject json) {
        if (json == null) {
            return;
        }
        JsonArray atRules = json.getAsJsonArray("atrules");
        if (atRules == null) {
            return;
        }
        Iterator iterator = atRules.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterator iterator3;
            JsonElement atRule = (JsonElement)iterator2.next();
            this.generateNamedValues(atRule.getAsJsonObject());
            JsonArray descriptors = atRule.getAsJsonObject().getAsJsonArray("descriptors");
            if (descriptors == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)descriptors.iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                String forAtRule;
                JsonElement descriptor = (JsonElement)iterator3.next();
                JsonObject descriptorObject = descriptor.getAsJsonObject();
                String name = descriptorObject.getAsJsonPrimitive("name").getAsString();
                JsonPrimitive jsonPrimitive = descriptorObject.getAsJsonPrimitive("type");
                String typeName = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
                JsonPrimitive jsonPrimitive2 = descriptorObject.getAsJsonPrimitive("for");
                String string = forAtRule = jsonPrimitive2 != null ? jsonPrimitive2.getAsString() : null;
                if (!Intrinsics.areEqual((Object)forAtRule, (Object)"@media")) {
                    if (typeName != null) {
                        this.unhandledAtRuleDescriptors = this.unhandledAtRuleDescriptors + forAtRule + " " + typeName + "(type): " + name + "\n";
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)descriptorObject);
                    this.generateProperty(descriptorObject);
                    continue;
                }
                String string2 = typeName;
                if (Intrinsics.areEqual((Object)string2, (Object)"range")) {
                    Intrinsics.checkNotNull((Object)descriptorObject);
                    this.generateMediaFeature(descriptorObject, true);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string2, (Object)"discrete")) {
                    Intrinsics.checkNotNull((Object)descriptorObject);
                    this.generateMediaFeature(descriptorObject, false);
                    continue;
                }
                this.unhandledAtRuleDescriptors = this.unhandledAtRuleDescriptors + "@media " + typeName + "(type): " + name + "\n";
            }
        }
    }

    private final void generateMediaFeature(JsonObject descriptorObject, boolean isRange) {
        this.generateNamedValues(descriptorObject);
        String name = descriptorObject.getAsJsonPrimitive("name").getAsString();
        if (CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"mediaFeature", (Object)name))) {
            return;
        }
        Object object = descriptorObject.getAsJsonPrimitive("value");
        if (object == null || (object = object.getAsString()) == null) {
            object = "";
        }
        Object valueText = object;
        this.generateContextFunctions((String)valueText);
        this.xmlBuilder.addTag("media-feature", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateMediaFeature$lambda$0(name, this, descriptorObject, isRange, (String)valueText, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void generateNamedValues(JsonObject json) {
        if (json == null) {
            return;
        }
        JsonArray values = json.getAsJsonArray("values");
        if (values == null) {
            return;
        }
        Iterator iterator = values.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Set set;
            Set value$iv;
            Map<String, Set<Integer>> $this$getOrPut$iv;
            Map<String, Set<Integer>> $this$filter$iv;
            JsonArray values2;
            JsonElement value = (JsonElement)iterator2.next();
            JsonObject valueObject = value.getAsJsonObject();
            this.generateNamedValues(valueObject);
            Ref.ObjectRef name = new Ref.ObjectRef();
            name.element = valueObject.get("name").getAsString();
            String type = valueObject.get("type").getAsString();
            Ref.ObjectRef valueText = new Ref.ObjectRef();
            JsonElement jsonElement = valueObject.get("value");
            valueText.element = jsonElement != null ? jsonElement.getAsString() : null;
            JsonElement jsonElement2 = valueObject.get("values");
            Object object = values2 = jsonElement2 != null ? jsonElement2.getAsJsonArray() : null;
            if (valueText.element == null && values2 == null) {
                CharSequence charSequence = this.namedValuesWithoutValueResult;
                Object object2 = name.element;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)((CharSequence)object2), (boolean)false, (int)2, null)) continue;
                this.namedValuesWithoutValueResult = this.namedValuesWithoutValueResult + name.element + "\n";
                continue;
            }
            if (valueText.element == null) {
                void $this$filterTo$iv$iv;
                JsonArray jsonArray = values2;
                Intrinsics.checkNotNull((Object)jsonArray);
                Iterable iterable = (Iterable)jsonArray;
                Ref.ObjectRef objectRef = valueText;
                boolean $i$f$filter = false;
                void var12_14 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    JsonElement it = (JsonElement)element$iv$iv;
                    boolean bl = false;
                    if (!(!CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"namedValue", (Object)it.getAsJsonObject().get("name").getAsString())))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                objectRef.element = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" | ", null, null, (int)0, null, CssWebrefSchemaGenerator::generateNamedValues$lambda$1, (int)30, null);
            }
            if (((CharSequence)valueText.element).length() == 0 || Intrinsics.areEqual((Object)valueText.element, (Object)name.element)) continue;
            if (Intrinsics.areEqual((Object)type, (Object)"type") || Intrinsics.areEqual((Object)type, (Object)"value")) {
                Object object3 = name.element;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element");
                name.element = StringsKt.dropLast((String)StringsKt.drop((String)((String)object3), (int)1), (int)1);
            }
            if (CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"namedValue", name.element))) continue;
            if (CssSchemeGeneratorConfigKt.getBASIC_TAG_NAMES().contains(name.element)) {
                Set set2;
                System.out.println(name.element);
                if (((CharSequence)valueText.element).length() == 0 || this.alreadyAddedInCurrentXmlNamedValues.containsKey(name.element) && ((Set)MapsKt.getValue(this.alreadyAddedInCurrentXmlNamedValues, (Object)name.element)).contains(((String)valueText.element).hashCode())) continue;
                this.xmlBuilder.addTag("named-value", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateNamedValues$lambda$2(name, this, valueObject, valueText, arg_0)));
                $this$filter$iv = this.alreadyAddedInCurrentXmlNamedValues;
                Object key$iv = name.element;
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put((String)key$iv, answer$iv);
                    set2 = answer$iv;
                } else {
                    set2 = value$iv;
                }
                set2.add(((String)valueText.element).hashCode());
                continue;
            }
            if (this.alreadyAddedInCurrentXmlNamedValues.containsKey(name.element) && ((Set)MapsKt.getValue(this.alreadyAddedInCurrentXmlNamedValues, (Object)name.element)).contains(((String)valueText.element).hashCode())) continue;
            this.generateContextFunctions((String)valueText.element);
            this.xmlBuilder.addTag("named-value", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateNamedValues$lambda$4(name, this, valueObject, valueText, arg_0)));
            $this$getOrPut$iv = this.alreadyAddedInCurrentXmlNamedValues;
            Object key$iv = name.element;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put((String)key$iv, answer$iv);
                set = answer$iv;
            } else {
                set = value$iv;
            }
            set.add(((String)valueText.element).hashCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateFunction(String id, String argumentsExpressionText) {
        if (CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"function", (Object)id))) {
            return;
        }
        if (!this.alreadyAddedInCurrentXmlNamedValues.containsKey(id) || !((Set)MapsKt.getValue(this.alreadyAddedInCurrentXmlNamedValues, (Object)id)).contains(argumentsExpressionText.hashCode())) {
            Object object;
            void $this$getOrPut$iv;
            this.xmlBuilder.addTag("function", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateFunction$lambda$0(id, this, argumentsExpressionText, arg_0)));
            Map<String, Set<Integer>> map = this.alreadyAddedInCurrentXmlNamedValues;
            String key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(argumentsExpressionText.hashCode());
        }
    }

    private final void generateSelectors(JsonObject json) {
        if (json == null) {
            return;
        }
        JsonArray selectors = json.getAsJsonArray("selectors");
        if (selectors == null) {
            return;
        }
        Iterator iterator = selectors.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String selectorType;
            String value;
            String href;
            String name;
            block6: {
                String string;
                JsonElement selector = (JsonElement)iterator2.next();
                JsonObject selectorObject = selector.getAsJsonObject();
                name = selectorObject.getAsJsonPrimitive("name").getAsString();
                href = selectorObject.getAsJsonPrimitive("href").getAsString();
                JsonPrimitive jsonPrimitive = selectorObject.getAsJsonPrimitive("value");
                value = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
                String string2 = value;
                value = string2 != null && (string2 = StringsKt.substringAfter$default((String)string2, (char)'(', null, (int)2, null)) != null ? StringsKt.substringBefore$default((String)string2, (char)')', null, (int)2, null) : null;
                String string3 = name;
                Intrinsics.checkNotNull((Object)string3);
                selectorType = Companion.getCssEntityType(string3);
                string3 = name;
                Intrinsics.checkNotNull((Object)string3);
                if (StringsKt.endsWith$default((String)string3, (String)"()", (boolean)false, (int)2, null)) {
                    string3 = name;
                    Intrinsics.checkNotNull((Object)string3);
                    name = StringsKt.dropLast((String)string3, (int)2);
                    if (value == null) {
                        value = "<selector>";
                    }
                }
                string3 = name;
                Intrinsics.checkNotNull((Object)string3);
                String $this$dropWhile$iv = string3;
                boolean $i$f$dropWhile = false;
                int n = ((CharSequence)$this$dropWhile$iv).length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$dropWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ':') continue;
                    String string4 = $this$dropWhile$iv.substring(index$iv);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    break block6;
                }
                string = name = "";
            }
            if (selectorType == null) continue;
            Intrinsics.checkNotNull((Object)href);
            this.generateSelector(selectorType, name, href, value);
        }
    }

    private final void generateSelector(String tagName, String id, String href, String valueText) {
        if (CssSchemeGeneratorConfigKt.getExcludeDefinitions().contains(new Pair((Object)"selector", (Object)id))) {
            return;
        }
        this.xmlBuilder.addTag(tagName, (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateSelector$lambda$0(id, this, href, valueText, arg_0)));
    }

    public final void generateContextFunctions(@NotNull String valueText) {
        Intrinsics.checkNotNullParameter((Object)valueText, (String)"valueText");
        CssValueDefinitionSyntaxFile parsedValueFile = CssValueDefinitionSyntaxParsingUtil.parseFile(valueText);
        Intrinsics.checkNotNull((Object)((Object)parsedValueFile));
        if (PsiTreeUtilKt.hasErrorElementInRange((PsiFile)((PsiFile)parsedValueFile), (TextRange)new TextRange(0, parsedValueFile.getText().length()))) {
            return;
        }
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)parsedValueFile), FuncParams.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FuncParams funcParamElement = (FuncParams)element$iv;
            boolean bl = false;
            String functionName = funcParamElement.getIdent().getText();
            String functionValue = funcParamElement.getExpression().getText();
            Intrinsics.checkNotNull((Object)functionName);
            Intrinsics.checkNotNull((Object)functionValue);
            this.generateFunction(functionName, functionValue);
        }
    }

    public final void generateValues(@NotNull String id, @NotNull String valueText, @Nullable ValuesBrowserSpecificEquivalents compatValues) {
        CssValueDefinitionSyntaxFile parsedValueFile;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)valueText, (String)"valueText");
        CssValueDefinitionSyntaxFile cssValueDefinitionSyntaxFile = parsedValueFile = CssValueDefinitionSyntaxParsingUtil.parseFile(valueText);
        Intrinsics.checkNotNull((Object)((Object)cssValueDefinitionSyntaxFile));
        if (PsiTreeUtilKt.hasErrorElementInRange((PsiFile)((PsiFile)cssValueDefinitionSyntaxFile), (TextRange)new TextRange(0, parsedValueFile.getText().length()))) {
            this.errorValueDefinitions = this.errorValueDefinitions + id + ": " + valueText + "\n";
            this.createDefinitionFile(valueText, id);
            parsedValueFile = CssValueDefinitionSyntaxParsingUtil.parseFile("<any>");
        }
        parsedValueFile.acceptChildren(new CssValueSchemeGeneratorVisitor(this.xmlBuilder, compatValues));
    }

    public static /* synthetic */ void generateValues$default(CssWebrefSchemaGenerator cssWebrefSchemaGenerator, String string, String string2, ValuesBrowserSpecificEquivalents valuesBrowserSpecificEquivalents, int n, Object object) {
        if ((n & 4) != 0) {
            valuesBrowserSpecificEquivalents = null;
        }
        cssWebrefSchemaGenerator.generateValues(string, string2, valuesBrowserSpecificEquivalents);
    }

    private final void addOptionalAttribute(JsonObject json, Element element, String attributeKey, String attributeKeyOutput) {
        String attributeValue;
        JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive(attributeKey);
        String string = attributeValue = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
        if (attributeValue != null) {
            element.setAttribute(attributeKeyOutput, attributeValue);
        }
    }

    private final void generateHeadDescription(JsonObject json) {
        if (json == null) {
            return;
        }
        JsonObject spec = json.getAsJsonObject("spec");
        if (spec == null) {
            return;
        }
        String title = spec.getAsJsonPrimitive("title").getAsString();
        String url = spec.getAsJsonPrimitive("url").getAsString();
        Intrinsics.checkNotNull((Object)title);
        Intrinsics.checkNotNull((Object)url);
        this.myVersion = this.parseVersion(title, url);
        this.xmlBuilder.addComment(title + "\n" + url + "\n");
    }

    private final String parseVersion(String title, String url) {
        Object object;
        Character titleVersion = StringsKt.lastOrNull((CharSequence)title);
        Character urlVersion = StringsKt.getOrNull((CharSequence)url, (int)(url.length() - 2));
        Character c = titleVersion;
        boolean bl = c != null ? Character.isDigit(c.charValue()) : false;
        if (bl) {
            object = titleVersion + ".0";
        } else {
            Character c2 = urlVersion;
            object = (c2 != null ? Character.isDigit(c2.charValue()) : false) ? urlVersion + ".0" : "0";
        }
        return object;
    }

    private static final Unit generateFromFile$lambda$0(CssWebrefSchemaGenerator this$0, JsonObject $moduleElement, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("xmlns", "urn:schemas-jetbrains-com:css-xml");
        this$0.generateHeadDescription($moduleElement);
        this$0.generateProperties($moduleElement);
        this$0.generateAtRulesDescriptors($moduleElement);
        this$0.generateSelectors($moduleElement);
        this$0.generateNamedValues($moduleElement);
        return Unit.INSTANCE;
    }

    private static final Unit generateProperty$lambda$0$0(JsonPrimitive $legacyAliasOf, Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setAttribute("id", $legacyAliasOf.getAsString());
        return Unit.INSTANCE;
    }

    private static final Unit generateProperty$lambda$0(String $name, CssWebrefSchemaGenerator this$0, JsonObject $propertyObject, JsonPrimitive $legacyAliasOf, Ref.ObjectRef $valueText, Element element) {
        String mediaAttributeValue;
        String inheritedValue;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        element.setAttribute("declared-in", this$0.myVersion);
        this$0.addOptionalAttribute($propertyObject, element, "href", "url");
        this$0.addOptionalAttribute($propertyObject, element, "initial", "initial");
        this$0.addOptionalAttribute($propertyObject, element, "appliesTo", "applies");
        JsonPrimitive jsonPrimitive = $propertyObject.getAsJsonPrimitive("inherited");
        String string = inheritedValue = jsonPrimitive != null ? jsonPrimitive.getAsString() : null;
        if (inheritedValue != null && (Intrinsics.areEqual((Object)inheritedValue, (Object)"yes") || Intrinsics.areEqual((Object)inheritedValue, (Object)"no"))) {
            element.setAttribute("inherited", inheritedValue);
        }
        this$0.addOptionalAttribute($propertyObject, element, "percentages", "percentage");
        this$0.addOptionalAttribute($propertyObject, element, "media", "media");
        JsonPrimitive jsonPrimitive2 = $propertyObject.getAsJsonPrimitive("media");
        String string2 = mediaAttributeValue = jsonPrimitive2 != null ? jsonPrimitive2.getAsString() : null;
        if (mediaAttributeValue != null) {
            element.setAttribute("media", StringsKt.replace$default((String)mediaAttributeValue, (String)",", (String)"", (boolean)false, (int)4, null));
        }
        this$0.addOptionalAttribute($propertyObject, element, "for", "rules");
        JsonPrimitive animatable = $propertyObject.getAsJsonPrimitive("animationType");
        if (animatable != null) {
            if (Intrinsics.areEqual((Object)animatable.getAsString(), (Object)"not animatable")) {
                element.setAttribute("animatable", "no");
            } else {
                element.setAttribute("animatable", "yes");
            }
        }
        if ($legacyAliasOf != null) {
            this$0.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssWebrefSchemaGenerator.generateProperty$lambda$0$0($legacyAliasOf, arg_0)));
        } else {
            Intrinsics.checkNotNull((Object)$name);
            BrowserSpecificData browserSpecificData = this$0.compatData;
            this$0.generateValues($name, (String)$valueText.element, browserSpecificData != null ? browserSpecificData.getPerPropertyMap().get($name) : null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateMediaFeature$lambda$0(String $name, CssWebrefSchemaGenerator this$0, JsonObject $descriptorObject, boolean $isRange, String $valueText, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        element.setAttribute("declared-in", this$0.myVersion);
        this$0.addOptionalAttribute($descriptorObject, element, "href", "url");
        element.setAttribute("min-max", $isRange ? "yes" : "no");
        Intrinsics.checkNotNull((Object)$name);
        CssWebrefSchemaGenerator.generateValues$default(this$0, $name, $valueText, null, 4, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence generateNamedValues$lambda$1(JsonElement it) {
        void var1_1;
        String valueName = it.getAsJsonObject().get("name").getAsString();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)valueName);
        Object object = StringsKt.endsWith$default((String)valueName, (String)"()", (boolean)false, (int)2, null) ? "<" + valueName + ">" : var1_1;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"let(...)");
        return object;
    }

    private static final Unit generateNamedValues$lambda$2(Ref.ObjectRef $name, CssWebrefSchemaGenerator this$0, JsonObject $valueObject, Ref.ObjectRef $valueText, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name.element + "-unit");
        element.setAttribute("declared-in", this$0.myVersion);
        Intrinsics.checkNotNull((Object)$valueObject);
        this$0.addOptionalAttribute($valueObject, element, "href", "url");
        Object object = $name.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        CssWebrefSchemaGenerator.generateValues$default(this$0, (String)object, (String)$valueText.element, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit generateNamedValues$lambda$4(Ref.ObjectRef $name, CssWebrefSchemaGenerator this$0, JsonObject $valueObject, Ref.ObjectRef $valueText, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", (String)$name.element);
        element.setAttribute("declared-in", this$0.myVersion);
        Intrinsics.checkNotNull((Object)$valueObject);
        this$0.addOptionalAttribute($valueObject, element, "href", "url");
        Object object = $name.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        CssWebrefSchemaGenerator.generateValues$default(this$0, (String)object, (String)$valueText.element, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit generateFunction$lambda$0(String $id, CssWebrefSchemaGenerator this$0, String $argumentsExpressionText, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $id);
        element.setAttribute("declared-in", this$0.myVersion);
        CssWebrefSchemaGenerator.generateValues$default(this$0, $id, $argumentsExpressionText, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit generateSelector$lambda$0(String $id, CssWebrefSchemaGenerator this$0, String $href, String $valueText, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $id);
        element.setAttribute("declared-in", this$0.myVersion);
        element.setAttribute("url", $href);
        if ($valueText != null && !Intrinsics.areEqual((Object)(":" + $id), (Object)$valueText) && !Intrinsics.areEqual((Object)("::" + $id), (Object)$valueText)) {
            CssWebrefSchemaGenerator.generateValues$default(this$0, $id, $valueText, null, 4, null);
        }
        return Unit.INSTANCE;
    }

    public CssWebrefSchemaGenerator() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/CssWebrefSchemaGenerator$Companion;", "", "<init>", "()V", "getCssEntityType", "", "name", "intellij.css.xmlSchemeGenerator"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getCssEntityType(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return StringsKt.startsWith$default((String)name, (String)"&lt;", (boolean)false, (int)2, null) ? "named-value" : (StringsKt.startsWith$default((String)name, (String)"<", (boolean)false, (int)2, null) ? "named-value" : (StringsKt.startsWith$default((String)name, (String)"::", (boolean)false, (int)2, null) ? "pseudo-element" : (StringsKt.startsWith$default((String)name, (String)":", (boolean)false, (int)2, null) ? "pseudo-class" : (StringsKt.endsWith$default((String)name, (String)"()", (boolean)false, (int)2, null) ? "function" : null))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

