/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public final class DominatedNodesBuilder {
    private final int myNodesCnt;
    private final IntList myDominatorsTree;
    private final IntList myDominatedIdx;
    private final IntList myDominatedLinks;

    public DominatedNodesBuilder(IntList dominatorsTree, int nodesCnt) {
        this.myDominatorsTree = dominatorsTree;
        this.myNodesCnt = nodesCnt;
        this.myDominatedIdx = new IntArrayList(this.myNodesCnt);
        this.myDominatedLinks = new IntArrayList(this.myNodesCnt);
    }

    public void execute() {
        int i;
        int i2;
        for (i2 = 0; i2 < this.myNodesCnt; ++i2) {
            this.myDominatedIdx.add(0);
            this.myDominatedLinks.add(-1);
        }
        for (i2 = 1; i2 < this.myNodesCnt; ++i2) {
            int dominator = this.myDominatorsTree.getInt(i2);
            this.myDominatedIdx.set(dominator, this.myDominatedIdx.getInt(dominator) + 1);
        }
        int offset = 0;
        IntArrayList runningIndex = new IntArrayList(this.myNodesCnt);
        for (i = 0; i < this.myNodesCnt; ++i) {
            int cnt = this.myDominatedIdx.getInt(i);
            runningIndex.add(cnt);
            this.myDominatedIdx.set(i, offset);
            offset += cnt;
        }
        for (i = 1; i < this.myNodesCnt; ++i) {
            int dominator = this.myDominatorsTree.getInt(i);
            int left = runningIndex.getInt(dominator);
            int was = this.myDominatedIdx.getInt(dominator);
            if (was < 0 || left <= 0) continue;
            this.myDominatedLinks.set(was + left - 1, i);
            runningIndex.set(dominator, left - 1);
        }
    }

    public IntList getDominatedIdx() {
        return this.myDominatedIdx;
    }

    public IntList getDominatedLinks() {
        return this.myDominatedLinks;
    }
}

