/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.connection;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.split.connection.ConnectionDeclineReason;
import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.IPasswordAuthHandler;
import com.intellij.platform.split.connection.protocol.channel.frame.ForceTerminateWireFrame;
import com.intellij.platform.split.connection.protocol.channel.frame.Frame;
import com.intellij.platform.split.connection.protocol.channel.frame.FrameFactory;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.wire.SessionTokenHandler;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageEntry;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.connection.ClientAcceptState;
import com.jetbrains.rdserver.connection.HostCertificateUtilityKt;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.SecureClientData;
import com.jetbrains.rdserver.unattendedHost.connection.RdServerPasswordAuthHandler;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostConnectionManagerImplKt;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedHostTokenService;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J.\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostConnectionManagerImpl;", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionId", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;)V", "getSessionId", "()Ljava/lang/String;", "isSessionAccepted", "", "attachProject", "", "project", "Lcom/intellij/openapi/project/Project;", "createPasswordHandler", "Lcom/intellij/platform/split/connection/protocol/IPasswordAuthHandler;", "isController", "clientData", "Lcom/jetbrains/rdserver/startup/SecureClientData;", "askForConfirmationIfNeeded", "id", "wire", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "futureToComplete", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/rdserver/connection/ClientAcceptState;", "terminateObsoleteConnections", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "createSessionTokenHandler", "Lcom/intellij/platform/split/connection/protocol/wire/SessionTokenHandler;", "terminateExistingConnection", "intellij.platform.remoteController.backend"})
@SourceDebugExtension(value={"SMAP\nUnattendedHostConnectionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnattendedHostConnectionManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostConnectionManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n1#2:123\n1915#3,2:124\n60#4,5:126\n60#4,5:131\n60#4,5:136\n*S KotlinDebug\n*F\n+ 1 UnattendedHostConnectionManagerImpl.kt\ncom/jetbrains/rdserver/unattendedHost/connection/UnattendedHostConnectionManagerImpl\n*L\n97#1:124,2\n109#1:126,5\n114#1:131,5\n119#1:136,5\n*E\n"})
public final class UnattendedHostConnectionManagerImpl
extends RdServerConnectionManager {
    @Nullable
    private final String sessionId;

    public UnattendedHostConnectionManagerImpl(@NotNull Lifetime lifetime, @Nullable String sessionId) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(lifetime, HostCertificateUtilityKt.getRemoteDevHostCertificate(), false);
        this.sessionId = sessionId;
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public boolean isSessionAccepted(@Nullable String sessionId) {
        return this.sessionId == null || Intrinsics.areEqual((Object)this.sessionId, (Object)sessionId);
    }

    public final void attachProject(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl2 = bl = !project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UnattendedHostConnectionManagerImpl$attachProject$32 = false;
            String $i$a$-assert-UnattendedHostConnectionManagerImpl$attachProject$32 = "Can't attach to default project: " + project;
            throw new AssertionError((Object)$i$a$-assert-UnattendedHostConnectionManagerImpl$attachProject$32);
        }
        boolean bl3 = bl = !project.isDisposed();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Can't attach to disposed project: " + project;
            throw new AssertionError((Object)string);
        }
        UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).bracketIfAlive(() -> UnattendedHostConnectionManagerImpl.attachProject$lambda$2(this, project), () -> UnattendedHostConnectionManagerImpl.attachProject$lambda$3(this, project));
    }

    @Nullable
    protected IPasswordAuthHandler createPasswordHandler() {
        RdServerPasswordAuthHandler rdServerPasswordAuthHandler;
        UnattendedHostTokenService.PasswordRequest passwordRequest = UnattendedHostTokenService.Companion.getInstance().createPasswordRequest();
        if (passwordRequest != null) {
            UnattendedHostTokenService.PasswordRequest it = passwordRequest;
            boolean bl = false;
            rdServerPasswordAuthHandler = new RdServerPasswordAuthHandler(it);
        } else {
            rdServerPasswordAuthHandler = null;
        }
        return rdServerPasswordAuthHandler;
    }

    protected boolean isController(@NotNull SecureClientData clientData) {
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        SelfSignedCertificate.ProductInfo productInfo = ((SelfSignedCertificate.SelfSignedCertificateData)this.getHostCertificate().getValue()).getProductInfo();
        if (!(productInfo != null ? productInfo.isSet(1) : false)) {
            return false;
        }
        UnattendedHostTokenService service = UnattendedHostTokenService.Companion.getInstance();
        return service.wasClientJoinedViaToken(clientData.getClientId()) || service.hasClientUsedValidTokenPreviously(clientData) || UnattendedModeManagerImpl.Companion.getInstance().wasClientJoinedViaPassword(clientData.getClientId());
    }

    public void askForConfirmationIfNeeded(@NotNull String id, @NotNull SecureClientData clientData, @NotNull ICodeWithMeWire wire, @NotNull CompletableFuture<ClientAcceptState> futureToComplete) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)clientData, (String)"clientData");
        Intrinsics.checkNotNullParameter((Object)wire, (String)"wire");
        Intrinsics.checkNotNullParameter(futureToComplete, (String)"futureToComplete");
        try {
            ClientAcceptState acceptResult = UnattendedModeManagerImpl.Companion.getInstance().shouldAutomaticallyAcceptController(clientData);
            futureToComplete.complete(acceptResult);
        }
        catch (Throwable e) {
            futureToComplete.completeExceptionally(e);
        }
    }

    protected void terminateObsoleteConnections(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        UnattendedHostConnectionManagerImplKt.access$getLogger$p().info("Terminate active controller connections if any");
        List controllerWires = this.getWireStorage().filterWires((arg_0, arg_1) -> UnattendedHostConnectionManagerImpl.terminateObsoleteConnections$lambda$0(clientId, arg_0, arg_1));
        if (controllerWires.isEmpty()) {
            UnattendedHostConnectionManagerImplKt.access$getLogger$p().info("Active controller connections not found. Skip termination.");
            return;
        }
        UnattendedHostConnectionManagerImplKt.access$getLogger$p().info("Active controller connection has been detected. Terminate existing connection.");
        if (controllerWires.size() > 1) {
            UnattendedHostConnectionManagerImplKt.access$getLogger$p().error("Controller have <" + controllerWires.size() + "> active wires at the same time. Invalid state. All wires will be terminated.");
        }
        Iterable $this$forEach$iv = controllerWires;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WireStorageEntry wireEntry = (WireStorageEntry)element$iv;
            boolean bl = false;
            this.terminateExistingConnection(wireEntry.getWireInfo().getWire());
        }
        UnattendedHostConnectionManagerImplKt.access$getLogger$p().info("All <" + controllerWires.size() + "> previous controller connections has been successfully terminated");
    }

    @Nullable
    protected SessionTokenHandler createSessionTokenHandler() {
        return null;
    }

    private final void terminateExistingConnection(ICodeWithMeWire wire) {
        Logger logger;
        TransportInfo activeTransportInfo = wire.getTransportInfo();
        Logger $this$debug_u24default$iv = UnattendedHostConnectionManagerImplKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Start terminating controller wire: (id: " + wire.getId() + ")", t$iv);
        }
        if (activeTransportInfo != null) {
            ForceTerminateWireFrame frameToSend = FrameFactory.INSTANCE.createForceTerminateWireFrame(ConnectionDeclineReason.OtherControllerLaunched);
            Logger $this$debug_u24default$iv2 = UnattendedHostConnectionManagerImplKt.access$getLogger$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("Send frame to client: <" + frameToSend.getName() + ">", t$iv2);
            }
            activeTransportInfo.getTransport().send((Frame)frameToSend);
        }
        $this$debug_u24default$iv = UnattendedHostConnectionManagerImplKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Terminating controller wire: (id: " + wire.getId() + ")", t$iv);
        }
        this.getWireStorage().terminateWire(wire.getClientId());
    }

    private static final boolean attachProject$lambda$2(UnattendedHostConnectionManagerImpl this$0, Project $project) {
        return this$0.getProjects().add((Object)$project);
    }

    private static final Unit attachProject$lambda$3(UnattendedHostConnectionManagerImpl this$0, Project $project) {
        this$0.getProjects().remove((Object)$project);
        return Unit.INSTANCE;
    }

    private static final boolean terminateObsoleteConnections$lambda$0(ClientId $clientId, ClientId wireClientId, WireStorageEntry wireStorageEntry) {
        Intrinsics.checkNotNullParameter((Object)wireClientId, (String)"wireClientId");
        Intrinsics.checkNotNullParameter((Object)wireStorageEntry, (String)"<unused var>");
        return !Intrinsics.areEqual((Object)$clientId, (Object)wireClientId);
    }
}

