/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.unattendedHost.statistics;

import com.intellij.idea.AppMode;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.protocol.wire.storage.WireStorageEntry;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.unattendedHost.connection.UnattendedModeManagerImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rdserver/unattendedHost/statistics/RemoteDevClientSessionListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "controllerConnectedTimestamp", "", "appSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "beforeAppSessionDestroyed", "intellij.platform.remoteController.backend"})
public final class RemoteDevClientSessionListener
implements RemoteClientSessionListener {
    private long controllerConnectedTimestamp;

    public RemoteDevClientSessionListener() {
        if (!AppMode.isRemoteDevHost()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
        this.controllerConnectedTimestamp = System.currentTimeMillis();
    }

    public void appSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.controllerConnectedTimestamp = System.currentTimeMillis();
        RdServerConnectionManager connectionManager = UnattendedModeManagerImpl.Companion.getInstance().getConnectionManager();
        WireStorageEntry wireDesc = connectionManager.getWireStorage().getWireOrNull(session.getClientId());
        WireStorageEntry wireStorageEntry = wireDesc;
        if (wireStorageEntry == null || (wireStorageEntry = wireStorageEntry.getWireInfo()) == null || (wireStorageEntry = wireStorageEntry.getWire()) == null || (wireStorageEntry = wireStorageEntry.getTransportInfo()) == null || (wireStorageEntry = wireStorageEntry.getTransportType()) == null) {
            wireStorageEntry = TransportType.Unknown;
        }
        WireStorageEntry wire = wireStorageEntry;
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onControllerConnected(session.getClientId(), (TransportType)wire);
    }

    public void beforeAppSessionDestroyed(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        long clientConnectionDurationInMillis = System.currentTimeMillis() - this.controllerConnectedTimestamp;
        int clientConnectionDurationInMinutes = (int)(clientConnectionDurationInMillis / (long)1000 / (long)60);
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onControllerDisconnected(session.getClientId(), clientConnectionDurationInMinutes);
    }
}

