/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap.attach;

import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.attach.PythonDapAttachConfigurationEditor;
import com.intellij.python.dap.attach.PythonDapAttachConfigurationOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015H\u0016J\b\u0010#\u001a\u00020\u0002H\u0014J\b\u0010$\u001a\u00020\tH\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020(2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR(\u0010 \u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/intellij/python/dap/attach/PythonDapAttachConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/python/dap/attach/PythonDapAttachConfigurationOptions;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "socketAddressRegex", "Lkotlin/text/Regex;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "value", "remoteAddress", "getRemoteAddress", "()Ljava/lang/String;", "setRemoteAddress", "(Ljava/lang/String;)V", "remoteRoot", "getRemoteRoot", "setRemoteRoot", "localRoot", "getLocalRoot", "setLocalRoot", "getOptions", "suggestedName", "checkConfiguration", "", "isValidRemoteAddress", "", "intellij.python.dap"})
public final class PythonDapAttachConfiguration
extends LocatableConfigurationBase<PythonDapAttachConfigurationOptions>
implements RunConfigurationWithSuppressedDefaultRunAction {
    @NotNull
    private final Regex socketAddressRegex;

    public PythonDapAttachConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.socketAddressRegex = new Regex("^[^:]+:[0-9]{1,5}$");
        CharSequence charSequence = this.getOptions().getLocalRoot();
        if (charSequence == null || charSequence.length() == 0) {
            this.getOptions().setLocalRoot(project.getBasePath());
        }
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfileState runProfileState = EmptyRunProfileState.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)runProfileState, (String)"INSTANCE");
        return runProfileState;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new PythonDapAttachConfigurationEditor(this);
    }

    @Nullable
    public final String getRemoteAddress() {
        return this.getOptions().getRemoteAddress();
    }

    public final void setRemoteAddress(@Nullable String value) {
        this.getOptions().setRemoteAddress(value);
    }

    @Nullable
    public final String getRemoteRoot() {
        return this.getOptions().getRemoteRoot();
    }

    public final void setRemoteRoot(@Nullable String value) {
        this.getOptions().setRemoteRoot(value);
    }

    @Nullable
    public final String getLocalRoot() {
        return this.getOptions().getLocalRoot();
    }

    public final void setLocalRoot(@Nullable String value) {
        this.getOptions().setLocalRoot(value);
    }

    @NotNull
    protected PythonDapAttachConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.python.dap.attach.PythonDapAttachConfigurationOptions");
        return (PythonDapAttachConfigurationOptions)locatableRunConfigurationOptions;
    }

    @NotNull
    public String suggestedName() {
        String string;
        if (this.getOptions().getRemoteAddress() == null) {
            String string2 = PythonDapBundle.message("pythonDap.attach.configuration.suggestedName.default", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            Object[] objectArray = new Object[]{this.getOptions().getRemoteAddress()};
            String string3 = PythonDapBundle.message("pythonDap.attach.configuration.suggestedName.toAddress", objectArray);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    public void checkConfiguration() {
        if (!this.isValidRemoteAddress(this.getRemoteAddress())) {
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.attach.configuration.error.incorrect.address", new Object[0]));
        }
        CharSequence charSequence = this.getLocalRoot();
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.attach.configuration.error.incorrect.localDir", new Object[0]));
        }
        charSequence = this.getRemoteRoot();
        if (charSequence == null || charSequence.length() == 0) {
            throw new RuntimeConfigurationError(PythonDapBundle.message("pythonDap.attach.configuration.error.incorrect.remoteDir", new Object[0]));
        }
    }

    private final boolean isValidRemoteAddress(String remoteAddress) {
        CharSequence charSequence = remoteAddress;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return this.socketAddressRegex.matches((CharSequence)remoteAddress);
    }
}

