/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommentBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlIdentifierBlock;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlLiteralBlock;
import com.intellij.sql.formatter.model.SqlRealRootBlock;
import com.intellij.sql.formatter.model.SqlRootBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f*\u00020\bH\u0002\u00a8\u0006\r"}, d2={"getLineIndentInsideLeaf", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "caretOffset", "", "findEnclosingBlocks", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "offset", "adjustEnclosingBlocks", "collectTails", "", "intellij.database.sql.core.impl"})
public final class SqlLineIndentProviderKt {
    private static final String getLineIndentInsideLeaf(AdjacentBlocks blocks, int caretOffset) {
        SqlBlock b = blocks.getBlock1();
        return b instanceof SqlLiteralBlock ? "" : (b instanceof SqlIdentifierBlock ? (((SqlIdentifierBlock)b).getQuoted() ? "" : LineIndentProvider.DO_NOT_ADJUST) : (b instanceof SqlCommentBlock ? ((SqlCommentBlock)b).getNewLineIndent(blocks) : LineIndentProvider.DO_NOT_ADJUST));
    }

    private static final AdjacentBlocks findEnclosingBlocks(SqlBlock block, int offset) {
        if (block instanceof SqlRealRootBlock) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(((SqlRealRootBlock)block).getNestedBlock$intellij_database_sql_core_impl(), offset);
        }
        TextRange r = block.getRange();
        if (offset <= r.getStartOffset()) {
            return new AdjacentBlocks(null, block);
        }
        if (offset >= r.getEndOffset()) {
            return new AdjacentBlocks(block, null);
        }
        if (block instanceof SqlLeafBlock) {
            return new AdjacentBlocks(block, block);
        }
        block.grow();
        List<SqlBlock> children = block.getNestedBlocks();
        int n = children.size();
        if (n == 0) {
            return new AdjacentBlocks(block, block);
        }
        SqlBlock b0 = children.get(0);
        TextRange r0 = b0.getRange();
        if (offset <= r0.getStartOffset()) {
            return new AdjacentBlocks(null, b0);
        }
        if (offset < r0.getEndOffset()) {
            return SqlLineIndentProviderKt.findEnclosingBlocks(b0, offset);
        }
        for (int i = 1; i < n; ++i) {
            SqlBlock b2 = children.get(i);
            TextRange r2 = b2.getRange();
            if (offset <= r2.getStartOffset()) {
                return new AdjacentBlocks(children.get(i - 1), b2);
            }
            if (offset >= r2.getEndOffset()) continue;
            return SqlLineIndentProviderKt.findEnclosingBlocks(b2, offset);
        }
        if (offset < block.getRange().getEndOffset()) {
            return new AdjacentBlocks((SqlBlock)CollectionsKt.last(children), null);
        }
        return new AdjacentBlocks(block, block);
    }

    private static final AdjacentBlocks adjustEnclosingBlocks(AdjacentBlocks blocks) {
        SqlBlock sqlBlock = blocks.getBlock1();
        if (sqlBlock == null) {
            return blocks;
        }
        SqlBlock b1 = sqlBlock;
        if (b1 instanceof SqlLeafBlock) {
            return blocks;
        }
        List<SqlBlock> tails = SqlLineIndentProviderKt.collectTails(b1);
        int n = tails.size();
        for (int i = n - 1; 0 < i; --i) {
            SqlBlock b = tails.get(i);
            SqlBlock parent = tails.get(i - 1);
            boolean parentTailFormed = parent.tailFormed();
            if (parentTailFormed) continue;
            return new AdjacentBlocks(b, null);
        }
        return blocks;
    }

    private static final List<SqlBlock> collectTails(SqlBlock $this$collectTails) {
        if ($this$collectTails instanceof SqlLeafBlock) {
            List<SqlBlock> list = Collections.singletonList($this$collectTails);
            Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
            return list;
        }
        ArrayList<SqlBlock> tails = new ArrayList<SqlBlock>();
        SqlBlock b = $this$collectTails;
        while (b != null) {
            b.grow();
            tails.add(b);
            SqlBlock sqlBlock = b;
            b = sqlBlock instanceof SqlFlowBlock ? ((SqlFlowBlock)b).getLastNestedSqlBlock() : (sqlBlock instanceof SqlRootBlock ? ((SqlRootBlock)b).getNestedBlock$intellij_database_sql_core_impl() : null);
        }
        return tails;
    }

    public static final /* synthetic */ AdjacentBlocks access$findEnclosingBlocks(SqlBlock block, int offset) {
        return SqlLineIndentProviderKt.findEnclosingBlocks(block, offset);
    }

    public static final /* synthetic */ AdjacentBlocks access$adjustEnclosingBlocks(AdjacentBlocks blocks) {
        return SqlLineIndentProviderKt.adjustEnclosingBlocks(blocks);
    }

    public static final /* synthetic */ String access$getLineIndentInsideLeaf(AdjacentBlocks blocks, int caretOffset) {
        return SqlLineIndentProviderKt.getLineIndentInsideLeaf(blocks, caretOffset);
    }
}

