/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.CodeSectionHostBlock;
import com.intellij.sql.formatter.model.EndIncElementContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlock;
import com.intellij.sql.formatter.model.SqlCodeFlowBlockKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlStatementBlock;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u0015H\u0014J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010'\u001a\u0004\u0018\u00010(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "Lcom/intellij/sql/formatter/model/CodeSectionHostBlock;", "<init>", "()V", "countOfElements", "", "getCountOfElements", "()I", "setCountOfElements", "(I)V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole", "", "role", "countRole$intellij_database_sql_core_impl", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "userRequiresExpand", "", "preserveUserLineBreaks", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "hostWrap", "Lcom/intellij/formatting/Wrap;", "getHostWrap", "()Lcom/intellij/formatting/Wrap;", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCodeFlowBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCodeFlowBlock.kt\ncom/intellij/sql/formatter/model/SqlCodeFlowBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n831#2,2:168\n249#3:170\n1915#4,2:171\n*S KotlinDebug\n*F\n+ 1 SqlCodeFlowBlock.kt\ncom/intellij/sql/formatter/model/SqlCodeFlowBlock\n*L\n31#1:168,2\n38#1:170\n67#1:171,2\n*E\n"})
public class SqlCodeFlowBlock
extends SqlRangeBlock
implements CodeSectionHostBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int countOfElements;
    @Nullable
    private final Wrap hostWrap;
    @NotNull
    private static final List<FlowPattern> patterns;

    protected final int getCountOfElements() {
        return this.countOfElements;
    }

    protected final void setCountOfElements(int n) {
        this.countOfElements = n;
    }

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof SqlDeclareStatement) {
            void parent$iv;
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = new SqlStatementBlock();
            SqlBlock sqlBlock2 = this;
            ASTNode mainNode$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, mainNode$iv);
            sqlBlock = sqlNodeBlock;
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        BlockRole blockRole;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof SqlStatement) {
            blockRole = BlockRole.ELEMENT;
        } else {
            void what$iv;
            void $this$change$iv;
            BlockRole blockRole2 = super.determineRole(node);
            BlockRole blockRole3 = BlockRole.NOTHING;
            BlockRole with$iv = BlockRole.ELEMENT;
            boolean $i$f$change = false;
            blockRole = Intrinsics.areEqual((Object)$this$change$iv, (Object)what$iv) ? with$iv : blockRole2;
        }
        return blockRole;
    }

    @Override
    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    protected boolean userRequiresExpand() {
        return this.countOfElements >= 2 && this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT;
    }

    @Override
    protected boolean preserveUserLineBreaks() {
        int n = this.getNestedNodes().size();
        if (this.countOfElements < 2) {
            return false;
        }
        if (this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT) {
            return true;
        }
        for (int i = 1; i < n; ++i) {
            ASTNode node1 = this.getNestedNodes().get(i - 1);
            ASTNode node2 = this.getNestedNodes().get(i);
            if (!(node2 instanceof SqlStatement) || !this.getContext().textContainsBreaksBetween(node1, node2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void configureFormattingAttributes() {
        WrapType wt = this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT ? WrapType.CHOP_DOWN_IF_LONG : WrapType.NORMAL;
        Wrap w = SqlFlowBlock.makeWrap$default(this, wt, false, 2, null);
        JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT).skip(1);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"skip(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlBlock it = (SqlBlock)element$iv;
            boolean bl = false;
            it.setMyWrap(w);
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (this.getShape() == BlockShape.DECIDED_TO_ONE_ROW) {
            return super.decideSpacing(block1, block2);
        }
        if (block2.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        if (block1.getRole() == BlockRole.ELEMENT && block2.getRole() == BlockRole.DELIMITER) {
            return this.getContext().makeNoSpace(false);
        }
        if (block2.getRole() == BlockRole.DELIMITER) {
            return SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null);
        }
        if (block2.getRole() == BlockRole.ELEMENT && this.getContext().getSql().IMP_COMMON_WRAP_EVERY_STATEMENT) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        SqlBlock stmtBlock1 = null;
        if (block1.getRole() == BlockRole.ELEMENT) {
            stmtBlock1 = block1;
        } else {
            for (SqlBlock b : this.getNestedBlocks()) {
                if (b.getRole() == BlockRole.ELEMENT) {
                    stmtBlock1 = b;
                }
                if (!Intrinsics.areEqual((Object)b, (Object)block1)) continue;
            }
        }
        SqlBlock sqlBlock = stmtBlock1;
        if ((sqlBlock != null ? sqlBlock.getShape() : null) == BlockShape.DECIDED_TO_MULTI_ROWS) {
            return SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null);
        }
        return this.getContext().makeAutoSpacing(true);
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        boolean possiblyContinuation = blocks.getBeyond() && blocks.getRole1() != BlockRole.DELIMITER || blocks.getRole2() == BlockRole.DELIMITER;
        boolean toIndent = possiblyContinuation && blocks.getBlock1() != null && !blocks.getBlock1().tailFormed();
        return SqlFormattingContext.currIndentOf$default(this.getContext(), this, false, toIndent, false, 10, null);
    }

    @Override
    @Nullable
    public Wrap getHostWrap() {
        return this.hostWrap;
    }

    static {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_START_TRANSACTION_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_START_TRANSACTION_STATEMENT");
        patterns = CollectionsKt.listOf((Object)FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), new EndIncElementContinuePattern(SqlCodeFlowBlockKt.access$getTRANSACTION_SUFFIXES$p(), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE))));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCodeFlowBlock$Companion;", "", "<init>", "()V", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

