/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementCreator
implements WriteActionAware {
    private static final Logger LOG = Logger.getInstance(ElementCreator.class);
    private final Project myProject;
    @NlsContexts.DialogTitle
    private final String myErrorTitle;

    protected ElementCreator(Project project, @NlsContexts.DialogTitle @NotNull String errorTitle) {
        if (errorTitle == null) {
            ElementCreator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myErrorTitle = errorTitle;
    }

    protected abstract PsiElement @NotNull [] create(@NotNull String var1) throws Exception;

    @NlsContexts.Command
    @NotNull
    protected abstract String getActionName(@NotNull String var1);

    @NotNull
    public @NotNull PsiElement @NotNull [] tryCreate(@NotNull String inputString) {
        if (inputString == null) {
            ElementCreator.$$$reportNull$$$0(1);
        }
        if (inputString.isEmpty()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                ElementCreator.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Ref createdElements = Ref.create();
        Exception exception = this.executeCommand(this.getActionName(inputString), (ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> {
            Object[] psiElements = this.create(inputString);
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
            createdElements.set((Object)ContainerUtil.map((Object[])psiElements, arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0)));
        }));
        if (exception != null) {
            this.handleException(exception);
            if (PsiElement.EMPTY_ARRAY == null) {
                ElementCreator.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = ContainerUtil.mapNotNull((Collection)((Collection)createdElements.get()), SmartPsiElementPointer::getElement).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ElementCreator.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @Nullable
    private Exception executeCommand(@NlsContexts.Command @NotNull String commandName, @NotNull ThrowableRunnable<? extends Exception> invokeCreate) {
        if (commandName == null) {
            ElementCreator.$$$reportNull$$$0(5);
        }
        if (invokeCreate == null) {
            ElementCreator.$$$reportNull$$$0(6);
        }
        Exception[] exception = new Exception[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(commandName);
            try {
                if (this.startInWriteAction()) {
                    WriteAction.run((ThrowableRunnable)invokeCreate);
                } else {
                    invokeCreate.run();
                }
            }
            catch (Exception ex) {
                exception[0] = ex;
            }
            finally {
                action.finish();
            }
        }, commandName, null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return exception[0];
    }

    private void handleException(Exception t) {
        LOG.info((Throwable)t);
        String errorMessage = ElementCreator.getErrorMessage(t);
        Messages.showMessageDialog((Project)this.myProject, (String)errorMessage, (String)this.myErrorTitle, (Icon)Messages.getErrorIcon());
    }

    @NlsContexts.DialogMessage
    public static String getErrorMessage(Throwable t) {
        String errorMessage = CreateElementActionBase.filterMessage(t.getMessage());
        if (StringUtil.isEmpty((String)errorMessage)) {
            errorMessage = t.toString();
        }
        return errorMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ElementCreator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ElementCreator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tryCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

