/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EDT;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManagerImpl.class);
    private final SynchronizedClearableLazy<Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory>> myFactories = new SynchronizedClearableLazy(() -> {
        long start = System.nanoTime();
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map = IdeScriptEngineManagerImpl.calcFactories();
        LOG.info(TimeoutUtil.getDurationMillis((long)start) + " ms to enumerate javax.scripting engines on " + (EDT.isCurrentThreadEdt() ? "EDT" : "BGT"));
        return map;
    });

    IdeScriptEngineManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeScriptEngineManagerImpl.this.dropFactories();
            }

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                IdeScriptEngineManagerImpl.this.dropFactories();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/script/IdeScriptEngineManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public List<IdeScriptEngineManager.EngineInfo> getEngineInfos() {
        return new ArrayList<IdeScriptEngineManager.EngineInfo>(this.getFactories().keySet());
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngine(@NotNull IdeScriptEngineManager.EngineInfo engineInfo, @Nullable ClassLoader loader) {
        ScriptEngineFactory engineFactory;
        if (engineInfo == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(0);
        }
        if ((engineFactory = this.getFactories().get(engineInfo)) == null) {
            return null;
        }
        return IdeScriptEngineManagerImpl.createIdeScriptEngine(engineFactory, loader);
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByName(@NotNull String engineName, @Nullable ClassLoader loader) {
        if (engineName == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(1);
        }
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.engineName.equals(engineName)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByFileExtension(@NotNull String extension, @Nullable ClassLoader loader) {
        if (extension == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(2);
        }
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.fileExtensions.contains(extension)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @NotNull
    private Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> getFactories() {
        Map map;
        try {
            map = (Map)this.myFactories.getValue();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map2 = Collections.emptyMap();
            if (map2 == null) {
                IdeScriptEngineManagerImpl.$$$reportNull$$$0(4);
            }
            return map2;
        }
        if (map == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    private void dropFactories() {
        this.myFactories.drop();
    }

    @NotNull
    private static Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> calcFactories() {
        Map map = JBIterable.of((Object[])PluginManagerCore.getPlugins()).flatten(o -> {
            try {
                return new ScriptEngineManager(o.getClassLoader()).getEngineFactories();
            }
            catch (Throwable e) {
                LOG.error((Throwable)new PluginException(e, o.getPluginId()));
                return null;
            }
        }).unique(o -> o.getClass().getName()).filterMap(factory -> {
            try {
                Class<?> aClass = factory.getClass();
                ClassLoader classLoader = aClass.getClassLoader();
                PluginDescriptor plugin = classLoader instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)classLoader).getPluginDescriptor() : null;
                IdeScriptEngineManager.EngineInfo info = new IdeScriptEngineManager.EngineInfo(factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion(), factory.getExtensions(), aClass.getName(), plugin);
                return Pair.create((Object)info, (Object)factory);
            }
            catch (Throwable e) {
                LOG.error((Throwable)PluginException.createByClass((Throwable)e, factory.getClass()));
                return null;
            }
        }).toMap(o -> (IdeScriptEngineManager.EngineInfo)o.first, o -> (ScriptEngineFactory)o.second);
        if (map == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngineFactory scriptEngineFactory, @Nullable ClassLoader loader) {
        if (scriptEngineFactory == null) {
            return null;
        }
        EngineImpl engine = new EngineImpl(scriptEngineFactory, loader == null ? AllPluginsLoader.INSTANCE : loader);
        IdeScriptEngineManagerImpl.redirectOutputToLog(engine);
        IdeUiService.getInstance().logIdeScriptUsageEvent(scriptEngineFactory.getClass());
        return engine;
    }

    private static void redirectOutputToLog(@NotNull IdeScriptEngine engine) {
        if (engine == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(6);
        }
        final class Log
        extends Writer {
            private final boolean error;

            private Log(boolean error) {
                this.error = error;
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
                while (len > 0 && Character.isWhitespace(cbuf[off + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return;
                }
                String s = new String(cbuf, off, len);
                if (this.error) {
                    LOG.warn(s);
                } else {
                    LOG.info(s);
                }
            }
        }
        engine.setStdOut(new Log(false));
        engine.setStdErr(new Log(true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeScriptEngineManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeScriptEngineManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEngine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEngineByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEngineByFileExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "redirectOutputToLog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    static final class EngineImpl
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        EngineImpl(@NotNull ScriptEngineFactory factory, @Nullable ClassLoader loader) {
            if (factory == null) {
                EngineImpl.$$$reportNull$$$0(0);
            }
            this.myLoader = loader;
            this.myEngine = (ScriptEngine)ClassLoaderUtil.computeWithClassLoader((ClassLoader)this.myLoader, () -> factory.getScriptEngine());
        }

        @Override
        public Object getBinding(@NotNull String name) {
            if (name == null) {
                EngineImpl.$$$reportNull$$$0(1);
            }
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value) {
            if (name == null) {
                EngineImpl.$$$reportNull$$$0(2);
            }
            this.myEngine.put(name, value);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            Writer writer = this.myEngine.getContext().getWriter();
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(3);
            }
            return writer;
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(4);
            }
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            Writer writer = this.myEngine.getContext().getErrorWriter();
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(5);
            }
            return writer;
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(6);
            }
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            Reader reader = this.myEngine.getContext().getReader();
            if (reader == null) {
                EngineImpl.$$$reportNull$$$0(7);
            }
            return reader;
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            if (reader == null) {
                EngineImpl.$$$reportNull$$$0(8);
            }
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            String string = this.myEngine.getFactory().getLanguageName();
            if (string == null) {
                EngineImpl.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            List<String> list = this.myEngine.getFactory().getExtensions();
            if (list == null) {
                EngineImpl.$$$reportNull$$$0(10);
            }
            return list;
        }

        @Override
        public Object eval(@NotNull String script) throws IdeScriptException {
            if (script == null) {
                EngineImpl.$$$reportNull$$$0(11);
            }
            return ClassLoaderUtil.computeWithClassLoader((ClassLoader)this.myLoader, () -> {
                try {
                    return this.myEngine.eval(script);
                }
                catch (Throwable ex) {
                    throw new IdeScriptException(ExceptionUtilRt.unwrapException((Throwable)ex, ScriptException.class));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5, 7, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/script/IdeScriptEngineManagerImpl$EngineImpl";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/script/IdeScriptEngineManagerImpl$EngineImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdOut";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdErr";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdIn";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinding";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setBinding";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdOut";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdErr";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdIn";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "eval";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5, 7, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    static final class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final ConcurrentMap<Long, ClassLoader> myLuckyGuess = new ConcurrentHashMap<Long, ClassLoader>();

        AllPluginsLoader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            boolean hasBase = p0 > 0;
            int p1 = hasBase ? name.indexOf("$", p0 + 1) : -1;
            String base = hasBase ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.buz((CharSequence)base);
            Class<?> c = null;
            ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash);
            ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
            for (ClassLoader loader : JBIterable.of((Object[])new ClassLoader[]{guess1, guess2})) {
                if (loader == this) {
                    throw new ClassNotFoundException(name);
                }
                if (loader == null) continue;
                try {
                    c = loader.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c == null) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor.getPluginClassLoader();
                    if (l == null || !hasBase && (l == guess1 || l == guess2)) continue;
                    try {
                        if (hasBase) {
                            l.loadClass(base);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                        }
                        try {
                            c = l.loadClass(name);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                            this.myLuckyGuess.put(0L, l);
                        }
                        catch (ClassNotFoundException e) {
                            if (hasBase || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.putIfAbsent(hash, this);
            throw new ClassNotFoundException(name);
        }

        private static boolean isAllowedPluginResource(String name) {
            return "META-INF/services/javax.script.ScriptEngineFactory".equals(name);
        }

        @Override
        protected URL findResource(String name) {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    URL url;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    URL uRL = url = l == null ? null : l.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                LinkedHashMap<String, URL> result = null;
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    Enumeration<URL> urls;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    Enumeration<URL> enumeration = urls = l == null ? null : l.getResources(name);
                    if (urls == null || !urls.hasMoreElements()) continue;
                    if (result == null) {
                        result = new LinkedHashMap<String, URL>();
                    }
                    while (urls.hasMoreElements()) {
                        URL url = urls.nextElement();
                        result.put(url.toString(), url);
                    }
                }
                if (result != null) {
                    return Collections.enumeration(result.values());
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        public @Unmodifiable @NotNull List<URL> getUrls() {
            List list = JBIterable.of((Object[])PluginManagerCore.getPlugins()).map(PluginDescriptor::getClassLoader).unique().flatMap(o -> {
                try {
                    return (List)o.getClass().getMethod("getUrls", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }).unique().toList();
            if (list == null) {
                AllPluginsLoader.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeScriptEngineManagerImpl$AllPluginsLoader", "getUrls"));
        }
    }
}

