/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchRequest {
    @NotNull
    public final SearchScope searchScope;
    @NotNull
    public final String word;
    public final short searchContext;
    public final boolean caseSensitive;
    public final RequestResultProcessor processor;
    public final String containerName;
    private final SearchSession mySession;

    PsiSearchRequest(@NotNull SearchScope searchScope, @NotNull String word, short searchContext, boolean caseSensitive, @Nullable String containerName, @NotNull SearchSession session, @NotNull RequestResultProcessor processor) {
        if (searchScope == null) {
            PsiSearchRequest.$$$reportNull$$$0(0);
        }
        if (word == null) {
            PsiSearchRequest.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PsiSearchRequest.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PsiSearchRequest.$$$reportNull$$$0(3);
        }
        this.containerName = containerName;
        this.mySession = session;
        if (word.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        this.searchScope = searchScope;
        this.word = word;
        this.searchContext = searchContext;
        this.caseSensitive = caseSensitive;
        this.processor = processor;
        if (searchScope instanceof GlobalSearchScope && ((GlobalSearchScope)searchScope).getProject() == null) {
            throw new AssertionError((Object)("Every search scope must be associated with a project: " + String.valueOf(searchScope)));
        }
    }

    public String toString() {
        return this.word + " -> " + String.valueOf(this.processor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSearchRequest)) {
            return false;
        }
        PsiSearchRequest that = (PsiSearchRequest)o;
        if (this.caseSensitive != that.caseSensitive) {
            return false;
        }
        if (this.searchContext != that.searchContext) {
            return false;
        }
        if (!this.processor.equals(that.processor)) {
            return false;
        }
        if (!this.searchScope.equals(that.searchScope)) {
            return false;
        }
        return this.word.equals(that.word);
    }

    public int hashCode() {
        int result = this.searchScope.hashCode();
        result = 31 * result + this.word.hashCode();
        result = 31 * result + this.searchContext;
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        result = 31 * result + this.processor.hashCode();
        return result;
    }

    @NotNull
    public SearchSession getSearchSession() {
        SearchSession searchSession = this.mySession;
        if (searchSession == null) {
            PsiSearchRequest.$$$reportNull$$$0(4);
        }
        return searchSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiSearchRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiSearchRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

