/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H$J4\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0004J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0004J\u001c\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\bH\u0014J\b\u0010 \u001a\u00020\u0010H\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "Lorg/jetbrains/builtInWebServer/NetService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "processChannel", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/netty/channel/Channel;", "getProcessChannel", "()Ljava/util/concurrent/atomic/AtomicReference;", "port", "", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "configureBootstrap", "", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/execution/process/OSProcessHandler;", "processHandler", "connectAgain", "Lorg/jetbrains/concurrency/Promise;", "handleErrors", "connectResult", "Lcom/intellij/util/io/ConnectToChannelResult;", "addCloseListener", "it", "closeProcessConnections", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nSingleConnectionNetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleConnectionNetService.kt\norg/jetbrains/builtInWebServer/SingleConnectionNetService\n+ 2 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromiseKt\n+ 3 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,88:1\n231#2,6:89\n231#2,6:95\n66#3,2:101\n*S KotlinDebug\n*F\n+ 1 SingleConnectionNetService.kt\norg/jetbrains/builtInWebServer/SingleConnectionNetService\n*L\n40#1:89,6\n58#1:95,6\n80#1:101,2\n*E\n"})
public abstract class SingleConnectionNetService
extends NetService {
    @NotNull
    private final AtomicReference<Channel> processChannel;
    private volatile int port;
    @Nullable
    private volatile Bootstrap bootstrap;

    public SingleConnectionNetService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, null, 2, null);
        this.processChannel = new AtomicReference();
        this.port = -1;
    }

    @NotNull
    protected final AtomicReference<Channel> getProcessChannel() {
        return this.processChannel;
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    @Override
    protected final void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkNotNullParameter(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap bootstrap = BuiltInServerManager.Companion.getInstance().createClientBootstrap();
        this.configureBootstrap(bootstrap, errorOutputConsumer);
        this.bootstrap = bootstrap;
        this.port = port;
        ConnectToChannelResult connectResult = NettyKt.connectRetrying$default((Bootstrap)bootstrap, (InetSocketAddress)NetKt.loopbackSocketAddress((int)port), (int)0, null, (int)6, null);
        Channel channel = connectResult.getChannel();
        if (channel != null) {
            Channel it = channel;
            boolean bl = false;
            AsyncPromise<OSProcessHandler> $this$catchError$iv = promise;
            boolean $i$f$catchError = false;
            try {
                boolean bl2 = false;
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise.setResult((Object)processHandler2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                $this$catchError$iv.setError(e$iv);
                Object var12_13 = null;
            }
        }
        this.handleErrors(connectResult, promise);
    }

    @NotNull
    protected final Promise<Channel> connectAgain() {
        Channel channel = this.processChannel.get();
        if (channel != null) {
            return Promises.resolvedPromise((Object)channel);
        }
        AsyncPromise promise = new AsyncPromise();
        Bootstrap bootstrap = this.bootstrap;
        Intrinsics.checkNotNull((Object)bootstrap);
        ConnectToChannelResult connectResult = NettyKt.connectRetrying$default((Bootstrap)bootstrap, (InetSocketAddress)NetKt.loopbackSocketAddress((int)this.port), (int)0, null, (int)6, null);
        Channel channel2 = connectResult.getChannel();
        if (channel2 != null) {
            Channel it = channel2;
            boolean bl = false;
            AsyncPromise $this$catchError$iv = promise;
            boolean $i$f$catchError = false;
            try {
                boolean bl2 = false;
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise.setResult((Object)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                $this$catchError$iv.setError(e$iv);
                Object var9_10 = null;
            }
        }
        this.handleErrors(connectResult, promise);
        return (Promise)promise;
    }

    private final void handleErrors(ConnectToChannelResult connectResult, AsyncPromise<?> promise) {
        connectResult.handleError(arg_0 -> SingleConnectionNetService.handleErrors$lambda$0(promise, arg_0)).handleThrowable(arg_0 -> SingleConnectionNetService.handleErrors$lambda$1(promise, arg_0));
    }

    protected void addCloseListener(@NotNull Channel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChannelFuture channelFuture = it.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"closeFuture(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(this){
            final /* synthetic */ SingleConnectionNetService this$0;
            {
                this.this$0 = singleConnectionNetService;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                this.this$0.getProcessChannel().compareAndSet(it2.channel(), null);
            }
        });
    }

    @Override
    protected void closeProcessConnections() {
        block0: {
            Channel channel = this.processChannel.getAndSet(null);
            if (channel == null) break block0;
            NettyKt.closeAndShutdownEventLoop((Channel)channel);
        }
    }

    private static final void handleErrors$lambda$0(AsyncPromise $promise, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $promise.setError(it);
    }

    private static final void handleErrors$lambda$1(AsyncPromise $promise, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $promise.setError(it);
    }
}

