/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlShouldBeInGroupByInspection
extends SqlInspectionBase {
    private static boolean shouldReport(@NotNull Dbms dbms) {
        if (dbms == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(0);
        }
        return dbms.isClickHouse() || dbms.isDb2() || dbms.isDerby() || dbms.isExasol() || dbms.isH2() || dbms.isHsqldb() || dbms.isMicrosoft() || dbms.isOracle() || dbms.isPostgres() || dbms.isSnowflake() || dbms.isVertica();
    }

    @Nullable
    private static PsiElement resolveUnwrappingAliases(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(1);
        }
        SqlReferenceExpression e = ref;
        while (true) {
            SqlReferenceExpression next;
            if ((next = e) instanceof SqlReferenceExpression) {
                next = next.resolve();
            } else if (next instanceof SqlAsExpression) {
                next = ((SqlAsExpression)next).getExpression();
            } else {
                return next;
            }
            if (e == next) {
                return e;
            }
            e = next;
        }
    }

    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(4);
        }
        if (!SqlShouldBeInGroupByInspection.shouldReport(dbms = dialect.getDbms())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(this, manager, (SqlLanguageDialect)dialect, result){

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                super.visitSqlQueryExpression(o);
                SqlTableExpression tableExpression = o.getTableExpression();
                if (tableExpression == null || tableExpression.getWindowClause() != null) {
                    return;
                }
                SqlGroupByClause groupBy = tableExpression.getGroupByClause();
                if (groupBy != null) {
                    if (dbms.isH2()) {
                        return;
                    }
                    if (dbms.isClickHouse() && SqlImplUtil.sqlChildren((PsiElement)groupBy).filter(e -> e.getNode().getElementType() == SqlCommonKeywords.SQL_ALL).isNotEmpty()) {
                        return;
                    }
                    if (dbms.isHsqldb() || dbms.isGreenplum() || dbms == Dbms.POSTGRES) {
                        for (SqlReferenceExpression groupingRef : SqlImplUtil.sqlChildren((PsiElement)groupBy).filter(SqlReferenceExpression.class)) {
                            PsiElement target = SqlShouldBeInGroupByInspection.resolveUnwrappingAliases(groupingRef);
                            if (!(target instanceof DasColumn) || !DasUtil.isPrimary((DasColumn)((DasColumn)target))) continue;
                            return;
                        }
                    }
                    if (dbms.isSnowflake() || dbms.isRedshift()) {
                        boolean groupByAll;
                        boolean bl = groupByAll = groupBy.getNode().getLastChildNode().getElementType() == SqlCommonKeywords.SQL_ALL;
                        if (groupByAll) {
                            return;
                        }
                    }
                }
                for (SqlReferenceExpression ref : SqlImplUtil.getNonAggregateColumnRefs((SqlQueryExpression)o)) {
                    JBIterable names = SqlImplUtil.getResolvesNotInGroupBy((SqlReferenceExpression)ref, (SqlQueryExpression)o).transform(element -> SqlImplUtil.getResolvedColumnName((DatabaseDialectEx)this.myDialect.getDatabaseDialect(), (SqlReferenceExpression)ref, (PsiElement)element));
                    int size = names.size();
                    if (size == 0) continue;
                    String strNames = StringUtil.join((Iterable)names, (String)", ");
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)ref, SqlBundle.message((String)(size == 1 ? "column.should.be.in.group.by" : "columns.should.be.in.group.by"), (Object[])new Object[]{strNames}), (LocalQuickFix)new AddToGroupByQuickFix(), ProblemHighlightType.GENERIC_ERROR, onTheFly));
                }
            }
        };
    }

    @NotNull
    private static Iterable<CharSequence> nameElements(@NotNull SqlTableExpression tableExpression, @NotNull SqlReferenceExpression ref, @NotNull JBIterable<PsiElement> elements) {
        if (tableExpression == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(5);
        }
        if (ref == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(7);
        }
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref).getDatabaseDialect();
        SqlTableType partType = (SqlTableType)ObjectUtils.tryCast((Object)ref.getDasType(), SqlTableType.class);
        if (partType != null) {
            List columnNames = DbSqlUtil.getUnambiguousColumnNames((Project)ref.getProject(), (DatabaseDialectEx)dialect, (SqlTableType)partType, (SqlTableType)tableExpression.getDasType(), null);
            ArrayList<CharSequence> filtered = new ArrayList<CharSequence>(elements.size());
            Iterator it = elements.iterator();
            PsiElement cur = (PsiElement)it.next();
            for (int i = 0; i < columnNames.size(); ++i) {
                if (partType.getColumnElement(i) != cur) continue;
                filtered.add((CharSequence)columnNames.get(i));
                if (!it.hasNext()) break;
                cur = (PsiElement)it.next();
            }
            ArrayList<CharSequence> arrayList = filtered;
            if (arrayList == null) {
                SqlShouldBeInGroupByInspection.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        JBIterable jBIterable = elements.transform(element -> SqlImplUtil.getResolvedColumnName((DatabaseDialectEx)dialect, (SqlReferenceExpression)ref, (PsiElement)element));
        if (jBIterable == null) {
            SqlShouldBeInGroupByInspection.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "nameElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldReport";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveUnwrappingAliases";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "nameElements";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class AddToGroupByQuickFix
    implements LocalQuickFix,
    DumbAware {
        private AddToGroupByQuickFix() {
        }

        @NotNull
        public String getName() {
            String string = SqlBundle.message((String)"quickfix.name.add.to.group.by", (Object[])new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"sql.inspections.group.name", (Object[])new Object[0]);
            if (string == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlTableExpression tableExpression;
            SqlReferenceExpression ref;
            if (project == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddToGroupByQuickFix.$$$reportNull$$$0(3);
            }
            if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), SqlReferenceExpression.class)) == null) {
                return;
            }
            SqlQueryExpression o = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)ref, SqlQueryExpression.class);
            SqlTableExpression sqlTableExpression = tableExpression = o != null ? o.getTableExpression() : null;
            if (tableExpression == null) {
                return;
            }
            SqlGroupByClause groupByClause = tableExpression.getGroupByClause();
            JBIterable elements = SqlImplUtil.getResolvesNotInGroupBy((SqlReferenceExpression)ref, (SqlQueryExpression)o);
            if (elements.isEmpty()) {
                return;
            }
            Iterable<CharSequence> names = SqlShouldBeInGroupByInspection.nameElements(tableExpression, ref, (JBIterable<PsiElement>)elements);
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)o);
            if (groupByClause == null) {
                SqlGroupByClause groupBy = SqlPsiElementFactory.createGroupByClause((String)StringUtil.join(names, (String)", "), (SqlLanguageDialect)dialect, (Project)project);
                if (groupBy != null) {
                    IntentionUtilsKt.addGroupBy((SqlQueryExpression)o, (SqlGroupByClause)groupBy);
                }
                return;
            }
            PsiFile file = ref.getContainingFile();
            Document document = file.getViewProvider().getDocument();
            if (document == null) {
                return;
            }
            int end = groupByClause.getTextRange().getEndOffset();
            PsiElement last = groupByClause.getLastChild();
            boolean needComma = true;
            if (last == null) {
                needComma = false;
            } else {
                IElementType type = last.getNode().getElementType();
                if (type == TokenType.ERROR_ELEMENT || type == SqlCommonKeywords.SQL_GROUP || type == SqlCommonKeywords.SQL_BY) {
                    needComma = false;
                }
            }
            document.insertString(end, (CharSequence)((needComma ? "," : "") + " " + StringUtil.join(names, (String)", ")));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlShouldBeInGroupByInspection$AddToGroupByQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

