/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.database.model.DasTable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlQueryValidatorInspectionBase;
import com.intellij.sql.inspections.dataflow.SqlDataFlowInstructionVisitor;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlWithoutWhereInspection
extends SqlQueryValidatorInspectionBase {
    public boolean myDontWarnForSelfRefs = true;
    public boolean myDontWarnForLimit = true;
    public boolean myDontWarnForJoins = true;
    public boolean myDontWarnForTemporaryTable = true;
    public boolean myDontWarnForTrivialConditions = true;

    @Override
    protected SqlQueryValidatorInspectionBase.Visitor createVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly, final boolean isQueryValidationPass) {
        if (dialect == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(2);
        }
        return new SqlQueryValidatorInspectionBase.Visitor(manager, (SqlLanguageDialect)dialect, result, onTheFly, isQueryValidationPass){

            public void visitSqlUpdateStatement(SqlUpdateStatement o) {
                this.checkWherePresence((SqlStatement)o, SqlStatementType.UPDATE);
            }

            public void visitSqlDeleteStatement(SqlDeleteStatement o) {
                this.checkWherePresence((SqlStatement)o, SqlStatementType.DELETE);
            }

            private boolean dontWarnForSelfRefs() {
                return !isQueryValidationPass && SqlWithoutWhereInspection.this.myDontWarnForSelfRefs;
            }

            private boolean dontWarnForLimit() {
                return !isQueryValidationPass && SqlWithoutWhereInspection.this.myDontWarnForLimit;
            }

            private boolean dontWarnForJoins() {
                return !isQueryValidationPass && SqlWithoutWhereInspection.this.myDontWarnForJoins;
            }

            private boolean dontWarnForTemporaryTable() {
                return !isQueryValidationPass && SqlWithoutWhereInspection.this.myDontWarnForTemporaryTable;
            }

            private boolean dontWarnForTrivialConditions() {
                return !isQueryValidationPass && SqlWithoutWhereInspection.this.myDontWarnForTrivialConditions;
            }

            private void checkWherePresence(SqlStatement o, SqlStatementType statementType) {
                PsiElement root = this.findRootElement(o);
                if (root == null) {
                    return;
                }
                if (this.dontWarnForTemporaryTable() && root instanceof SqlDmlInstruction) {
                    PsiElement target;
                    SqlExpression expression = ((SqlDmlInstruction)root).getTargetExpression();
                    PsiElement psiElement = target = expression instanceof SqlReferenceExpression ? ((SqlReferenceExpression)expression).resolve() : null;
                    if (target instanceof DasTable && ((DasTable)target).isTemporary()) {
                        return;
                    }
                }
                String message = null;
                boolean hasSet = false;
                for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (PsiUtilCore.getElementType((PsiElement)child) == SqlCommonKeywords.SQL_WHERE) {
                        return;
                    }
                    if (child instanceof SqlWhereClause) {
                        SqlWhereClause whereClause = (SqlWhereClause)child;
                        if (this.dontWarnForTrivialConditions()) {
                            return;
                        }
                        SqlExpression condition = whereClause.getExpression();
                        SqlDataFlowInstructionVisitor.ConstantResult result = condition != null ? SqlDfaUtilKt.computeConstantExpression((SqlExpression)condition) : SqlDataFlowInstructionVisitor.ConstantResult.UNKNOWN;
                        switch (result) {
                            case TRUE: {
                                message = statementType == SqlStatementType.UPDATE ? SqlBundle.message((String)"update.where.always.true", (Object[])new Object[0]) : SqlBundle.message((String)"delete.where.always.true", (Object[])new Object[0]);
                                break;
                            }
                            case FALSE: {
                                message = statementType == SqlStatementType.UPDATE ? SqlBundle.message((String)"update.where.always.false", (Object[])new Object[0]) : SqlBundle.message((String)"delete.where.always.false", (Object[])new Object[0]);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (statementType == SqlStatementType.DELETE && child instanceof SqlReturningClause) {
                        return;
                    }
                    if (this.dontWarnForLimit() && child instanceof SqlClause && PsiUtilCore.getElementType((PsiElement)child.getFirstChild()) == SqlCommonKeywords.SQL_LIMIT) {
                        return;
                    }
                    if (statementType == SqlStatementType.UPDATE && (child instanceof SqlFromClause || this.dontWarnForSelfRefs() && child instanceof SqlSetClause && SqlImplUtil.sqlTraverser((PsiElement)child).children((Object)child).filter(SqlWithoutWhereInspection::hasOwnOrComplexRefs).isNotEmpty())) {
                        return;
                    }
                    if (child instanceof SqlSetClause) {
                        hasSet = true;
                    }
                    if (!this.dontWarnForJoins() || !(child instanceof SqlFromClause) || PsiTreeUtil.findChildOfType((PsiElement)child, SqlJoinConditionClause.class) == null) continue;
                    return;
                }
                if (statementType == SqlStatementType.UPDATE && !hasSet) {
                    return;
                }
                if (message == null) {
                    message = statementType == SqlStatementType.UPDATE ? SqlBundle.message((String)"update.without.where", (Object[])new Object[0]) : SqlBundle.message((String)"delete.without.where", (Object[])new Object[0]);
                }
                this.reportIssue(o.getFirstChild(), message);
            }

            @Nullable
            private PsiElement findRootElement(SqlStatement o) {
                SqlDmlInstruction dmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)o, SqlDmlInstruction.class);
                return dmlInstruction != null ? dmlInstruction : o;
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myDontWarnForLimit", (String)SqlBundle.message((String)"update.without.where.skip.limit", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myDontWarnForSelfRefs", (String)SqlBundle.message((String)"update.without.where.skip.self.refs", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myDontWarnForJoins", (String)SqlBundle.message((String)"checkbox.don.t.warn.if.there.exists.join.clause.with.condition", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myDontWarnForTemporaryTable", (String)SqlBundle.message((String)"checkbox.don.t.warn.if.statement.applied.to.temporary.table", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myDontWarnForTrivialConditions", (String)SqlBundle.message((String)"checkbox.don.t.warn.for.trivial.conditions", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    private static boolean hasReferencesTo(@NotNull PsiElement element, @NotNull PsiElement leftElement) {
        PsiReference psiReference;
        if (element == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(4);
        }
        if (leftElement == null) {
            SqlWithoutWhereInspection.$$$reportNull$$$0(5);
        }
        return (psiReference = element.getReference()) != null && psiReference.isReferenceTo(leftElement);
    }

    private static boolean hasOwnOrComplexRefs(@Nullable PsiElement assignment) {
        if (!(assignment instanceof SqlSetAssignment)) {
            return false;
        }
        SqlSetAssignment setAssignment = (SqlSetAssignment)assignment;
        SqlElement lvalue = setAssignment.getLValue();
        SqlElement rvalue = setAssignment.getRValue();
        if (rvalue == null) {
            return false;
        }
        if (!(lvalue instanceof SqlReferenceExpression)) {
            return true;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)lvalue;
        PsiElement leftElement = ref.getReference().resolve();
        if (leftElement == null) {
            return true;
        }
        return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)rvalue).filterTypes(e -> e == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE).filter(e -> SqlWithoutWhereInspection.hasReferencesTo(e, leftElement))).iterator().hasNext();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlWithoutWhereInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlWithoutWhereInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasReferencesTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static enum SqlStatementType {
        UPDATE,
        DELETE;

    }
}

