/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J\"\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/intentions/SqlFlipExpressionIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "isCommutative", "opType", "Lcom/intellij/psi/tree/IElementType;", "left", "Lcom/intellij/sql/psi/SqlExpression;", "right", "getCommutingOperator", "SqlFlipExpressionTokenSets", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlFlipExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFlipExpressionIntention.kt\ncom/intellij/sql/intentions/SqlFlipExpressionIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class SqlFlipExpressionIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.flip.expression.operands", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlBinaryExpression.class);
        if (sqlBinaryExpression == null) {
            return false;
        }
        SqlBinaryExpression expression = sqlBinaryExpression;
        SqlExpression sqlExpression = expression.getLOperand();
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
        SqlExpression left = sqlExpression;
        SqlExpression sqlExpression2 = expression.getROperand();
        if (sqlExpression2 == null) {
            return false;
        }
        SqlExpression right = sqlExpression2;
        PsiElement psiElement = expression.getOpSignElement();
        if (psiElement == null) {
            return false;
        }
        PsiElement opElement = psiElement;
        IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)opElement);
        if (iElementType == null) {
            return false;
        }
        IElementType op = iElementType;
        if (SqlImplUtil.hasNonEditableFragment((Document)editor.getDocument(), (PsiElement)((PsiElement)expression))) {
            return false;
        }
        Object[] objectArray = new Object[]{opElement.getText(), !this.isCommutative(op, left, right) && this.getCommutingOperator(op) == null ? 0 : 1};
        this.setText(SqlBundle.message((String)"flip.0.1.choice.0.may.change.semantics.1", (Object[])objectArray));
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlBinaryExpression.class);
        if (sqlBinaryExpression == null) {
            return;
        }
        SqlBinaryExpression expression = sqlBinaryExpression;
        SqlExpression sqlExpression = expression.getLOperand();
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
        SqlExpression left = sqlExpression;
        SqlExpression sqlExpression2 = expression.getROperand();
        if (sqlExpression2 == null) {
            return;
        }
        SqlExpression right = sqlExpression2;
        PsiElement psiElement = expression.getOpSignElement();
        if (psiElement == null) {
            return;
        }
        PsiElement op = psiElement;
        IElementType dualOp = this.getCommutingOperator(PsiTreeUtilKt.getElementType((PsiElement)op));
        if (dualOp != null) {
            SqlBinaryExpression dummyExpression;
            SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)expression));
            String dummyText = "foo " + dualOp + " bar";
            SqlExpression sqlExpression3 = SqlPsiElementFactory.createExpressionFromText((String)dummyText, (SqlLanguageDialect)((SqlLanguageDialect)dialect), (PsiElement)((PsiElement)expression));
            SqlBinaryExpression sqlBinaryExpression2 = dummyExpression = sqlExpression3 instanceof SqlBinaryExpression ? (SqlBinaryExpression)sqlExpression3 : null;
            if (dummyExpression != null) {
                PsiElement psiElement2 = dummyExpression.getOpSignElement();
                if (psiElement2 != null) {
                    PsiElement it = psiElement2;
                    boolean bl = false;
                    op.replace(it);
                }
            }
        }
        expression.addAfter((PsiElement)right, (PsiElement)left);
        expression.addBefore((PsiElement)left, (PsiElement)right);
        left.delete();
        right.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCommutative(IElementType opType, SqlExpression left, SqlExpression right) {
        if (!(opType instanceof SqlTokenType)) return false;
        if (!SqlFlipExpressionTokenSets.INSTANCE.getCOMMUTATIVE_OPERATOR_TYPES().contains(opType)) return false;
        DasType dasType = left.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasTypeCategory dasTypeCategory = DasTypeUtilsKt.getCategory((DasType)dasType);
        DasType dasType2 = right.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
        if (dasTypeCategory != DasTypeUtilsKt.getCategory((DasType)dasType2)) return false;
        return true;
    }

    private final IElementType getCommutingOperator(IElementType opType) {
        IElementType iElementType = opType;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GT) ? (IElementType)SqlCommonTokens.SQL_OP_LT : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LT) ? (IElementType)SqlCommonTokens.SQL_OP_GT : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GE) ? (IElementType)SqlCommonTokens.SQL_OP_LE : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LE) ? (IElementType)SqlCommonTokens.SQL_OP_GE : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_LE_WS) ? (IElementType)SqlCommonTokens.SQL_OP_GE_WS : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_GE_WS) ? (IElementType)SqlCommonTokens.SQL_OP_LE_WS : null)))));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/intentions/SqlFlipExpressionIntention$SqlFlipExpressionTokenSets;", "", "<init>", "()V", "COMMUTATIVE_OPERATOR_TYPES", "Lcom/intellij/psi/tree/TokenSet;", "getCOMMUTATIVE_OPERATOR_TYPES", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.database.sql.impl"})
    private static final class SqlFlipExpressionTokenSets {
        @NotNull
        public static final SqlFlipExpressionTokenSets INSTANCE = new SqlFlipExpressionTokenSets();
        @NotNull
        private static final TokenSet COMMUTATIVE_OPERATOR_TYPES;

        private SqlFlipExpressionTokenSets() {
        }

        @NotNull
        public final TokenSet getCOMMUTATIVE_OPERATOR_TYPES() {
            return COMMUTATIVE_OPERATOR_TYPES;
        }

        static {
            IElementType[] iElementTypeArray = new IElementType[]{SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_EQEQ, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2, SqlCommonTokens.SQL_OP_NEQ3, SqlCommonTokens.SQL_OP_NEQ4, SqlCommonTokens.SQL_OP_NEQ_WS, SqlCommonTokens.SQL_OP_NEQ2_WS, SqlCommonTokens.SQL_OP_NEQ3_WS, SqlCommonTokens.SQL_OP_NEQ4_WS, SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.PG_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonKeywords.SQL_AND, SqlCommonTokens.SQL_OP_LOGICAL_OR, SqlCommonKeywords.SQL_OR, SqlCommonTokens.SQL_OP_CONCAT};
            TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
            COMMUTATIVE_OPERATOR_TYPES = tokenSet;
        }
    }
}

