/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.debugger.dap;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.python.dap.run.DebugpyRunConfig;
import com.intellij.python.dap.run.ModuleOrProgram;
import com.intellij.python.dap.run.providers.TypedDebugpyConfigProvider;
import com.intellij.python.django.run.DjangoServerRunCommandLineState;
import com.intellij.python.django.run.DjangoServerRunConfiguration;
import com.jetbrains.django.ui.DjangoBundle;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/python/django/debugger/dap/DjangoServerRunConfigProvider;", "Lcom/intellij/python/dap/run/providers/TypedDebugpyConfigProvider;", "Lcom/intellij/python/django/run/DjangoServerRunConfiguration;", "<init>", "()V", "addCustomArgs", "Lcom/intellij/python/dap/run/DebugpyRunConfig;", "configuration", "commonConfig", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoServerRunConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoServerRunConfigProvider.kt\ncom/intellij/python/django/debugger/dap/DjangoServerRunConfigProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class DjangoServerRunConfigProvider
extends TypedDebugpyConfigProvider<DjangoServerRunConfiguration> {
    public DjangoServerRunConfigProvider() {
        super(Reflection.getOrCreateKotlinClass(DjangoServerRunConfiguration.class));
    }

    @NotNull
    public DebugpyRunConfig addCustomArgs(@NotNull DjangoServerRunConfiguration configuration, @NotNull DebugpyRunConfig commonConfig) {
        Object[] it;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)commonConfig, (String)"commonConfig");
        Object[] objectArray = DjangoServerRunCommandLineState.getWorkingDir(configuration);
        if (objectArray != null) {
            it = objectArray;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)((CharSequence)it))) {
                commonConfig.setCwd((String)it);
            }
        }
        commonConfig.setDjango(true);
        commonConfig.setJustMyCode(true);
        commonConfig.setSubProcess(true);
        String string = DjangoServerRunCommandLineState.getManageScriptPath(configuration.getModule(), configuration.getInterpreterPath());
        if (string == null) {
            it = new Object[]{"Can't find manage.py"};
            throw new ExecutionException(DjangoBundle.message((String)"manage.run.error", (Object[])it));
        }
        String manageScript = string;
        List<String> list = DjangoServerRunCommandLineState.getParametersForManageScript(configuration);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParametersForManageScript(...)");
        List<String> manageParams = list;
        List<String> list2 = DjangoServerRunCommandLineState.getHostPortParams(configuration);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getHostPortParams(...)");
        List<String> hostPortParams = list2;
        List list3 = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)configuration.getAdditionalOptions());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"expandMacrosAndParseParameters(...)");
        List additionalOptions = list3;
        commonConfig.getEnv().put("RUN_MAIN", "true");
        commonConfig.setTarget(new ModuleOrProgram.Program(manageScript).getPath());
        commonConfig.getArgs().addAll(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)manageParams, (Iterable)hostPortParams), (Iterable)additionalOptions));
        return commonConfig;
    }
}

