/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.intellij.jinja.template.psi.DjangoFilterName;
import com.intellij.jinja.template.psi.DjangoTagName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.python.django.lang.template.inspection.DjangoAddLoadTagQuickFix;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.stubs.PyDecoratorStubIndex;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u00a8\u0006\u0016"}, d2={"findTagRegistrations", "", "Lcom/jetbrains/python/psi/PyDecorator;", "tagName", "", "module", "Lcom/intellij/openapi/module/Module;", "proposeLoadFixForTag", "Lcom/intellij/python/django/lang/template/inspection/DjangoAddLoadTagQuickFix;", "tag", "Lcom/intellij/jinja/template/psi/DjangoTagName;", "proposeLoadFixForFilter", "filter", "Lcom/intellij/jinja/template/psi/DjangoFilterName;", "getDecoratorRegistrations", "Lkotlin/sequences/Sequence;", "registrationPattern", "nameArgPosition", "", "tagNameFromPosition", "argPosition", "decorator", "intellij.python.django"})
@JvmName(name="DjangoTagUtils")
public final class DjangoTagUtils {
    @NotNull
    public static final List<PyDecorator> findTagRegistrations(@NotNull String tagName, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Sequence allDecorators = SequencesKt.plus((Sequence)SequencesKt.plus(DjangoTagUtils.getDecoratorRegistrations("register.simple_tag", 2, tagName, module), DjangoTagUtils.getDecoratorRegistrations("register.tag", 0, tagName, module)), DjangoTagUtils.getDecoratorRegistrations("register.inclusion_tag", 3, tagName, module));
        return SequencesKt.toList((Sequence)allDecorators);
    }

    @Nullable
    public static final DjangoAddLoadTagQuickFix proposeLoadFixForTag(@NotNull DjangoTagName tag, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = tag.getTagName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
        List<PyDecorator> registrations = DjangoTagUtils.findTagRegistrations(string, module);
        return !((Collection)registrations).isEmpty() ? new DjangoAddLoadTagQuickFix((PsiElement)tag, registrations) : null;
    }

    @Nullable
    public static final DjangoAddLoadTagQuickFix proposeLoadFixForFilter(@NotNull DjangoFilterName filter, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = filter.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List registrations = SequencesKt.toList(DjangoTagUtils.getDecoratorRegistrations("register.filter", 0, string, module));
        return !((Collection)registrations).isEmpty() ? new DjangoAddLoadTagQuickFix((PsiElement)filter, registrations) : null;
    }

    private static final Sequence<PyDecorator> getDecoratorRegistrations(String registrationPattern, int nameArgPosition, String tagName, Module module) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope baseScope = globalSearchScope;
        GlobalSearchScope globalSearchScope2 = baseScope.union((SearchScope)module.getModuleContentScope());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"union(...)");
        GlobalSearchScope scope = globalSearchScope2;
        Collection collection = PyDecoratorStubIndex.find((String)registrationPattern, (Project)module.getProject(), (GlobalSearchScope)scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"find(...)");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> DjangoTagUtils.getDecoratorRegistrations$lambda$0(nameArgPosition, tagName, arg_0));
    }

    private static final String tagNameFromPosition(int argPosition, PyDecorator decorator) {
        Object object = (PyStringLiteralExpression)decorator.getArgument(argPosition, "name", PyStringLiteralExpression.class);
        if (object == null || (object = object.getStringValue()) == null) {
            PyFunction pyFunction = decorator.getTarget();
            object = pyFunction != null ? pyFunction.getName() : null;
        }
        return object;
    }

    private static final boolean getDecoratorRegistrations$lambda$0(int $nameArgPosition, String $tagName, PyDecorator it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)DjangoTagUtils.tagNameFromPosition($nameArgPosition, it), (Object)$tagName);
    }
}

