/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.logical.codeGenerator;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.codeGen.DjangoCodeSupplier;
import com.intellij.python.django.codeGen.DjangoModCommandFactory;
import com.intellij.python.django.logical.codeGenerator.DjangoLogicalStructureCodeGeneratorService;
import com.intellij.python.django.logical.models.DjangoModelLModel;
import com.intellij.python.django.packages.restFramework.DjangoSerializerForModelCodeSupplier;
import com.intellij.python.django.ref.admin.DjangoAdminForModelCodeSupplier;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.psi.PyClass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/django/logical/codeGenerator/DjangoLogicalStructureTemplateCodeGeneratorService;", "Lcom/intellij/python/django/logical/codeGenerator/DjangoLogicalStructureCodeGeneratorService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "actionText", "", "getActionText", "()Ljava/lang/String;", "generateTemplate", "", "djangoLModel", "Lcom/intellij/python/django/logical/models/DjangoModelLModel;", "progressTitle", "codeSupplier", "Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;", "generateAdminForModel", "generateSerializerForModel", "intellij.python.django"})
public final class DjangoLogicalStructureTemplateCodeGeneratorService
implements DjangoLogicalStructureCodeGeneratorService {
    @NotNull
    private final Project project;
    @NotNull
    private final String actionText;

    public DjangoLogicalStructureTemplateCodeGeneratorService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        String string = DjangoBundle.message((String)"django.presentation.empty.node.create.entity", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.actionText = string;
    }

    @Override
    @NotNull
    public String getActionText() {
        return this.actionText;
    }

    private final void generateTemplate(DjangoModelLModel djangoLModel, @NlsSafe String progressTitle, DjangoCodeSupplier codeSupplier) {
        PyClass djangoModelPyClass = djangoLModel.getDjangoModelClass().getPyClass();
        PsiElement psiElement = djangoModelPyClass.getIdentifyingElement();
        if (psiElement == null) {
            return;
        }
        ActionContext context = ActionContext.from(null, (PsiFile)djangoModelPyClass.getContainingFile()).withElement(psiElement);
        ModCommand modCommand = (ModCommand)ActionUtil.underModalProgress((Project)this.project, (String)progressTitle, () -> DjangoLogicalStructureTemplateCodeGeneratorService.generateTemplate$lambda$0(context, djangoModelPyClass, codeSupplier));
        PsiFile[] psiFileArray = new PsiFile[]{djangoModelPyClass.getContainingFile()};
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])psiFileArray).run(() -> DjangoLogicalStructureTemplateCodeGeneratorService.generateTemplate$lambda$1(context, modCommand));
    }

    @Override
    public void generateAdminForModel(@NotNull DjangoModelLModel djangoLModel) {
        Intrinsics.checkNotNullParameter((Object)djangoLModel, (String)"djangoLModel");
        DjangoAdminForModelCodeSupplier codeSupplier = new DjangoAdminForModelCodeSupplier(djangoLModel.getDjangoModelClass());
        String string = DjangoBundle.message((String)"django.register.model.in.admin.intention.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.generateTemplate(djangoLModel, string, codeSupplier);
    }

    @Override
    public void generateSerializerForModel(@NotNull DjangoModelLModel djangoLModel) {
        Intrinsics.checkNotNullParameter((Object)djangoLModel, (String)"djangoLModel");
        DjangoSerializerForModelCodeSupplier codeSupplier = new DjangoSerializerForModelCodeSupplier(djangoLModel.getDjangoModelClass());
        String string = DjangoBundle.message((String)"django.create.serializer.for.model", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.generateTemplate(djangoLModel, string, codeSupplier);
    }

    private static final ModCommand generateTemplate$lambda$0(ActionContext $context, PyClass $djangoModelPyClass, DjangoCodeSupplier $codeSupplier) {
        Intrinsics.checkNotNull((Object)$context);
        return DjangoModCommandFactory.INSTANCE.create($context, (PsiElement)$djangoModelPyClass, $codeSupplier);
    }

    private static final void generateTemplate$lambda$1(ActionContext $context, ModCommand $modCommand) {
        ModCommandExecutor.getInstance().executeInteractively($context, $modCommand, null);
    }
}

