/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref.admin;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.codeGen.DjangoFileCreationUtils;
import com.intellij.python.django.codeGen.DjangoResolvedPlace;
import com.intellij.python.django.util.DjangoUtil;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModelUtil;
import com.jetbrains.django.model.modelApi.DjangoAdminClass;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0002J \u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/python/django/ref/admin/DjangoAdminModelUtil;", "", "<init>", "()V", "getRegisterDecorator", "", "modelClassName", "generateRegisterDecorator", "Lcom/jetbrains/python/psi/PyDecoratorList;", "project", "Lcom/intellij/openapi/project/Project;", "generateAdminModelPsiForModel", "Lcom/jetbrains/python/psi/PyClass;", "djangoModelClass", "Lcom/jetbrains/django/model/modelApi/DjangoModelClass;", "generateAdminClassName", "updateImportsForAdminModel", "", "adminFile", "Lcom/intellij/psi/PsiFile;", "adminModelClassPsi", "Lcom/intellij/psi/PsiElement;", "updateImportForQualifiedName", "file", "qualifiedName", "anchor", "findRegisteredModelsInApp", "", "Lkotlin/Pair;", "Lcom/jetbrains/django/model/modelApi/DjangoAdminClass;", "djangoAppModel", "Lcom/jetbrains/django/model/applications/DjangoUnnamedApplicationModel;", "findNotRegisteredModelsInApp", "findAdminFileForModel", "Lcom/intellij/python/django/codeGen/DjangoResolvedPlace;", "modelClass", "intellij.python.django"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDjangoAdminModelUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoAdminModelUtil.kt\ncom/intellij/python/django/ref/admin/DjangoAdminModelUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n777#2:129\n873#2,2:130\n1391#2:132\n1480#2,2:133\n1586#2:135\n1661#2,3:136\n1482#2,3:139\n777#2:142\n873#2,2:143\n1586#2:145\n1661#2,3:146\n*S KotlinDebug\n*F\n+ 1 DjangoAdminModelUtil.kt\ncom/intellij/python/django/ref/admin/DjangoAdminModelUtil\n*L\n84#1:129\n84#1:130,2\n87#1:132\n87#1:133,2\n89#1:135\n89#1:136,3\n87#1:139,3\n99#1:142\n99#1:143,2\n103#1:145\n103#1:146,3\n*E\n"})
public final class DjangoAdminModelUtil {
    @NotNull
    public static final DjangoAdminModelUtil INSTANCE = new DjangoAdminModelUtil();

    private DjangoAdminModelUtil() {
    }

    private final String getRegisterDecorator(String modelClassName) {
        return "@admin.register(" + modelClassName + ")";
    }

    @NotNull
    public final PyDecoratorList generateRegisterDecorator(@NotNull String modelClassName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modelClassName, (String)"modelClassName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)project);
        String[] stringArray = new String[]{this.getRegisterDecorator(modelClassName)};
        PyDecoratorList pyDecoratorList = elementFactory.createDecoratorList(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)pyDecoratorList, (String)"createDecoratorList(...)");
        return pyDecoratorList;
    }

    @NotNull
    public final PyClass generateAdminModelPsiForModel(@NotNull DjangoModelClass djangoModelClass) {
        Intrinsics.checkNotNullParameter((Object)djangoModelClass, (String)"djangoModelClass");
        String string = djangoModelClass.getPyClass().getName();
        if (string == null) {
            string = "";
        }
        String modelClassName = string;
        PyElementGenerator elementFactory = PyElementGenerator.getInstance((Project)djangoModelClass.getPyClass().getProject());
        String djangoAdminModelCode = StringsKt.trimIndent((String)("\n" + this.getRegisterDecorator(modelClassName) + "\nclass " + this.generateAdminClassName(modelClassName) + "(admin.ModelAdmin):\n    pass\n"));
        Object object = elementFactory.createFromText(LanguageLevel.forElement((PsiElement)((PsiElement)djangoModelClass.getPyClass())), PyClass.class, djangoAdminModelCode);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createFromText(...)");
        return (PyClass)object;
    }

    @NotNull
    public final String generateAdminClassName(@NotNull String modelClassName) {
        Intrinsics.checkNotNullParameter((Object)modelClassName, (String)"modelClassName");
        return modelClassName + "Admin";
    }

    public final void updateImportsForAdminModel(@NotNull PsiFile adminFile, @Nullable DjangoModelClass djangoModelClass, @NotNull PsiElement adminModelClassPsi) {
        Intrinsics.checkNotNullParameter((Object)adminFile, (String)"adminFile");
        Intrinsics.checkNotNullParameter((Object)adminModelClassPsi, (String)"adminModelClassPsi");
        DjangoModelClass djangoModelClass2 = djangoModelClass;
        if (djangoModelClass2 != null) {
            DjangoModelClass it = djangoModelClass2;
            boolean bl = false;
            INSTANCE.updateImportForQualifiedName(adminFile, it.getPyClass().getQualifiedName(), adminModelClassPsi);
        }
        this.updateImportForQualifiedName(adminFile, "django.contrib.admin", adminModelClassPsi);
    }

    private final void updateImportForQualifiedName(PsiFile file, String qualifiedName, PsiElement anchor) {
        String string = PythonStringUtil.removeLastSuffix((String)qualifiedName, (String)".");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeLastSuffix(...)");
        String from = string;
        String name = PythonStringUtil.getLastSuffix((String)qualifiedName, (String)".");
        AddImportHelper.addOrUpdateFromImportStatement((PsiFile)file, (String)from, (String)name, null, null, (PsiElement)anchor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Pair<DjangoModelClass, DjangoAdminClass>> findRegisteredModelsInApp(@NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)djangoAppModel.getApplicationRootFolder().getProject(), (PsiFile)((PsiFile)djangoAppModel.getModel()));
        List list = djangoAppModel.getAdminClasses(typeEvalContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAdminClasses(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DjangoAdminClass it = (DjangoAdminClass)element$iv$iv;
            boolean bl = false;
            if (!it.isDefinedInApplication(djangoAppModel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List admins = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = admins;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DjangoAdminClass djangoAdminClass = (DjangoAdminClass)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)typeEvalContext);
            Iterable iterable2 = djangoAdminClass.getRegisteredModels(typeEvalContext);
            boolean $i$f$map = false;
            void var16_21 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DjangoModelClass djangoModelClass = (DjangoModelClass)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)djangoAdminClass));
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set registeredModels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return registeredModels;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<DjangoModelClass> findNotRegisteredModelsInApp(@NotNull DjangoUnnamedApplicationModel djangoAppModel) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)djangoAppModel, (String)"djangoAppModel");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)djangoAppModel.getApplicationRootFolder().getProject(), (PsiFile)((PsiFile)djangoAppModel.getModel()));
        List list = djangoAppModel.getModelClasses(typeEvalContext);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModelClasses(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DjangoModelClass it = (DjangoModelClass)element$iv$iv;
            boolean bl = false;
            if (!it.isDefinedInApplication(djangoAppModel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set models = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = this.findRegisteredModelsInApp(djangoAppModel);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((DjangoModelClass)it.getFirst());
        }
        Set registeredModels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Set notRegisteredModels = SetsKt.minus((Set)models, (Iterable)registeredModels);
        return notRegisteredModels;
    }

    @Nullable
    public final DjangoResolvedPlace findAdminFileForModel(@NotNull DjangoModelClass modelClass) {
        Intrinsics.checkNotNullParameter((Object)modelClass, (String)"modelClass");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)modelClass.getPyClass().getProject(), (PsiFile)modelClass.getPyClass().getContainingFile());
        Intrinsics.checkNotNull((Object)typeEvalContext);
        DjangoAdminClass registeredModelAdmin = (DjangoAdminClass)CollectionsKt.firstOrNull((List)DjangoAdminClass.Companion.findForModel(modelClass, typeEvalContext));
        if (registeredModelAdmin != null) {
            return new DjangoResolvedPlace.AlreadyExists(registeredModelAdmin.getAdminClass());
        }
        Module module = DjangoUtil.getDjangoModule((Project)modelClass.getPyClass().getProject());
        if (module == null) {
            return null;
        }
        Module module2 = module;
        List installedApps = DjangoUnnamedApplicationModelUtil.INSTANCE.collectInstalledAppsInProjectSync(module2);
        PsiFile psiFile = modelClass.getPyClass().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        DjangoUnnamedApplicationModel djangoAppModel = DjangoUnnamedApplicationModelUtil.INSTANCE.createFromFileInsideApp(psiFile, installedApps);
        DjangoUnnamedApplicationModel djangoUnnamedApplicationModel = djangoAppModel;
        if ((djangoUnnamedApplicationModel == null || (djangoUnnamedApplicationModel = djangoUnnamedApplicationModel.getApplicationRootFolder()) == null) && (djangoUnnamedApplicationModel = modelClass.getPyClass().getContainingFile().getContainingDirectory()) == null) {
            return null;
        }
        DjangoUnnamedApplicationModel parentDirectory = djangoUnnamedApplicationModel;
        return DjangoFileCreationUtils.INSTANCE.resolvePlace(modelClass.getPyClass(), (PsiDirectory)parentDirectory, "admin");
    }
}

