/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.structure.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016JV\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/python/django/structure/statistics/DjangoStructurePerformanceCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "TOTAL_BUILD_DURATION_MS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "APPS_COLLECTION_DURATION_MS_FIELD", "MODELS_COLLECTION_DURATION_MS_FIELD", "ADMINS_COLLECTION_DURATION_MS_FIELD", "VIEWS_COLLECTION_DURATION_MS_FIELD", "APPS_COUNT_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "MODELS_COUNT_FIELD", "ADMINS_COUNT_FIELD", "VIEWS_COUNT_FIELD", "FIRST_BUILD_FINISHED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "onFirstBuiltFinished", "", "project", "Lcom/intellij/openapi/project/Project;", "totalBuildDurationNano", "", "appsCollectionDurationNano", "modelCollectionDurationNano", "adminCollectionDurationNano", "viewCollectionDurationNano", "appsCount", "", "modelsCount", "adminsCount", "viewsCount", "intellij.python.django"})
public final class DjangoStructurePerformanceCollector
extends CounterUsagesCollector {
    @NotNull
    public static final DjangoStructurePerformanceCollector INSTANCE = new DjangoStructurePerformanceCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("django.structure.performance", 2, null, 4, null);
    @NotNull
    private static final LongEventField TOTAL_BUILD_DURATION_MS_FIELD = EventFields.Long$default((String)"total_build_duration_ms", null, (int)2, null);
    @NotNull
    private static final LongEventField APPS_COLLECTION_DURATION_MS_FIELD = EventFields.Long$default((String)"apps_collection_duration_ms", null, (int)2, null);
    @NotNull
    private static final LongEventField MODELS_COLLECTION_DURATION_MS_FIELD = EventFields.Long$default((String)"models_collection_duration_ms", null, (int)2, null);
    @NotNull
    private static final LongEventField ADMINS_COLLECTION_DURATION_MS_FIELD = EventFields.Long$default((String)"admins_collection_duration_ms", null, (int)2, null);
    @NotNull
    private static final LongEventField VIEWS_COLLECTION_DURATION_MS_FIELD = EventFields.Long$default((String)"views_collection_duration_ms", null, (int)2, null);
    @NotNull
    private static final RoundedIntEventField APPS_COUNT_FIELD = EventFields.RoundedInt((String)"apps_count");
    @NotNull
    private static final RoundedIntEventField MODELS_COUNT_FIELD = EventFields.RoundedInt((String)"models_count");
    @NotNull
    private static final RoundedIntEventField ADMINS_COUNT_FIELD = EventFields.RoundedInt((String)"admins_count");
    @NotNull
    private static final RoundedIntEventField VIEWS_COUNT_FIELD = EventFields.RoundedInt((String)"views_count");
    @NotNull
    private static final VarargEventId FIRST_BUILD_FINISHED_EVENT;

    private DjangoStructurePerformanceCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void onFirstBuiltFinished(@NotNull Project project, long totalBuildDurationNano, long appsCollectionDurationNano, long modelCollectionDurationNano, long adminCollectionDurationNano, long viewCollectionDurationNano, int appsCount, int modelsCount, int adminsCount, int viewsCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EventPair[] eventPairArray = new EventPair[]{TOTAL_BUILD_DURATION_MS_FIELD.with((Object)TimeUnit.NANOSECONDS.toMillis(totalBuildDurationNano)), APPS_COLLECTION_DURATION_MS_FIELD.with((Object)TimeUnit.NANOSECONDS.toMillis(appsCollectionDurationNano)), MODELS_COLLECTION_DURATION_MS_FIELD.with((Object)TimeUnit.NANOSECONDS.toMillis(modelCollectionDurationNano)), ADMINS_COLLECTION_DURATION_MS_FIELD.with((Object)TimeUnit.NANOSECONDS.toMillis(adminCollectionDurationNano)), VIEWS_COLLECTION_DURATION_MS_FIELD.with((Object)TimeUnit.NANOSECONDS.toMillis(viewCollectionDurationNano)), APPS_COUNT_FIELD.with((Object)appsCount), MODELS_COUNT_FIELD.with((Object)modelsCount), ADMINS_COUNT_FIELD.with((Object)adminsCount), VIEWS_COUNT_FIELD.with((Object)viewsCount)};
        FIRST_BUILD_FINISHED_EVENT.log(project, eventPairArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{TOTAL_BUILD_DURATION_MS_FIELD, APPS_COLLECTION_DURATION_MS_FIELD, MODELS_COLLECTION_DURATION_MS_FIELD, ADMINS_COLLECTION_DURATION_MS_FIELD, VIEWS_COLLECTION_DURATION_MS_FIELD, APPS_COUNT_FIELD, MODELS_COUNT_FIELD, ADMINS_COUNT_FIELD, VIEWS_COUNT_FIELD};
        FIRST_BUILD_FINISHED_EVENT = GROUP.registerVarargEvent("first.build.finished", eventFieldArray);
    }
}

