/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.structure.ui.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.python.django.codeGen.DjangoCodeSupplier;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.parser.icons.PythonParserIcons;
import com.jetbrains.python.psi.LanguageLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/django/structure/ui/action/AddCodeInFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "codeSupplier", "Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;", "<init>", "(Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;)V", "getFileToAddCode", "Lcom/intellij/psi/PsiFile;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "navigateToAddedPsiElement", "psiElement", "Lcom/intellij/psi/PsiElement;", "startRenameElementAction", "psiNameIdentifierOwner", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "CreateFileAndAddCodeAction", "UpdateFileWithCodeAction", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nAddCodeInFileAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddCodeInFileAction.kt\ncom/intellij/python/django/structure/ui/action/AddCodeInFileAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,114:1\n19#2:115\n19#2:116\n*S KotlinDebug\n*F\n+ 1 AddCodeInFileAction.kt\ncom/intellij/python/django/structure/ui/action/AddCodeInFileAction\n*L\n49#1:115\n55#1:116\n*E\n"})
public abstract class AddCodeInFileAction
extends AnAction {
    @NotNull
    private final DjangoCodeSupplier codeSupplier;

    public AddCodeInFileAction(@NotNull DjangoCodeSupplier codeSupplier) {
        Intrinsics.checkNotNullParameter((Object)codeSupplier, (String)"codeSupplier");
        this.codeSupplier = codeSupplier;
    }

    @NotNull
    public abstract PsiFile getFileToAddCode();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            PsiElement psiElement = (PsiElement)WriteCommandAction.writeCommandAction((Project)project2).compute(() -> AddCodeInFileAction.actionPerformed$lambda$0(this));
            Intrinsics.checkNotNull((Object)psiElement);
            this.navigateToAddedPsiElement(psiElement);
            PsiElement $this$asSafely$iv = psiElement;
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof PsiNameIdentifierOwner)) {
                psiElement2 = null;
            }
            PsiNameIdentifierOwner psiNameIdentifierOwner = (PsiNameIdentifierOwner)psiElement2;
            if (psiNameIdentifierOwner == null) break block2;
            PsiNameIdentifierOwner psiNameIdentifierOwner2 = psiNameIdentifierOwner;
            boolean bl = false;
            this.startRenameElementAction(psiNameIdentifierOwner2);
        }
    }

    protected final void navigateToAddedPsiElement(@NotNull PsiElement psiElement) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            PsiElement $this$asSafely$iv = psiElement;
            boolean $i$f$asSafely = false;
            PsiElement psiElement2 = $this$asSafely$iv;
            if (!(psiElement2 instanceof NavigatablePsiElement)) {
                psiElement2 = null;
            }
            NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)psiElement2;
            if (navigatablePsiElement == null) break block1;
            navigatablePsiElement.navigate(true);
        }
    }

    protected final void startRenameElementAction(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner) {
        Intrinsics.checkNotNullParameter((Object)psiNameIdentifierOwner, (String)"psiNameIdentifierOwner");
        Project project = psiNameIdentifierOwner.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, psiNameIdentifierOwner.getContainingFile().getVirtualFile()), true);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)((PsiElement)psiNameIdentifierOwner));
        Intrinsics.checkNotNullExpressionValue((Object)renamePsiElementProcessor, (String)"forElement(...)");
        RenamePsiElementProcessor processor = renamePsiElementProcessor;
        if (!processor.isInplaceRenameSupported()) {
            return;
        }
        PsiElement psiElement = psiNameIdentifierOwner.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        editor2.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
        MemberInplaceRenamer renamer = new MemberInplaceRenamer((PsiNamedElement)psiNameIdentifierOwner, (PsiElement)psiNameIdentifierOwner, editor2);
        renamer.performInplaceRename();
    }

    private static final PsiElement actionPerformed$lambda$0(AddCodeInFileAction this$0) {
        PsiFile psiFile = this$0.getFileToAddCode();
        DjangoCodeSupplier djangoCodeSupplier = this$0.codeSupplier;
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)((PsiElement)psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"forElement(...)");
        PsiElement codeToAdd = djangoCodeSupplier.generateCode(languageLevel);
        PsiElement addedElement = this$0.codeSupplier.updateFile(psiFile, codeToAdd);
        this$0.codeSupplier.updateImports(psiFile, addedElement);
        return addedElement;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/django/structure/ui/action/AddCodeInFileAction$CreateFileAndAddCodeAction;", "Lcom/intellij/python/django/structure/ui/action/AddCodeInFileAction;", "fileName", "", "directory", "Lcom/intellij/psi/PsiDirectory;", "codeSupplier", "Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;)V", "getFileToAddCode", "Lcom/intellij/psi/PsiFile;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.django"})
    public static final class CreateFileAndAddCodeAction
    extends AddCodeInFileAction {
        @NotNull
        private final String fileName;
        @NotNull
        private final PsiDirectory directory;

        public CreateFileAndAddCodeAction(@NotNull String fileName, @NotNull PsiDirectory directory, @NotNull DjangoCodeSupplier codeSupplier) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)codeSupplier, (String)"codeSupplier");
            super(codeSupplier);
            this.fileName = fileName;
            this.directory = directory;
        }

        @Override
        @NotNull
        public PsiFile getFileToAddCode() {
            PsiFile psiFile = this.directory.createFile(this.fileName);
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFile(...)");
            return psiFile;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
            boolean bl = false;
            Object[] objectArray = new Object[]{this.fileName};
            $this$update_u24lambda_u240.setText(DjangoBundle.message((String)"action.django.structure.create.file", (Object[])objectArray));
            $this$update_u24lambda_u240.setIcon(PythonParserIcons.PythonFile);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/python/django/structure/ui/action/AddCodeInFileAction$UpdateFileWithCodeAction;", "Lcom/intellij/python/django/structure/ui/action/AddCodeInFileAction;", "fileToUpdate", "Lcom/intellij/psi/PsiFile;", "codeSupplier", "Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/python/django/codeGen/DjangoCodeSupplier;)V", "getFileToAddCode", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.django"})
    public static final class UpdateFileWithCodeAction
    extends AddCodeInFileAction {
        @NotNull
        private final PsiFile fileToUpdate;

        public UpdateFileWithCodeAction(@NotNull PsiFile fileToUpdate, @NotNull DjangoCodeSupplier codeSupplier) {
            Intrinsics.checkNotNullParameter((Object)fileToUpdate, (String)"fileToUpdate");
            Intrinsics.checkNotNullParameter((Object)codeSupplier, (String)"codeSupplier");
            super(codeSupplier);
            this.fileToUpdate = fileToUpdate;
        }

        @Override
        @NotNull
        public PsiFile getFileToAddCode() {
            return this.fileToUpdate;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation $this$update_u24lambda_u240 = presentation = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u240.setText(this.fileToUpdate.getName());
            $this$update_u24lambda_u240.setIcon(PythonParserIcons.PythonFile);
        }
    }
}

