/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.platform.diagnostics.adapters.nativeServer;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.ConnectionAddress;
import com.intellij.ml.inline.completion.impl.diagnostic.GrpcChannelState;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionNativeServerEventsReporter;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessStarted;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessTerminated;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.time.LocalDateTime;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.model.remote.NativeServerDiagnosticCallback;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/completion/full/line/impl/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic;", "Lorg/jetbrains/completion/full/line/local/generation/model/remote/NativeServerDiagnosticCallback;", "logger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionNativeServerEventsReporter;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionNativeServerEventsReporter;)V", "logsHistory", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "writeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "grpcChannelStateChanged", "", "connectivityState", "startNotified", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processTerminated", "processWillTerminate", "willBeDestroyed", "", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "updateHistory", "newMessage", "getLogsAttachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "connectionAddress", "hostname", "port", "", "Companion", "intellij.fullLine.core.impl"})
@SourceDebugExtension(value={"SMAP\nNativeServerDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeServerDiagnostic.kt\norg/jetbrains/completion/full/line/impl/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic\n+ 2 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n50#2:83\n13#3:84\n*S KotlinDebug\n*F\n+ 1 NativeServerDiagnostic.kt\norg/jetbrains/completion/full/line/impl/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic\n*L\n80#1:83\n80#1:84\n*E\n"})
public final class NativeServerDiagnostic
implements NativeServerDiagnosticCallback {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final MLCompletionNativeServerEventsReporter logger;
    @NotNull
    private final LinkedBlockingQueue<String> logsHistory;
    @NotNull
    private final ReentrantLock writeLock;
    @Deprecated
    public static final int MAX_HISTORY_SIZE = 1000;
    @NotNull
    private static final Logger LOG;

    public NativeServerDiagnostic(@NotNull MLCompletionNativeServerEventsReporter logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.logsHistory = new LinkedBlockingQueue();
        this.writeLock = new ReentrantLock();
    }

    public void grpcChannelStateChanged(@NotNull String connectivityState) {
        Intrinsics.checkNotNullParameter((Object)connectivityState, (String)"connectivityState");
        String message = "New GRPC channel state is " + connectivityState;
        MLCompletionLogger.box-impl(LOG).debug(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.fire(new GrpcChannelState(connectivityState));
    }

    public void startNotified(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server is started";
        MLCompletionLogger.box-impl(LOG).info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.fire(ProcessStarted.INSTANCE);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server is terminated with exit code " + event.getExitCode();
        MLCompletionLogger.box-impl(LOG).info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.fire(new ProcessTerminated(event.getExitCode()));
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server will be terminated. Will be destroyed: " + willBeDestroyed;
        MLCompletionLogger.box-impl(LOG).info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String message = event.getText();
        if (ProcessOutputType.isStderr(outputType)) {
            MLCompletionLogger mLCompletionLogger = MLCompletionLogger.box-impl(LOG);
            Intrinsics.checkNotNull((Object)message);
            DiagnosticsLogger.warn$default((DiagnosticsLogger)mLCompletionLogger, (String)message, null, (int)2, null);
        } else {
            MLCompletionLogger mLCompletionLogger = MLCompletionLogger.box-impl(LOG);
            Intrinsics.checkNotNull((Object)message);
            mLCompletionLogger.debug(message);
        }
        this.updateHistory(message, outputType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHistory(String newMessage, String outputType) {
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            while (this.logsHistory.size() > 1000) {
                this.logsHistory.poll();
            }
            LocalDateTime localDateTime = LocalDateTime.now();
            String string = outputType;
            if (string == null) {
                string = "EVENT";
            }
            this.logsHistory.put("[" + localDateTime + ", " + string + "] " + newMessage);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    static /* synthetic */ void updateHistory$default(NativeServerDiagnostic nativeServerDiagnostic, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nativeServerDiagnostic.updateHistory(string, string2);
    }

    @NotNull
    public Attachment getLogsAttachment() {
        return new Attachment("inference_service.log", CollectionsKt.joinToString$default((Iterable)this.logsHistory, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    public void connectionAddress(@NotNull String hostname, int port) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String message = "Full line native server address is " + hostname + ":" + port;
        MLCompletionLogger.box-impl(LOG).info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.fire(new ConnectionAddress(hostname, port));
    }

    static {
        Companion $this$thisMLCompletionLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisMLCompletionLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = MLCompletionLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/impl/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic$Companion;", "", "<init>", "()V", "MAX_HISTORY_SIZE", "", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

