/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.sql.common.impl.formatter.settings;

import com.intellij.database.sql.common.impl.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.lang.Language;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ResourceUtil;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/sql/common/impl/formatter/settings/SqlPreviewExamples;", "", "<init>", "()V", "read", "", "dialect", "Lcom/intellij/lang/Language;", "type", "Lcom/intellij/database/sql/common/impl/formatter/settings/SqlCodeStyleSettingsType;", "intellij.database.sql.common.impl"})
public final class SqlPreviewExamples {
    @NotNull
    public static final SqlPreviewExamples INSTANCE = new SqlPreviewExamples();

    private SqlPreviewExamples() {
    }

    @JvmStatic
    @NotNull
    public static final String read(@NotNull Language dialect, @NotNull SqlCodeStyleSettingsType type) {
        SqlLanguageDialect sqlLanguageDialect;
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Language language = dialect;
        if (language instanceof SqlLanguage) {
            sqlLanguageDialect = SqlCodeStyles.getGenericDialect();
            if (sqlLanguageDialect == null) {
                return "-- Generic dialect is not initialized";
            }
        } else if (language instanceof SqlLanguageDialect) {
            sqlLanguageDialect = (SqlLanguageDialect)dialect;
        } else {
            return "-- No preview file for " + dialect;
        }
        SqlLanguageDialect d = sqlLanguageDialect;
        String string = type.code;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"code");
        String code = string;
        Class<?> dialectClass = d.getClass();
        String string2 = dialectClass.getPackage().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String path = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/preview";
        String resourceName = "preview-" + code + ".sql";
        InputStream inputStream = ResourceUtil.getResourceAsStream((ClassLoader)dialectClass.getClassLoader(), (String)path, (String)resourceName);
        if (inputStream == null) {
            return "-- no preview text resource " + path + "/" + resourceName;
        }
        InputStream resourceStream = inputStream;
        String string3 = ResourceUtil.loadText((InputStream)resourceStream);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"loadText(...)");
        return string3;
    }
}

