/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.history.FileHistoryDiffProcessor;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.actions.history.CompareRevisionsFromFileHistoryActionProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\u0018\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\rH\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "fileHistoryPanel", "Lcom/intellij/vcs/log/history/FileHistoryPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/history/FileHistoryPanel;)V", "getEditorTabName", "", "processor", "Lcom/intellij/diff/impl/DiffEditorViewer;", "hasContent", "", "createViewer", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "updateDiffAction", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryEditorDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    private final FileHistoryPanel fileHistoryPanel;

    public FileHistoryEditorDiffPreview(@NotNull Project project, @NotNull FileHistoryPanel fileHistoryPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileHistoryPanel, (String)"fileHistoryPanel");
        super(project);
        this.fileHistoryPanel = fileHistoryPanel;
    }

    @NotNull
    protected String getEditorTabName(@Nullable DiffEditorViewer processor) {
        Object[] objectArray = new Object[]{this.fileHistoryPanel.getFilePath().getName()};
        String string = VcsLogBundle.message("file.history.diff.preview.editor.tab.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean hasContent() {
        return this.fileHistoryPanel.getSelectedChange() != null;
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        FileHistoryDiffProcessor fileHistoryDiffProcessor = this.fileHistoryPanel.createDiffPreview(true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)fileHistoryDiffProcessor), (String)"createDiffPreview(...)");
        return (DiffEditorViewer)fileHistoryDiffProcessor;
    }

    @NotNull
    protected ListSelection<? extends DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        List changes = CollectionsKt.listOfNotNull((Object)this.fileHistoryPanel.getSelectedChange());
        ListSelection listSelection = ListSelection.createAt((List)changes, (int)0).withExplicitSelection(selectedOnly).map(arg_0 -> FileHistoryEditorDiffPreview.collectDiffProducers$lambda$1(arg_0 -> FileHistoryEditorDiffPreview.collectDiffProducers$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
        return listSelection;
    }

    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)event.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return;
        }
        VcsLogCommitSelection selection = vcsLogCommitSelection;
        CompareRevisionsFromFileHistoryActionProvider.setTextAndDescription(event, selection);
    }

    private static final ChangeDiffRequestProducer collectDiffProducers$lambda$0(FileHistoryEditorDiffPreview this$0, Change change) {
        return ChangeDiffRequestProducer.create((Project)this$0.getProject(), (Change)change);
    }

    private static final ChangeDiffRequestProducer collectDiffProducers$lambda$1(Function1 $tmp0, Object p0) {
        return (ChangeDiffRequestProducer)$tmp0.invoke(p0);
    }
}

