/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/history/FileHistorySpeedSearch;", "Lcom/intellij/vcs/log/ui/table/IndexSpeedSearch;", "project", "Lcom/intellij/openapi/project/Project;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "component", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/index/VcsLogIndex;Lcom/intellij/vcs/log/data/VcsLogStorage;Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "value", "Lcom/intellij/vcs/log/visible/VisiblePack;", "visiblePack", "getVisiblePack", "()Lcom/intellij/vcs/log/visible/VisiblePack;", "setVisiblePack", "(Lcom/intellij/vcs/log/visible/VisiblePack;)V", "isSpeedSearchEnabled", "", "getCommitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "row", "", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileHistorySpeedSearch
extends IndexSpeedSearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VisiblePack visiblePack;
    @NotNull
    private static final Key<Int2ObjectMap<VcsCommitMetadata>> COMMIT_METADATA;

    public FileHistorySpeedSearch(@NotNull Project project, @NotNull VcsLogIndex index, @NotNull VcsLogStorage storage, @NotNull VcsLogGraphTable component) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(project, index, storage, component);
        this.visiblePack = VisiblePack.EMPTY;
    }

    @NotNull
    public final VisiblePack getVisiblePack() {
        return this.visiblePack;
    }

    public final void setVisiblePack(@NotNull VisiblePack value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.visiblePack = value;
        this.refreshSelection();
    }

    @Override
    protected boolean isSpeedSearchEnabled() {
        return true;
    }

    @Override
    @Nullable
    protected VcsCommitMetadata getCommitMetadata(int row) {
        Int2ObjectMap<VcsCommitMetadata> int2ObjectMap = this.visiblePack.getUserData(COMMIT_METADATA);
        if (int2ObjectMap == null) {
            return super.getCommitMetadata(row);
        }
        Int2ObjectMap<VcsCommitMetadata> commits = int2ObjectMap;
        Integer n = this.getCommitId(row);
        if (n == null) {
            return null;
        }
        int commitId = n;
        VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)commits.get(commitId);
        if (vcsCommitMetadata == null) {
            return super.getCommitMetadata(row);
        }
        return vcsCommitMetadata;
    }

    static {
        Key key = Key.create((String)"FileHistory.CommitMetadata");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMMIT_METADATA = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/history/FileHistorySpeedSearch$Companion;", "", "<init>", "()V", "COMMIT_METADATA", "Lcom/intellij/openapi/util/Key;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCOMMIT_METADATA$intellij_platform_vcs_log_impl", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Int2ObjectMap<VcsCommitMetadata>> getCOMMIT_METADATA$intellij_platform_vcs_log_impl() {
            return COMMIT_METADATA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

